/*
 * Decompiled with CFR 0.152.
 */
package jfig.utils;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import jfig.utils.ExceptionTracer;

public class TmpFile {
    public static File getTmpFile() {
        File file = TmpFile.getTmpDir();
        if (file == null) {
            return null;
        }
        File file2 = TmpFile.getTmpFile(file);
        return file2;
    }

    public static File getTmpDir() {
        String string = System.getProperty("os.name").toLowerCase();
        File file = null;
        if (string.indexOf("solaris") >= 0) {
            file = new File("/tmp");
        } else if (string.indexOf("linux") >= 0) {
            file = new File("/tmp");
        } else if (string.indexOf("windows") >= 0 && !(file = new File("C:/tmp")).exists()) {
            file = new File("C:/temp");
        }
        try {
            if (file == null || !file.isDirectory()) {
                file = new File(System.getProperty("user.dir"));
            }
        }
        catch (Exception exception) {
            ExceptionTracer.trace(exception);
            System.err.println("Cannot find a writeable directory, sorry!");
            return null;
        }
        return file;
    }

    public static File getTmpFileInCurrentDir() {
        File file = null;
        try {
            file = new File(System.getProperty("user.dir"));
        }
        catch (Throwable throwable) {
            ExceptionTracer.trace(throwable);
            System.err.println("Cannot find a writeable directory, sorry!");
            return null;
        }
        return TmpFile.getTmpFile(file);
    }

    public static File getTmpFile(File file) {
        File file2 = null;
        String string = "tmp";
        boolean bl = false;
        int n = 0;
        while (!bl) {
            file2 = new File(file, string + n);
            if (!file2.exists()) {
                return file2;
            }
            if (++n <= 999) continue;
            return null;
        }
        return null;
    }

    public static void main(String[] stringArray) throws Exception {
        System.out.println("TmpFile selftest... (10 files) ");
        int n = 0;
        while (n < 10) {
            File file = TmpFile.getTmpFile();
            System.out.println("" + n + " " + file);
            PrintWriter printWriter = new PrintWriter(new FileWriter(file));
            printWriter.println("hugo" + n);
            printWriter.flush();
            ++n;
        }
        System.out.println("ready.");
    }
}

