/*
 * Decompiled with CFR 0.152.
 */
package jfig.utils;

public class ShellSort {
    public static void shellSort(double[] dArray, Object[] objectArray) {
        int n = dArray.length;
        int n2 = 1;
        while (n2 <= n / 9) {
            n2 = 3 * n2 + 1;
        }
        while (n2 > 0) {
            int n3 = n2 + 1;
            while (n3 <= n) {
                double d = dArray[n3 - 1];
                Object object = objectArray[n3 - 1];
                int n4 = n3 - 1;
                while (n4 > n2 - 1 && dArray[n4 - n2] > d) {
                    dArray[n4] = dArray[n4 - n2];
                    objectArray[n4] = objectArray[n4 - n2];
                    n4 -= n2;
                }
                dArray[n4] = d;
                objectArray[n4] = object;
                ++n3;
            }
            n2 /= 3;
        }
    }

    public static void shellSort(int[] nArray) {
        int n = nArray.length;
        int n2 = 1;
        while (n2 <= n / 9) {
            n2 = 3 * n2 + 1;
        }
        while (n2 > 0) {
            int n3 = n2 + 1;
            while (n3 <= n) {
                int n4 = nArray[n3 - 1];
                int n5 = n3 - 1;
                while (n5 > n2 - 1 && nArray[n5 - n2] > n4) {
                    nArray[n5] = nArray[n5 - n2];
                    n5 -= n2;
                }
                nArray[n5] = n4;
                ++n3;
            }
            n2 /= 3;
        }
    }

    public static void shellSort(String[] stringArray) {
        int n = stringArray.length;
        int n2 = 1;
        while (n2 <= n / 9) {
            n2 = 3 * n2 + 1;
        }
        while (n2 > 0) {
            int n3 = n2 + 1;
            while (n3 <= n) {
                String string = stringArray[n3 - 1];
                int n4 = n3 - 1;
                while (n4 > n2 - 1 && stringArray[n4 - n2].compareTo(string) > 0) {
                    stringArray[n4] = stringArray[n4 - n2];
                    n4 -= n2;
                }
                stringArray[n4] = string;
                ++n3;
            }
            n2 /= 3;
        }
    }

    private static void msg(String string) {
        System.out.println(string);
    }

    public static void main(String[] stringArray) {
        System.out.println("Shellsort self test started...");
        int n = 0;
        if (stringArray.length < 1) {
            System.out.println("Usage: java Shellsort <arraylength> [doPrint]");
            return;
        }
        n = Integer.parseInt(stringArray[0]);
        System.out.println("generating random strings...");
        String[] stringArray2 = new String[n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = 100000 + (int)(10000.0 * Math.random());
            stringArray2[n2] = "" + n3;
            ++n2;
        }
        System.out.println("sorting...");
        ShellSort.shellSort(stringArray2);
        System.out.println("ready:");
        n2 = 0;
        while (n2 < n) {
            System.out.println(stringArray2[n2]);
            ++n2;
        }
        System.out.println("...generating random numbers...");
        double[] dArray = new double[n];
        Object[] objectArray = new Double[n];
        double d = 0.0;
        int n4 = 0;
        while (n4 < n) {
            dArray[n4] = (int)(100000.0 * Math.random());
            objectArray[n4] = new Double(dArray[n4]);
            ++n4;
        }
        n4 = 0;
        while (n4 < n) {
            d += dArray[n4];
            ++n4;
        }
        System.out.println("...sorting...");
        ShellSort.shellSort(dArray, objectArray);
        System.out.println("...checking...");
        double d2 = 0.0;
        int n5 = 0;
        while (n5 < n) {
            double d3 = (Double)objectArray[n5];
            if (dArray[n5] != d3) {
                ShellSort.msg("d[i] != o[i]: " + dArray[n5] + " " + objectArray[n5]);
            }
            if (n5 > 0 && dArray[n5] < dArray[n5 - 1]) {
                ShellSort.msg("not sorted: " + dArray[n5] + " " + dArray[n5 - 1]);
            }
            d2 += d3;
            ++n5;
        }
        if (d != d2) {
            ShellSort.msg("checksum mismatch: " + d + " " + d2);
        }
        if (stringArray.length >= 2) {
            n5 = 0;
            while (n5 < n) {
                System.out.println(n5 + " " + dArray[n5] + " " + objectArray[n5]);
                ++n5;
            }
        }
        System.out.println("ok.");
    }
}

