/*
 * Decompiled with CFR 0.152.
 */
package jfig.utils;

import java.util.Random;

public final class RegistrationKeyManager {
    private static RegistrationKeyManager singleton;
    private static Random generator;
    private static final String zeroKeyString = "0000-0000-0000-0000-0000-0000";
    private static final int versionID = 10003;
    private static final boolean debug = false;
    private static final char[] _hex;
    private boolean valid = false;
    private boolean lock = false;
    private int[] scramble = null;

    public static final RegistrationKeyManager getRegistrationKeyManager() {
        if (singleton == null) {
            singleton = new RegistrationKeyManager();
        }
        return singleton;
    }

    public final int getVersionID() {
        return 10003;
    }

    public final int response(int n) {
        return n << 2 ^ 0x2713;
    }

    public final void setKey(String string) {
        if (this.lock) {
            return;
        }
        this.parseAndCheck(string);
        this.lock = true;
    }

    public final boolean isValid() {
        return this.valid;
    }

    public final boolean isValidForProperty(String string) {
        return this.valid;
    }

    private final int r(int n, int n2) {
        int n3 = n2 & 0xF;
        int n4 = n << n3 & 0xFFFF | (n << n3 & 0xFFFF0000) >>> 16;
        return n4;
    }

    private final int g(int n, int n2) {
        return n2 + ((0x573 ^ n + ((n & 0xF) << 8)) & 0xFFF);
    }

    private final int h(int n, int n2) {
        return this.scramble[this.g(n, n2)];
    }

    private final void parseAndCheck(String string) {
        int n;
        int[] nArray = null;
        try {
            nArray = new int[6];
            int n2 = 0;
            while (n2 < 6) {
                nArray[n2] = Integer.parseInt(string.substring(5 * n2, 5 * n2 + 4), 16);
                ++n2;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            System.out.println("-E- invalid registration key format: " + string);
            this.valid = false;
            this.lock = true;
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("-E- invalid registration key format: " + string);
            this.valid = false;
            this.lock = true;
        }
        this.scramble = new int[65536];
        int n3 = 0;
        while (n3 < this.scramble.length) {
            this.scramble[n3] = generator.nextInt() & 0xFFFF;
            ++n3;
        }
        n3 = 4096 + (generator.nextInt() & 0xFFF);
        int n4 = 0;
        int n5 = 0;
        while (n5 < nArray.length) {
            n4 = this.g(n5, n3);
            this.scramble[n4] = nArray[n5];
            ++n5;
        }
        n5 = 0;
        while (n5 < 256) {
            this.scramble[this.g((int)n5, (int)0)] = n5;
            ++n5;
        }
        n4 = this.scramble[this.g(this.h(0, 0), n3)] ^ this.scramble[this.g(this.h(1, 0), n3)];
        if (n4 % this.scramble[this.g(137, 0)] != this.scramble[this.g(14, 0)]) {
            this.valid = false;
            this.lock = true;
            return;
        }
        n4 = ~this.scramble[this.g(this.h(1, 0), n3)] & 0xFFFF;
        if (n4 % (this.h(253, 0) + 4) != this.h(81, 0)) {
            this.valid = false;
            this.lock = true;
            return;
        }
        n4 = this.scramble[this.g(this.h(2, 0), n3)] ^ this.scramble[this.g(this.h(1, 0), n3)];
        if (this.r(n4, 2) % this.h(134, 0) != this.h(5, 0)) {
            this.valid = false;
            this.lock = true;
            return;
        }
        n4 = this.scramble[this.g(this.h(3, 0), n3)] ^ this.scramble[this.g(this.h(1, 0), n3)];
        if (this.r(n4, 11) % (this.h(212, 0) + 11) != this.h(7, 0)) {
            this.valid = false;
            this.lock = true;
            return;
        }
        n4 = this.scramble[this.g(this.h(3, 0) + 1, n3)] ^ this.scramble[this.g(this.h(7, 0) - 4, n3)];
        if ((~n4 & 0xFFFF) % this.scramble[this.g(157, 0)] != 10) {
            this.valid = false;
            this.lock = true;
            return;
        }
        n5 = this.r(nArray[0], 17);
        n4 = (n5 ^ nArray[1]) + (nArray[2] ^ (n = this.r(nArray[3], 2))) + (nArray[4] ^ 0xAB13);
        if (nArray[5] != (n4 & 0xFFFF)) {
            this.valid = false;
            this.lock = true;
            return;
        }
        this.valid = true;
    }

    public void print(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < nArray.length) {
            stringBuffer.append("-" + nArray[n]);
            ++n;
        }
        stringBuffer.append("-");
        System.err.println(stringBuffer.toString());
    }

    public void getKeyFromProperty(String string) {
        String string2 = System.getProperty(string);
        this.parseAndCheck(string2);
    }

    public static void checkKeyGen(int n, int n2) {
        System.out.println("checkKeyGen: " + n + " " + n2);
        int n3 = 0;
        int n4 = 0;
        while (n4 < 65535) {
            int n5 = 0;
            while (n5 < 65535) {
                if (n5 + 3 == n4 + 5) {
                    ++n3;
                }
                n5 += n2;
            }
            n4 += n;
        }
        System.out.println("...total matches: " + n3 + "\n");
    }

    public static void main(String[] stringArray) {
        RegistrationKeyManager registrationKeyManager = new RegistrationKeyManager();
        registrationKeyManager.parseAndCheck(stringArray[0]);
        System.out.println(registrationKeyManager.isValid() ? "valid key" : "invalid key");
        System.exit(0);
    }

    private RegistrationKeyManager() {
    }

    static {
        generator = new Random();
        _hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    }
}

