/*
 * Decompiled with CFR 0.152.
 */
package jfig.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import jfig.utils.ShellSort;

public class PresentationBuilder {
    ZipOutputStream ZOS = null;
    File baseDir = null;
    Vector figFiles = new Vector();
    Vector allFiles = new Vector();
    boolean debug = false;

    public void createZipOutputStream(String string) throws Exception {
        this.ZOS = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(string)));
    }

    public void closeZipOutputStream() throws Exception {
        this.ZOS.flush();
        this.ZOS.close();
    }

    public void setBaseDir(File file) {
        this.baseDir = file;
    }

    public void findFigOrImageFiles(File file) throws Exception {
        String[] stringArray = file.list();
        File[] fileArray = null;
        ShellSort.shellSort(stringArray);
        fileArray = new File[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            fileArray[n] = new File(file, stringArray[n]);
            ++n;
        }
        n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n].toLowerCase();
            if (fileArray[n].isFile()) {
                if (string.endsWith(".fig")) {
                    this.figFiles.addElement(fileArray[n]);
                    this.allFiles.addElement(fileArray[n]);
                } else if (string.endsWith(".gif") || string.endsWith(".jpg") || string.endsWith(".jpeg") || string.endsWith(".png") || string.endsWith(".xbm")) {
                    this.allFiles.addElement(fileArray[n]);
                }
            }
            ++n;
        }
        n = 0;
        while (n < stringArray.length) {
            if (fileArray[n].isDirectory() && !stringArray[n].endsWith(".xvpics")) {
                this.findFigOrImageFiles(fileArray[n]);
            }
            ++n;
        }
    }

    public void findAndAddFiles(String string) throws Exception {
        this.setBaseDir(new File(string));
        this.findFigOrImageFiles(this.baseDir);
        this.writeJptZipEntry();
        this.addFigFilesToZip();
    }

    public void findAllFiles(String string) throws Exception {
        this.setBaseDir(new File(string));
        this.findFigOrImageFiles(this.baseDir);
    }

    public void findPSFiles(File file) throws Exception {
        String[] stringArray = file.list();
        File[] fileArray = null;
        ShellSort.shellSort(stringArray);
        fileArray = new File[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            fileArray[n] = new File(file, stringArray[n]);
            ++n;
        }
        n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n].toLowerCase();
            if (fileArray[n].isFile() && (string.endsWith(".ps") || string.endsWith(".eps"))) {
                this.figFiles.addElement(fileArray[n]);
            }
            ++n;
        }
        n = 0;
        while (n < stringArray.length) {
            if (fileArray[n].isDirectory()) {
                this.findPSFiles(fileArray[n]);
            }
            ++n;
        }
    }

    public void writeZipEntry_OLD(String string) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(string);
        byte[] byArray = new byte[1024];
        int n = 0;
        int n2 = 0;
        while ((n = fileInputStream.read(byArray, 0, byArray.length)) >= 0) {
            this.ZOS.write(byArray, 0, n);
            n2 += n;
        }
        fileInputStream.close();
        System.out.println("wrote " + n2 + " bytes from " + string);
    }

    public void addFigFilesToZip() throws Exception {
        FileInputStream fileInputStream = null;
        byte[] byArray = new byte[1024];
        int n = 0;
        int n2 = 0;
        Enumeration enumeration = this.allFiles.elements();
        while (enumeration.hasMoreElements()) {
            File file = (File)enumeration.nextElement();
            ZipEntry zipEntry = new ZipEntry(this.getRelativeFilename(file));
            this.ZOS.putNextEntry(zipEntry);
            fileInputStream = new FileInputStream(file);
            n2 = 0;
            while ((n = fileInputStream.read(byArray, 0, byArray.length)) >= 0) {
                this.ZOS.write(byArray, 0, n);
                n2 += n;
            }
            fileInputStream.close();
            System.out.println("wrote " + n2 + " bytes from " + file);
            this.ZOS.closeEntry();
        }
    }

    public String getRelativeFilename(File file) {
        String string = file.getPath().substring(this.baseDir.getPath().length() + 1);
        String string2 = string.replace(File.separatorChar, '/');
        return string2;
    }

    public String getChapterName(File file) {
        String string = this.getRelativeFilename(file);
        String string2 = string.replace('\\', '/');
        int n = string2.lastIndexOf(47);
        if (n == -1) {
            return "no chapter";
        }
        String string3 = string2.substring(0, n);
        int n2 = string3.lastIndexOf(47);
        String string4 = string3.substring(n2 + 1, n);
        if (this.debug) {
            System.out.println();
            System.out.println("'" + file + "'");
            System.out.println(string);
            System.out.println(string2);
            System.out.println(string3);
            System.out.println(string4);
        }
        return string4;
    }

    public void writeJptZipEntry() throws Exception {
        String string = this.generateJpt();
        StringReader stringReader = new StringReader(string);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(this.ZOS);
        ZipEntry zipEntry = new ZipEntry("00presentation.jpt");
        this.ZOS.putNextEntry(zipEntry);
        char[] cArray = new char[1024];
        int n = 0;
        while ((n = stringReader.read(cArray, 0, cArray.length)) >= 0) {
            outputStreamWriter.write(cArray, 0, n);
        }
        outputStreamWriter.flush();
        this.ZOS.closeEntry();
    }

    public String generateJpt() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("#jfig presentation\n");
        stringBuffer.append("# created by " + this.getClass().getName() + " on " + new Date() + "\n");
        stringBuffer.append("#\n");
        String string = this.baseDir.getPath();
        String string2 = null;
        Enumeration enumeration = this.figFiles.elements();
        while (enumeration.hasMoreElements()) {
            File file = (File)enumeration.nextElement();
            String string3 = file.getName();
            String string4 = this.getRelativeFilename(file);
            String string5 = this.getChapterName(file);
            if (string2 == null || !string2.equals(string5)) {
                string2 = string5;
                stringBuffer.append("# \n");
                stringBuffer.append("chapter title=\"" + string5 + "\"\n");
            }
            stringBuffer.append("slide title=\"" + string3.substring(0, string3.length() - 4) + "\" " + "href=\"" + string4 + "\"\n");
        }
        return stringBuffer.toString();
    }

    public String generateTeX() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("% FIG file slidelist\n");
        stringBuffer.append("% created by " + this.getClass().getName() + " on " + new Date() + "\n");
        stringBuffer.append("%\n");
        int n = 0;
        String string = this.baseDir.getPath();
        Enumeration enumeration = this.figFiles.elements();
        while (enumeration.hasMoreElements()) {
            if (n % 4 == 0) {
                stringBuffer.append("\n");
                stringBuffer.append("\\fourpage%\n");
                n = 0;
            }
            ++n;
            File file = (File)enumeration.nextElement();
            String string2 = file.getName();
            String string3 = this.getRelativeFilename(file);
            stringBuffer.append("../" + string3 + ",\n");
        }
        while (n < 4) {
            stringBuffer.append("null.ps,\n");
            ++n;
        }
        return stringBuffer.toString();
    }

    public void copyAllFilesFromZipArchive(String string) throws IOException {
        byte[] byArray = new byte[1024];
        int n = 0;
        System.out.println("copying files from " + string);
        ZipFile zipFile = new ZipFile(string);
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = null;
            try {
                zipEntry = enumeration.nextElement();
                System.out.println("copying entry: " + zipEntry.getName() + " " + zipEntry.getSize());
                InputStream inputStream = zipFile.getInputStream(zipEntry);
                this.ZOS.putNextEntry(zipEntry);
                while ((n = inputStream.read(byArray, 0, byArray.length)) >= 0) {
                    this.ZOS.write(byArray, 0, n);
                }
                this.ZOS.closeEntry();
                inputStream.close();
            }
            catch (Exception exception) {
                System.out.println("-W- Could not copy Zip entry: " + zipEntry);
            }
        }
    }

    public void copySingleFile(String string, String string2) throws IOException {
        byte[] byArray = new byte[1024];
        int n = 0;
        System.out.println("copying file " + string2);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string2));
        this.ZOS.putNextEntry(new ZipEntry(string));
        while ((n = ((InputStream)bufferedInputStream).read(byArray, 0, byArray.length)) >= 0) {
            this.ZOS.write(byArray, 0, n);
        }
        this.ZOS.closeEntry();
        ((InputStream)bufferedInputStream).close();
    }

    public void createMainClassManifestEntry() throws IOException {
        StringReader stringReader = new StringReader("Manifest-Version: 1.0\nMain-Class: jfig.gui.PresentationViewer\n");
        char[] cArray = new char[1024];
        int n = 0;
        System.out.println("adding MainClass Manifest entry 'jfig.gui.PresentationViewer'...");
        ZipEntry zipEntry = new ZipEntry("META-INF/MANIFEST.MF");
        this.ZOS.putNextEntry(zipEntry);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(this.ZOS);
        while ((n = stringReader.read(cArray, 0, cArray.length)) >= 0) {
            outputStreamWriter.write(cArray, 0, n);
        }
        outputStreamWriter.flush();
        this.ZOS.closeEntry();
    }

    public static void usage() {
        System.out.println("Usage: java jfig.utils.PresentationBuilder <cmd> [<filenames>]\nwhere command is one of the following:\n-jpt <directory>\n-tex <directory>\n-jar <outfile> <directory> <jfigjar>\n-jar <outfile> <directory> <jfigjar> <jptfile>\n\nExample 1: collect .fig files and generate .jpt index file:\njava jfig.utils.PresentationBuilder -jpt /home/joe/oopsla2005 > oopsla2005.jpt\nExample 2: collect files below working directory and generate JAR archive:\njava jfig.utils.PresentationBuilder -jar oopsla.jar . jfig-viewer.zip\njava -jar oopsla.jar\n");
        System.exit(0);
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            PresentationBuilder.usage();
        }
        try {
            PresentationBuilder presentationBuilder = new PresentationBuilder();
            if (stringArray[0].equals("-jpt")) {
                presentationBuilder.findAllFiles(stringArray[1]);
                System.out.print(presentationBuilder.generateJpt());
            } else if (stringArray[0].equals("-tex")) {
                File file = new File(stringArray[1]);
                presentationBuilder.setBaseDir(file);
                presentationBuilder.findPSFiles(file);
                System.out.print(presentationBuilder.generateTeX());
            } else if (stringArray[0].equals("-jar")) {
                presentationBuilder.createZipOutputStream(stringArray[1]);
                presentationBuilder.findAllFiles(stringArray[2]);
                if (stringArray.length == 5) {
                    presentationBuilder.copySingleFile("00presentation.jpt", stringArray[4]);
                } else {
                    presentationBuilder.writeJptZipEntry();
                }
                presentationBuilder.addFigFilesToZip();
                presentationBuilder.createMainClassManifestEntry();
                presentationBuilder.copyAllFilesFromZipArchive(stringArray[3]);
                presentationBuilder.closeZipOutputStream();
            } else {
                PresentationBuilder.usage();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println();
            PresentationBuilder.usage();
        }
    }
}

