/*
 * Decompiled with CFR 0.152.
 */
package jfig.utils;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.ScrollPane;
import java.awt.image.PixelGrabber;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Date;
import jfig.gui.ImageCanvas;
import jfig.utils.PPMReader;

public class PPMWriter {
    int width;
    int height;
    int maxvalue;
    int[] pixels;
    boolean debug = true;

    public void writePPM(Image image, DataOutputStream dataOutputStream) throws Exception {
        if (image == null) {
            throw new Exception("PPMWriter: null image");
        }
        if (dataOutputStream == null) {
            throw new Exception("PPMWriter: null stream");
        }
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        int n3 = 0;
        int n4 = 0;
        int[] nArray = new int[n * n2];
        PixelGrabber pixelGrabber = new PixelGrabber(image, n3, n4, n, n2, nArray, 0, n);
        pixelGrabber.grabPixels();
        dataOutputStream.writeBytes("P6\n");
        dataOutputStream.writeBytes("# PPMWriter " + new Date() + "\n");
        dataOutputStream.writeBytes("" + n + " " + n2 + "\n");
        dataOutputStream.writeBytes("255\n");
        int n5 = 0;
        while (n5 < nArray.length) {
            int n6 = nArray[n5];
            int n7 = n6 >> 16 & 0xFF;
            int n8 = n6 >> 8 & 0xFF;
            int n9 = n6 & 0xFF;
            dataOutputStream.write(n7);
            dataOutputStream.write(n8);
            dataOutputStream.write(n9);
            ++n5;
        }
    }

    public static void usage() {
        System.err.println("Usage: java PPMWriter filename.ppm");
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        Object object;
        if (stringArray.length < 1) {
            PPMWriter.usage();
        }
        String string = stringArray[0];
        Frame frame = new Frame("PPMWriter: " + string);
        frame.setSize(new Dimension(400, 400));
        frame.show();
        Image image = null;
        try {
            object = new FileInputStream(string);
            image = new PPMReader().getPPMImage(frame, (InputStream)object);
        }
        catch (Exception exception) {
            System.err.println("Got an exception: " + exception);
            System.exit(1);
        }
        object = new ImageCanvas(image);
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.add((Component)object);
        frame.add("Center", scrollPane);
        frame.pack();
        System.out.println("now writing to tmp.ppm...");
        try {
            PPMWriter pPMWriter = new PPMWriter();
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream("tmp.ppm")));
            pPMWriter.writePPM(image, dataOutputStream);
            dataOutputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        System.out.println("ok.");
    }
}

