/*
 * Decompiled with CFR 0.152.
 */
package jfig.utils;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.ScrollPane;
import java.awt.image.MemoryImageSource;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.StringTokenizer;
import jfig.gui.ImageCanvas;

public class PPMReader {
    int width;
    int height;
    int maxvalue;
    int[] pixels;
    boolean debug = true;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Image getPPMImage(Component component, InputStream inputStream) throws Exception {
        Image image = null;
        BufferedReader bufferedReader = null;
        String string = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        }
        catch (Throwable throwable) {
            this.close(bufferedReader);
            throw new Exception("PPMReader: no input stream: '" + inputStream + "'");
        }
        try {
            string = bufferedReader.readLine();
            if (!string.equals("P6")) {
                throw new IOException("Not a PPM raw file!: " + string);
            }
            while ((string = bufferedReader.readLine()) != null) {
                if (string.charAt(0) == '#') continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                this.width = Integer.parseInt(stringTokenizer.nextToken());
                this.height = Integer.parseInt(stringTokenizer.nextToken());
                break;
            }
            if (this.debug) {
                System.out.print("PPM " + this.width + "x" + this.height + ", parsing... ");
                System.out.flush();
            }
            this.pixels = new int[this.width * this.height];
            this.maxvalue = Integer.parseInt(bufferedReader.readLine());
        }
        catch (Exception exception) {
            this.close(bufferedReader);
            throw new Exception("PPMReader: " + exception.toString());
        }
        try {
            int n;
            int n2 = n = 900;
            char[] cArray = new char[n];
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = this.pixels.length;
            int n7 = n;
            int n8 = 0;
            while (true) {
                if (n8 >= n6) {
                    this.close(bufferedReader);
                    break;
                }
                if (n7 >= n) {
                    n7 = 0;
                    n = bufferedReader.read(cArray, 0, cArray.length);
                }
                n3 = 0xFF & cArray[n7];
                if (++n7 >= n) {
                    n7 = 0;
                    n = bufferedReader.read(cArray, 0, cArray.length);
                }
                n4 = 0xFF & cArray[n7];
                if (++n7 >= n) {
                    n7 = 0;
                    n = bufferedReader.read(cArray, 0, cArray.length);
                }
                n5 = 0xFF & cArray[n7];
                ++n7;
                this.pixels[n8] = 0xFF000000 | n3 << 16 | n4 << 8 | n5;
                ++n8;
            }
        }
        catch (Exception exception) {
            this.close(bufferedReader);
            throw new Exception("PPMReader: image file too short");
        }
        try {
            if (this.debug) {
                System.out.print("constructing image... ");
                System.out.flush();
            }
            image = component.createImage(new MemoryImageSource(this.width, this.height, this.pixels, 0, this.width));
        }
        catch (Exception exception) {
            throw new Exception("PPMReader: AWT could not create image.");
        }
        if (this.debug) {
            System.out.println("ok.");
        }
        return image;
    }

    private void close(Reader reader) {
        try {
            reader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void usage() {
        System.err.println("Usage: java PPMReader filename.ppm");
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        Object object;
        if (stringArray.length < 1) {
            PPMReader.usage();
        }
        String string = stringArray[0];
        Frame frame = new Frame("PPMReader: " + string);
        frame.setSize(new Dimension(400, 400));
        frame.show();
        Image image = null;
        try {
            object = new FileInputStream(string);
            image = new PPMReader().getPPMImage(frame, (InputStream)object);
        }
        catch (Exception exception) {
            System.err.println("Got an exception: " + exception);
            System.exit(1);
        }
        object = new ImageCanvas(image);
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.add((Component)object);
        frame.add("Center", scrollPane);
        frame.pack();
    }
}

