/*
 * Decompiled with CFR 0.152.
 */
package jfig.utils;

import com.lowagie.text.Document;
import com.lowagie.text.PageSize;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDestination;
import com.lowagie.text.pdf.PdfOutline;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Canvas;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import jfig.canvas.FigTrafo2D;
import jfig.gui.FontCache;
import jfig.objects.FigAttribs;
import jfig.objects.FigBbox;
import jfig.objects.FigImage;
import jfig.objects.FigObject;
import jfig.objects.FigObjectList;
import jfig.objects.FigParser;
import jfig.utils.BoundingBoxCalculator;
import jfig.utils.ItextFontMapper;
import jfig.utils.ItextPDFWriter;
import jfig.utils.PresentationParser;
import jfig.utils.SetupManager;

public class ItextPresentationPDFWriter {
    public static final int SLEEP_MILLIS = 1000;
    FigObjectList objectList = new FigObjectList();
    FigTrafo2D trafo = new FigTrafo2D();
    FigAttribs attributes = new FigAttribs();
    FigParser parser = new FigParser();
    PresentationParser presentationParser = new PresentationParser();
    OutputStream outputStream;
    ItextFontMapper mapper;
    PdfWriter pdfWriter;
    PdfContentByte cb;
    Document document;
    Rectangle bounds;
    BaseFont font1;
    BaseFont font2;
    boolean fourUpMode = false;
    int pagenumber = 1;

    public void openPresentation(String string) {
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            this.presentationParser.parse(fileInputStream);
            this.presentationParser.dumpData();
        }
        catch (Exception exception) {
            ItextPresentationPDFWriter.msg("-E- in openPresentationJAR: " + exception);
            System.exit(0);
        }
    }

    public void writePDF() throws Exception {
        this.writeHeader();
        int n = this.presentationParser.getNumberOfSlides();
        int n2 = 0;
        while (n2 < n) {
            String string = this.presentationParser.getSlide(n2);
            ItextPresentationPDFWriter.msg("-#- parsing: " + string);
            this.parseSlide(string);
            this.waitForTheImages();
            this.makeBufferedImagesWithoutAlpha();
            this.writeOnePage(n2);
            ++n2;
        }
        this.writeTestPage();
        this.writeTrailer();
    }

    public void openOutputStream(String string) throws Exception {
        this.outputStream = new FileOutputStream(string);
    }

    public void parseSlide(String string) {
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            this.parser.setFilenameAndType(string, "FILE");
            this.objectList = new FigObjectList();
            this.parser.parse_fig_file_not_threaded(fileInputStream, true, false, false, this.attributes, this.trafo, this.objectList);
            ((InputStream)fileInputStream).close();
        }
        catch (Throwable throwable) {
            ItextPresentationPDFWriter.msg("-E- in parseSlide: " + throwable);
        }
    }

    public void writeHeader() throws Exception {
        this.bounds = new Rectangle(PageSize.A4.rotate());
        this.document = new Document(this.bounds, 0.0f, 0.0f, 0.0f, 0.0f);
        this.document.addTitle("My presentation");
        this.document.addSubject("jfig presentation");
        this.document.addAuthor("Norman Hendrich");
        this.pdfWriter = PdfWriter.getInstance((Document)this.document, (OutputStream)this.outputStream);
        this.document.open();
        this.mapper = new ItextFontMapper();
        try {
            String string = "/opt/jdk142/jre/lib/fonts/";
            String string2 = "Identity-H";
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void waitForTheImages() throws Exception {
        MediaTracker mediaTracker = new MediaTracker(new Canvas());
        int n = 0;
        Enumeration enumeration = this.objectList.elements();
        while (enumeration.hasMoreElements()) {
            FigObject figObject = (FigObject)enumeration.nextElement();
            if (!(figObject instanceof FigImage)) continue;
            mediaTracker.addImage(((FigImage)figObject).getImage(), ++n);
        }
        ItextPresentationPDFWriter.msg("... waiting for " + n + " image(s)...");
        mediaTracker.waitForAll();
    }

    public void waitForTheImages_ASYNC() throws Exception {
        BufferedImage bufferedImage = new BufferedImage(200, 200, 2);
        Graphics graphics = bufferedImage.getGraphics();
        this.trafo.setAnchor(new Point(0, 0));
        this.trafo.set_zoom(0.1);
        boolean bl = false;
        Enumeration enumeration = this.objectList.elements();
        while (enumeration.hasMoreElements()) {
            FigObject figObject = (FigObject)enumeration.nextElement();
            figObject.paint(graphics);
            if (!(figObject instanceof FigImage)) continue;
            bl = true;
        }
        if (bl) {
            Thread.sleep(1000L);
        }
    }

    public void makeBufferedImagesWithoutAlpha() {
        Enumeration enumeration = this.objectList.elements();
        while (enumeration.hasMoreElements()) {
            try {
                FigObject figObject = (FigObject)enumeration.nextElement();
                if (!(figObject instanceof FigImage)) continue;
                Image image = ((FigImage)figObject).getImage();
                int n = image.getWidth(null);
                int n2 = image.getHeight(null);
                int n3 = 1;
                BufferedImage bufferedImage = new BufferedImage(n, n2, n3);
                bufferedImage.getGraphics().drawImage(image, 0, 0, null);
                ((FigImage)figObject).setImage(bufferedImage);
            }
            catch (Throwable throwable) {
                ItextPresentationPDFWriter.msg("-E- INTERNAL: IMAGE IS NULL OR BROKEN");
            }
        }
    }

    public void writeOnePage(int n) throws Exception {
        try {
            Graphics2D graphics2D;
            PdfTemplate pdfTemplate;
            String string = this.presentationParser.getCurrentSlideTitle();
            ItextPresentationPDFWriter.msg("-#- title= " + string);
            Object var3_4 = null;
            Rectangle rectangle = this.document.getPageSize();
            int n2 = (int)rectangle.width();
            int n3 = (int)rectangle.height();
            if (!this.fourUpMode || n % 4 == 0) {
                this.document.newPage();
                this.cb = this.pdfWriter.getDirectContent();
                pdfTemplate = new PdfDestination(0, 0.0f, 0.0f, 0.0f);
                graphics2D = new PdfOutline(this.cb.getRootOutline(), (PdfDestination)pdfTemplate, string);
                this.cb.addOutline((PdfOutline)graphics2D, string);
            }
            if (this.fourUpMode) {
                n2 /= 2;
                n3 /= 2;
            }
            pdfTemplate = this.cb.createTemplate((float)n2, (float)n3);
            graphics2D = pdfTemplate.createGraphics((float)n2, (float)n3, (FontMapper)this.mapper);
            pdfTemplate.setWidth((float)n2);
            pdfTemplate.setHeight((float)n3);
            FigBbox figBbox = BoundingBoxCalculator.getBoundingBox(this.objectList.elements());
            double d = 32.0 * (double)n2 / (double)(figBbox.getXr() - figBbox.getXl());
            double d2 = 32.0 * (double)n3 / (double)(figBbox.getYb() - figBbox.getYt());
            double d3 = Math.min(d, d2);
            this.trafo.setAnchor(new Point(figBbox.getXl(), figBbox.getYt()));
            this.trafo.set_zoom(d3);
            int n4 = 0;
            int n5 = 0;
            if (this.fourUpMode) {
                int n6 = n % 4;
                switch (n6) {
                    case 0: {
                        n4 = 0;
                        n5 = 297;
                        break;
                    }
                    case 1: {
                        n4 = 0;
                        n5 = 0;
                        break;
                    }
                    case 2: {
                        n4 = 421;
                        n5 = 297;
                        break;
                    }
                    case 3: {
                        n4 = 421;
                        n5 = 0;
                        break;
                    }
                }
            }
            FigTrafo2D figTrafo2D = new FigTrafo2D();
            ItextPDFWriter itextPDFWriter = new ItextPDFWriter(this.document, this.mapper, graphics2D);
            itextPDFWriter.setTrafo(this.trafo);
            itextPDFWriter.setOrigTrafo(figTrafo2D);
            itextPDFWriter.setPageNumber(this.pagenumber);
            itextPDFWriter.setPageOffsets(n4, n5, n2, n3);
            if (this.fourUpMode) {
                itextPDFWriter.setPageOffsets(n4, n5 - 297, n2, n3);
            }
            Enumeration enumeration = this.objectList.elements();
            while (enumeration.hasMoreElements()) {
                FigObject figObject = (FigObject)enumeration.nextElement();
                itextPDFWriter.paintOneObject(figObject);
            }
            graphics2D.dispose();
            this.cb.addTemplate(pdfTemplate, (float)n4, (float)n5);
        }
        catch (Throwable throwable) {
            ItextPresentationPDFWriter.msg("-E- in writeOnePage: " + throwable);
            throwable.printStackTrace();
        }
    }

    public void writeTestPage() throws Exception {
    }

    public void writeTrailer() throws Exception {
        this.document.close();
        this.outputStream.flush();
        this.outputStream.close();
    }

    public static void msg(String string) {
        System.out.println(string);
    }

    public static void usage() {
        ItextPresentationPDFWriter.msg("Usage: java jfig.utils.ItextPresentationPdfWriter <jptfile> [options]\n");
        ItextPresentationPDFWriter.msg("where <jptfile> is a jfig presentation index file, and options include:\n");
        ItextPresentationPDFWriter.msg("-4          write four slides per page (expects A4 landscape format)\n");
        ItextPresentationPDFWriter.msg("-4    -page <int>   number pages starting with the given integer\n");
        ItextPresentationPDFWriter.msg("dummy -page <int>   number pages starting with the given integer\n");
        ItextPresentationPDFWriter.msg("Example:\n");
        ItextPresentationPDFWriter.msg("java jfig.utils.ItextPresentationPDFWriter oop.jpt -4 -page 42\n");
        System.exit(0);
    }

    public static void main(String[] stringArray) {
        try {
            SetupManager.loadGlobalProperties("jfig/jfig.cnf");
            SetupManager.loadUserProperties("jfig.cnf");
            SetupManager.loadUserProperties(".jfigrc");
            SetupManager.loadLocalProperties("jfig.cnf");
            SetupManager.loadLocalProperties(".jfigrc");
            FontCache.getFontCache().dumpFontDescriptions();
            ItextPresentationPDFWriter.msg("-#- TeX mode: " + SetupManager.getBoolean("jfig.showTeXStrings", false));
            ItextPresentationPDFWriter itextPresentationPDFWriter = new ItextPresentationPDFWriter();
            if (stringArray.length == 0 || "-help".equals(stringArray[0]) || "--help".equals(stringArray[0]) || "-?".equals(stringArray[0])) {
                ItextPresentationPDFWriter.usage();
            }
            itextPresentationPDFWriter.openPresentation(stringArray[0]);
            if (stringArray.length >= 2 && "-4".equals(stringArray[1])) {
                itextPresentationPDFWriter.fourUpMode = true;
            }
            if (stringArray.length >= 4 && "-page".equals(stringArray[2])) {
                itextPresentationPDFWriter.pagenumber = Integer.parseInt(stringArray[3]);
            }
            itextPresentationPDFWriter.openOutputStream("hugo.pdf");
            itextPresentationPDFWriter.writePDF();
            ItextPresentationPDFWriter.msg("-I- ok.");
            System.exit(0);
        }
        catch (Exception exception) {
            ItextPresentationPDFWriter.msg("-E- in main: " + exception);
            exception.printStackTrace();
        }
    }
}

