/*
 * Decompiled with CFR 0.152.
 */
package jfig.utils;

import com.lowagie.text.Document;
import com.lowagie.text.Image;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfGraphics2D;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import jfig.canvas.FigTrafo2D;
import jfig.gui.FontCache;
import jfig.objects.FigAttribs;
import jfig.objects.FigBbox;
import jfig.objects.FigCompound;
import jfig.objects.FigImage;
import jfig.objects.FigObject;
import jfig.objects.FigObjectList;
import jfig.objects.FigText;
import jfig.objects.ListNode;
import jfig.utils.ExceptionTracer;
import jfig.utils.LP2;
import jfig.utils.RegistrationKeyManager;
import jfig.utils.SetupManager;

public class ItextPDFWriter {
    public static final int A4_WIDTH = 26173;
    public static final int A4_HEIGHT = 17952;
    public static final double _72_DPI = 72.0;
    public static final double _75_DPI = 75.0;
    private boolean debug = false;
    private Document document;
    private FontMapper mapper;
    private FigTrafo2D trafo;
    private FigTrafo2D origTrafo;
    private Graphics2D pdf2D;
    private int pagenumber;
    private float page_dx;
    private float page_dy;
    private float page_width;
    private float page_height;

    public void setFontMapper(FontMapper fontMapper) {
        this.mapper = fontMapper;
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    public void setTrafo(FigTrafo2D figTrafo2D) {
        this.trafo = figTrafo2D;
    }

    public void setOrigTrafo(FigTrafo2D figTrafo2D) {
        this.origTrafo = figTrafo2D;
    }

    public void setPageNumber(int n) {
        this.pagenumber = n;
    }

    public void setPageOffsets(float f, float f2) {
        this.page_dx = f;
        this.page_dy = f2;
    }

    public void setPageOffsets(float f, float f2, float f3, float f4) {
        this.page_dx = f;
        this.page_dy = f2;
        this.page_width = f3;
        this.page_height = f4;
    }

    public void paintOneObject(FigObject figObject) {
        try {
            figObject.setTrafo(this.trafo);
            if (figObject instanceof FigImage) {
                FigImage figImage = (FigImage)figObject;
                FigBbox figBbox = figImage.getBbox();
                String string = figImage.getImageName();
                Image image = Image.getInstance((String)string);
                float f = this.page_height;
                float f2 = this.page_width;
                float f3 = this.trafo.wc_to_screen_x(figBbox.getXl());
                float f4 = f - (float)this.trafo.wc_to_screen_y(figBbox.getYb());
                float f5 = this.trafo.wc_to_screen(figBbox.getXr() - figBbox.getXl());
                float f6 = this.trafo.wc_to_screen(figBbox.getYb() - figBbox.getYt());
                if (f3 < 0.0f || f3 + f5 >= f2 || f4 < 0.0f || f4 + f6 > f) {
                    this.msg("-W- Image position/size exceeds page size!");
                    this.msg("    Image filename '" + string + "'");
                    this.msg("    Image x,y,w,h: (" + f3 + "," + f4 + ") " + f5 + "x" + f6);
                }
                image.setAbsolutePosition(f3, f4);
                image.scaleAbsolute(f5, f6);
                PdfGraphics2D pdfGraphics2D = (PdfGraphics2D)this.pdf2D;
                PdfContentByte pdfContentByte = pdfGraphics2D.getContent();
                pdfContentByte.addImage(image);
            } else if (figObject instanceof FigText) {
                FigText figText = (FigText)figObject;
                if ("#pagenumber#".equals(figText.getText())) {
                    figText.setText("" + this.pagenumber);
                    figText.setColor(Color.black);
                    figText.rebuild();
                    this.msg("-#- pagenumber= " + figText.getText());
                    ++this.pagenumber;
                }
                this.paintOneTextObject((FigText)figObject);
            } else if (figObject instanceof FigCompound) {
                FigObjectList figObjectList = ((FigCompound)figObject).getMembers();
                ListNode listNode = figObjectList.get_first();
                while (listNode != null) {
                    this.paintOneObject(listNode.obj);
                    listNode = figObjectList.get_next(listNode);
                }
            } else {
                figObject.paint(this.pdf2D, this.trafo);
            }
            if (this.origTrafo != null) {
                figObject.setTrafo(this.origTrafo);
            }
        }
        catch (Throwable throwable) {
            this.msg("-E- Internal in paintOneObject<FigImage>: " + throwable);
        }
    }

    public void paintOneTextObject(FigText figText) {
        if (this.debug) {
            this.msg("-#- paintOneTextObject: '" + figText.getText() + "'");
        }
        if (!figText.isVisible()) {
            return;
        }
        AffineTransform affineTransform = this.pdf2D.getTransform();
        Point point = figText.getPosition();
        String string = figText.getText();
        FigAttribs figAttribs = figText.getAttributes();
        if (string == null) {
            return;
        }
        if (string.length() == 0) {
            return;
        }
        int n = (int)((double)figAttribs.fontSize * this.trafo.getZoom());
        Font font = FontCache.getFontCache().getFont(figAttribs.fig_font, n);
        if (figAttribs.fig_font == 32) {
            font = new Font("Symbol", 0, n);
        }
        BaseFont baseFont = this.mapper.awtToPdf(font);
        float f = baseFont.getWidthPoint(string, (float)n);
        if (this.debug) {
            this.msg("    base font= " + baseFont + " width= " + f);
        }
        if ((figAttribs.fig_font_flags & 2) != 0 && SetupManager.getBoolean("jfig.showTeXStrings", false)) {
            try {
                LP2 lP2 = new LP2();
                lP2.setPDFMapper(this);
                lP2.setFontIndex(figAttribs.fig_font);
                lP2.setFontPtSize(figAttribs.fontSize);
                lP2.setColorIndex(figAttribs.fig_line_color);
                lP2.setEnableDisplayBoxes(SetupManager.getBoolean("jfig.utils.SimpleLatexParser.displayBoxes", false));
                lP2.setEnableDumpTokens(SetupManager.getBoolean("jfig.utils.SimpleLatexParser.dumpTokens", false));
                lP2.parse(string);
                FigCompound figCompound = new FigCompound();
                figCompound.setTrafo(figText.getTrafo());
                lP2.convertToFig(figCompound);
                figCompound.update_bbox();
                figCompound.move(figText.getPosition().x, figText.getPosition().y);
                int n2 = figCompound.getBbox().getXr() - figCompound.getBbox().getXl();
                int n3 = 0;
                if (figAttribs.textAlign == 3) {
                    n3 = -n2;
                    figCompound.move(-n2, 0);
                } else if (figAttribs.textAlign == 2) {
                    n3 = -n2 / 2;
                    figCompound.move(-n2 / 2, 0);
                }
                Point point2 = new Point(figText.getPosition().x, figText.getPosition().y);
                figCompound.rotate(point2, -figAttribs.fig_angle);
                figCompound.paint((Graphics)this.pdf2D, this.trafo);
            }
            catch (Throwable throwable) {
                System.err.println("-E- Internal in paintOneTextObject: " + throwable);
                ExceptionTracer.trace(throwable);
            }
        } else {
            double d = 0.0;
            if (figAttribs.textAlign == 3) {
                d = (double)f / 72.0 * 2400.0;
            } else if (figAttribs.textAlign == 2) {
                d = 0.5 * (double)f / 72.0 * 2400.0;
            }
            if (this.debug) {
                this.msg("-#- offset = " + d);
            }
            AffineTransform affineTransform2 = new AffineTransform();
            affineTransform2.translate(this.trafo.wc_to_screen_x(point.x), this.trafo.wc_to_screen_y(point.y));
            affineTransform2.rotate(-figAttribs.fig_angle);
            affineTransform2.translate(this.trafo.wc_to_screen(-d), 0.0);
            affineTransform2.preConcatenate(affineTransform);
            this.pdf2D.setTransform(affineTransform2);
            this.pdf2D.setColor(figAttribs.lineColor);
            this.pdf2D.setFont(font);
            this.pdf2D.drawString(string, 0, 0);
            this.pdf2D.setTransform(affineTransform);
        }
    }

    public int getStringWidthPoints(int n, int n2, String string) {
        Font font = FontCache.getFontCache().getFont(n, n2);
        BaseFont baseFont = this.mapper.awtToPdf(font);
        float f = baseFont.getWidthPoint(string, (float)n2);
        return (int)((double)f + 0.5);
    }

    public void msg(String string) {
        if (!this.debug && string.startsWith("-#-")) {
            return;
        }
        System.out.println(string);
    }

    public static void usage() {
        System.out.println("Usage: java jfig.utils.ItextPDFWriter <figfilename> [<pdffilename>]\nIf not output filename is given, ItextPDFWriter will generate one \nby replacing the (.fig) extension with .pdf\nExample: java jfig.utils.ItextPDFWriter demo.fig demo.pdf\n");
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        try {
            Object var1_1 = null;
            Object var2_3 = null;
            Object var3_4 = null;
            Object var4_5 = null;
            Object var5_6 = null;
            Object var6_7 = null;
            Object var7_8 = null;
            Object var8_9 = null;
            Object var9_10 = null;
            if (!RegistrationKeyManager.getRegistrationKeyManager().isValid()) {
                throw new Exception("Invalid license, sorry.");
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            ItextPDFWriter.usage();
        }
    }

    public ItextPDFWriter(Document document, FontMapper fontMapper, Graphics2D graphics2D) {
        this.document = document;
        this.mapper = fontMapper;
        this.pdf2D = graphics2D;
        this.page_dx = 0.0f;
        this.page_dy = 0.0f;
        this.page_width = document.getPageSize().width();
        this.page_height = document.getPageSize().height();
    }
}

