/*
 * Decompiled with CFR 0.152.
 */
package jfig.utils;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.DefaultFontMapper;
import com.lowagie.text.pdf.FontMapper;
import java.awt.Font;

public class ItextFontMapper
extends DefaultFontMapper
implements FontMapper {
    private boolean verbose = false;

    public void setVerbose(boolean bl) {
    }

    public void msg(String string) {
        if (this.verbose) {
            System.out.println(string);
        }
    }

    public BaseFont awtToPdf(Font font) {
        try {
            DefaultFontMapper.BaseFontParameters baseFontParameters = this.getBaseFontParameters(font.getFontName());
            if (baseFontParameters != null) {
                this.msg("-#- IFM.awtToPdf: have BaseFontParameters: " + baseFontParameters.encoding + " " + baseFontParameters.embedded);
                return BaseFont.createFont((String)baseFontParameters.fontName, (String)baseFontParameters.encoding, (boolean)baseFontParameters.embedded, (boolean)baseFontParameters.cached, (byte[])baseFontParameters.ttfAfm, (byte[])baseFontParameters.pfb);
            }
            String string = null;
            String string2 = font.getName();
            String string3 = "jfig/fonts/" + string2 + ".ttf";
            this.msg("-#- IFM.awtToPdf: logicalName=" + string2);
            if (string2.equals("cmsy10")) {
                this.msg("-#- IFM: CMSY10 special case");
                return BaseFont.createFont((String)string3, (String)"Identity-H", (boolean)true);
            }
            if (string2.equals("cmmi10")) {
                this.msg("-#- IFM: CMMI10 special case");
                return BaseFont.createFont((String)string3, (String)"Identity-H", (boolean)true);
            }
            if (string2.equals("cmr10")) {
                this.msg("-#- IFM: CMR10 special case");
                return BaseFont.createFont((String)string3, (String)"Identity-H", (boolean)true);
            }
            if (string2.equals("cmtt10")) {
                this.msg("-#- IFM: CMTT10 special case");
                return BaseFont.createFont((String)string3, (String)"Identity-H", (boolean)true);
            }
            if (string2.equals("Symbol")) {
                this.msg("-W- IFM: Symbol font special case");
                return BaseFont.createFont((String)"Symbol", (String)"Cp1252", (boolean)true);
            }
            string = string2.equals("DialogInput") || string2.equals("Monospaced") || string2.equals("Courier") ? (font.isItalic() ? (font.isBold() ? "Courier-BoldOblique" : "Courier-Oblique") : (font.isBold() ? "Courier-Bold" : "Courier")) : (string2.equals("Serif") || string2.equals("TimesRoman") ? (font.isItalic() ? (font.isBold() ? "Times-BoldItalic" : "Times-Italic") : (font.isBold() ? "Times-Bold" : "Times-Roman")) : (font.isItalic() ? (font.isBold() ? "Helvetica-BoldOblique" : "Helvetica-Oblique") : (font.isBold() ? "Helvetica-Bold" : "Helvetica")));
            this.msg("-#- IFM.awtToPdf: fontKey= " + string);
            return BaseFont.createFont((String)string, (String)"Cp1252", (boolean)false);
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }
}

