/*
 * Decompiled with CFR 0.152.
 */
package jfig.utils;

import java.io.PrintWriter;
import java.util.Enumeration;
import jfig.gui.Console;
import jfig.objects.FigArc;
import jfig.objects.FigAttribs;
import jfig.objects.FigBbox;
import jfig.objects.FigBezier;
import jfig.objects.FigCompound;
import jfig.objects.FigEllipse;
import jfig.objects.FigImage;
import jfig.objects.FigObject;
import jfig.objects.FigPolyline;
import jfig.objects.FigPrintWriter;
import jfig.objects.FigRectangle;
import jfig.objects.FigSpline;
import jfig.objects.FigText;
import jfig.objects.FigTrigger;
import jfig.objects.FigWriter;
import jfig.utils.ExceptionTracer;

public class FilteredFigWriter
extends FigWriter {
    public static final int FULL_COLORS = 2;
    public static final int IO_COLORS = 3;
    public static final int BLACK_WHITE = 4;
    protected int colorOption = 2;

    public void setColorOption(int n) {
        if (n < 2 || n > 4) {
            this.message("-W- FilteredFigWriter.setColorOption: out of range: " + n);
            this.message("-W- using black and white instead!");
            this.colorOption = 4;
        } else {
            this.colorOption = n;
        }
    }

    public int getColorOption() {
        return this.colorOption;
    }

    public int getLineColorIndex(FigAttribs figAttribs) {
        if (this.colorOption == 4) {
            return 0;
        }
        if (this.colorOption == 3) {
            return 0;
        }
        return super.getLineColorIndex(figAttribs);
    }

    public int getFillColorIndex(FigAttribs figAttribs) {
        if (this.colorOption == 4) {
            return 0;
        }
        if (this.colorOption == 3) {
            return 0;
        }
        return super.getFillColorIndex(figAttribs);
    }

    public int getAreaFill(FigAttribs figAttribs) {
        return super.getAreaFill(figAttribs);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int write_fig31_file(PrintWriter printWriter, boolean bl, Enumeration enumeration) {
        FigObject figObject = null;
        Object var5_5 = null;
        int n = 0;
        FigPrintWriter figPrintWriter = new FigPrintWriter(printWriter);
        try {
            if (bl) {
                n = 0;
                this.write_fig31_header(figPrintWriter, new FigAttribs());
            }
            if (enumeration == null) {
                return 1;
            }
            while (true) {
                if (!enumeration.hasMoreElements()) {
                    return n;
                }
                figObject = (FigObject)enumeration.nextElement();
                if (!figObject.isVisible()) continue;
                this.currentObject = figObject;
                if (figObject instanceof FigCompound) {
                    FigBbox figBbox = figObject.getBbox();
                    String string = null;
                    string = "6 " + this.fig_scale(figBbox.getXr()) + " " + this.fig_scale(figBbox.getYt()) + " " + this.fig_scale(figBbox.getXl()) + " " + this.fig_scale(figBbox.getYb());
                    figPrintWriter.print(string + "\n");
                    this.write_fig31_file((PrintWriter)figPrintWriter, false, ((FigCompound)figObject).getMembers().elements());
                    figPrintWriter.print("-6\n");
                    continue;
                }
                if (figObject instanceof FigText) {
                    this.write_fig31_text(figPrintWriter, (FigText)figObject);
                    continue;
                }
                if (figObject instanceof FigEllipse) {
                    this.write_fig31_ellipse(figPrintWriter, (FigEllipse)figObject);
                    continue;
                }
                if (figObject instanceof FigArc) {
                    this.write_fig31_arc(figPrintWriter, (FigArc)figObject);
                    continue;
                }
                if (figObject instanceof FigBezier) {
                    this.write_fig31_spline(figPrintWriter, (FigBezier)figObject);
                    continue;
                }
                if (figObject instanceof FigSpline) {
                    this.write_fig31_spline(figPrintWriter, (FigSpline)figObject);
                    continue;
                }
                if (figObject instanceof FigPolyline) {
                    this.write_fig31_polyline(figPrintWriter, (FigPolyline)figObject);
                    continue;
                }
                if (figObject instanceof FigTrigger) {
                    this.write_jfig_trigger(figPrintWriter, (FigTrigger)figObject);
                    continue;
                }
                if (figObject instanceof FigImage) {
                    this.write_fig31_rectangle(figPrintWriter, (FigRectangle)figObject);
                    continue;
                }
                if (figObject instanceof FigRectangle) {
                    this.write_fig31_rectangle(figPrintWriter, (FigRectangle)figObject);
                    continue;
                }
                System.err.println("write_fig31_file: unknown object " + figObject.toString());
                ++n;
            }
        }
        catch (Exception exception) {
            this.message("-E- FilteredFigWriter: couldn't write: " + exception);
            ExceptionTracer.trace(exception);
            return n;
        }
    }

    public void message(String string) {
        Console.getConsole().message(string);
    }

    public String toString() {
        return "FilteredFigWriter[" + super.toString() + "]";
    }
}

