/*
 * Decompiled with CFR 0.152.
 */
package jfig.objects;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import jfig.canvas.FigTrafo2D;
import jfig.objects.FigAttribs;
import jfig.objects.FigObject;

public class FillWrapper {
    Point[] wcp;
    Point[] scp;
    int[] xp;
    int[] yp;
    int np;
    int radius;
    FigObject parent;
    FigTrafo2D trafo;
    long timestamp;
    boolean debug = false;
    Color extraColor = null;

    public long getTimestamp() {
        return this.timestamp;
    }

    public void set_debug() {
        this.debug = true;
    }

    public Point[] get_scp() {
        if (this.timestamp <= this.trafo.getTimestamp()) {
            this.buildSCP();
            this.timestamp = System.currentTimeMillis();
        }
        return this.scp;
    }

    public void buildSCP() {
        int n = 0;
        while (n < this.wcp.length) {
            this.scp[n] = this.trafo.wc_to_screen(this.wcp[n], this.scp[n]);
            ++n;
        }
        if (this.debug) {
            n = 0;
            while (n < this.wcp.length) {
                System.out.println("FillWrapper: wcp[" + n + "]: " + this.wcp[n].toString() + " scp: " + this.scp[n].toString());
                ++n;
            }
        }
        if (this.wcp.length > 2) {
            n = 0;
            while (n < this.wcp.length) {
                this.xp[n] = this.scp[n].x;
                this.yp[n] = this.scp[n].y;
                ++n;
            }
        }
        this.radius = this.trafo.wc_to_screen(this.parent.getAttributes().cornerRadius);
    }

    public void paint(Graphics graphics) {
        this.paintAWT11(graphics);
    }

    public void paintAWT11(Graphics graphics) {
        if (this.wcp.length < 2) {
            return;
        }
        if (this.timestamp <= this.trafo.getTimestamp()) {
            this.buildSCP();
            this.timestamp = System.currentTimeMillis();
        }
        FigAttribs figAttribs = this.parent.getAttributes();
        if (this.extraColor != null) {
            graphics.setColor(this.extraColor);
        } else {
            if (figAttribs.fillColor == null) {
                return;
            }
            graphics.setColor(figAttribs.fillColor);
        }
        if (this.wcp.length == 2) {
            if (figAttribs.cornerRadius == 0) {
                graphics.fillRect(this.scp[0].x, this.scp[0].y, this.scp[1].x - this.scp[0].x, this.scp[1].y - this.scp[0].y);
            } else {
                graphics.fillRoundRect(this.scp[0].x, this.scp[0].y, this.scp[1].x - this.scp[0].x, this.scp[1].y - this.scp[0].y, 2 * this.radius, 2 * this.radius);
            }
        } else {
            graphics.fillPolygon(this.xp, this.yp, this.np);
        }
    }

    public FillWrapper(FigObject figObject, FigTrafo2D figTrafo2D, Point[] pointArray) {
        this.parent = figObject;
        this.trafo = figTrafo2D;
        this.wcp = pointArray;
        this.scp = new Point[pointArray.length];
        int n = 0;
        while (n < pointArray.length) {
            this.scp[n] = new Point(0, 0);
            ++n;
        }
        if (pointArray.length > 2) {
            this.xp = new int[pointArray.length];
            this.yp = new int[pointArray.length];
            this.np = pointArray.length;
        }
        this.timestamp = 0L;
    }

    public FillWrapper(FigObject figObject, FigTrafo2D figTrafo2D, Point[] pointArray, Color color) {
        this(figObject, figTrafo2D, pointArray);
        this.extraColor = color;
    }
}

