/*
 * Decompiled with CFR 0.152.
 */
package jfig.objects;

import java.awt.Point;
import jfig.canvas.FigTrafo2D;
import jfig.objects.FigAttribs;
import jfig.objects.FigObject;
import jfig.objects.FigObjectFactory;
import jfig.objects.FigPolyline;
import jfig.utils.Xspline;

public class FigXSpline
extends FigPolyline {
    protected double[] sfactors;
    protected Point[] wcp_spline;

    public void createRenderer() {
        this.renderer = FigObjectFactory.getDefaultObjectFactory().createXSplineRenderer(this);
    }

    public void createSfactors() {
        this.sfactors = new double[this.wcp.length];
        int n = 0;
        while (n < this.sfactors.length) {
            this.sfactors[n] = 1.0;
            ++n;
        }
        if (!this.is_closed) {
            this.sfactors[0] = 0.0;
            this.sfactors[this.sfactors.length - 1] = 0.0;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("FigXSpline with " + this.wcp.length + " control points: ");
        int n = 0;
        while (n < this.wcp.length) {
            stringBuffer.append("( " + this.wcp[n].x + ", " + this.wcp[n].y + "), ");
            ++n;
        }
        return stringBuffer.toString();
    }

    public void rebuild() {
        this.createSfactors();
        Xspline xspline = new Xspline(this.wcp, this.sfactors);
        if (this.wcp.length > 2) {
            if (this.is_closed) {
                xspline.compute_closed_spline();
            } else {
                xspline.compute_open_spline();
            }
            this.wcp_spline = xspline.getComputedPointArray();
        } else {
            this.wcp_spline = this.wcp.length == 2 ? new Point[]{this.wcp[0], this.wcp[1]} : new Point[]{this.wcp[0]};
        }
        this.renderer.rebuild();
        this.update_bbox();
    }

    public double[] getSFactors() {
        return this.sfactors;
    }

    public void setSFactors(double[] dArray) {
        if (dArray.length != this.sfactors.length) {
            System.err.println("-E- FigXSpline.setSFactors: length mismatch! " + dArray.length + " vs " + this.sfactors.length);
            return;
        }
        this.sfactors = dArray;
        this.rebuild();
    }

    public Point[] getSplinePoints() {
        return this.wcp_spline;
    }

    public void dumpXsplinePoints() {
        int n = this.wcp_spline.length;
        System.out.println("-#- dXPoints: " + n);
        int n2 = 0;
        while (n2 < n) {
            System.out.println("   " + this.wcp_spline[n2]);
            ++n2;
        }
    }

    public void dumpSfactors() {
        if (this.sfactors == null) {
            System.out.println("-#- dXSfactors: NULL");
            return;
        }
        System.out.println("-#- dXSfactors: " + this.getClass().getName());
        int n = 0;
        while (n < this.sfactors.length) {
            System.out.println("   " + this.sfactors[n]);
            ++n;
        }
    }

    public FigObject copy() {
        if (this.debug) {
            this.message("FigXSpline.copy()...");
        }
        FigXSpline figXSpline = new FigXSpline(this.wcp[0].x, this.wcp[0].y, this.is_closed, this.attribs.getClone(), this.trafo);
        figXSpline.setPoints(this.getPoints());
        return figXSpline;
    }

    public FigXSpline() {
        this.min_num_points = this.is_closed ? 3 : 2;
    }

    public FigXSpline(int n, int n2, FigAttribs figAttribs, FigTrafo2D figTrafo2D) {
        this(n, n2, false, figAttribs, figTrafo2D);
        this.min_num_points = this.is_closed ? 3 : 2;
    }

    public FigXSpline(int n, int n2, boolean bl, FigAttribs figAttribs, FigTrafo2D figTrafo2D) {
        super(n, n2, bl, figAttribs, figTrafo2D);
        this.min_num_points = bl ? 3 : 2;
    }
}

