/*
 * Decompiled with CFR 0.152.
 */
package jfig.objects;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.event.KeyEvent;
import jfig.canvas.FigTrafo2D;
import jfig.gui.ColorCache;
import jfig.gui.FontCache;
import jfig.objects.FigAttribs;
import jfig.objects.FigBaseobject;
import jfig.objects.FigBbox;
import jfig.objects.FigCompound;
import jfig.objects.FigObject;
import jfig.objects.FigObjectFactory;
import jfig.objects.FigRenderer;
import jfig.utils.LP2;
import jfig.utils.SetupManager;

public class FigText
extends FigBaseobject {
    private static char[] recode_table = new char[65536];
    int textCursorIndex = 0;
    boolean showCursorFlag = false;
    String str;
    FontMetrics fm = null;
    FigRenderer renderer;
    Polygon border;

    public void createRenderer() {
        this.renderer = FigObjectFactory.getDefaultObjectFactory().createTextRenderer(this);
    }

    public boolean isShowCursor() {
        return this.showCursorFlag;
    }

    public int getTextCursorIndex() {
        return this.textCursorIndex;
    }

    public void rebuild() {
        this.update_bbox();
        if (this.renderer != null) {
            this.renderer.rebuild();
        }
    }

    public void update_bbox() {
        try {
            double d;
            double d2;
            double d3;
            double d4;
            double d5;
            block12: {
                this.fm = FontCache.getFontCache().getFontMetrics(this.attribs.fig_font, (int)((double)this.attribs.fontSize * this.trafo.getZoom()));
                int n = this.fm.stringWidth(this.str);
                int n2 = this.fm.getAscent();
                int n3 = this.fm.getDescent();
                d5 = 0.0;
                d4 = 0.0;
                double d6 = this.trafo.screen_to_wc(n);
                d3 = -this.trafo.screen_to_wc(n2);
                d2 = this.trafo.screen_to_wc(n3);
                d = -this.attribs.fig_angle;
                if (this.attribs.textAlign == 1) {
                    d5 = 0.0;
                    d4 = d6;
                } else if (this.attribs.textAlign == 3) {
                    d5 = -d6;
                    d4 = 0.0;
                } else if (this.attribs.textAlign == 2) {
                    d5 = -d6 / 2.0;
                    d4 = d6 / 2.0;
                }
                if ((this.attribs.fig_font_flags & 2) != 0 && SetupManager.getBoolean("jfig.showTeXStrings", false)) {
                    if (this.debug) {
                        System.out.println("-I- FigText: measuring TeX-mode text '" + this.str + "'");
                    }
                    try {
                        double[] dArray = this.getTexModeBoundingBox();
                        d5 = dArray[0];
                        d4 = dArray[1];
                        d6 = dArray[2];
                        d3 = dArray[3];
                        d2 = dArray[4];
                        if (this.debug) {
                            System.out.println("   lrw= " + d5 + " " + d4 + " " + d6 + " ad= " + d3 + " " + d2);
                        }
                    }
                    catch (Throwable throwable) {
                        if (!this.debug) break block12;
                        System.out.println("-W- FigText: getTexModeBoundingBox() failed.");
                        throwable.printStackTrace();
                    }
                }
            }
            double d7 = Math.cos(d);
            double d8 = Math.sin(d);
            double d9 = (double)this.x + d5 * d7 - d3 * d8;
            double d10 = (double)this.y + d5 * d8 + d3 * d7;
            double d11 = (double)this.x + d5 * d7 - d2 * d8;
            double d12 = (double)this.y + d5 * d8 + d2 * d7;
            double d13 = (double)this.x + d4 * d7 - d2 * d8;
            double d14 = (double)this.y + d4 * d8 + d2 * d7;
            double d15 = (double)this.x + d4 * d7 - d3 * d8;
            double d16 = (double)this.y + d4 * d8 + d3 * d7;
            this.bbox = new FigBbox(this.min(d9, d11, d13, d15), this.min(d10, d12, d14, d16), this.max(d9, d11, d13, d15), this.max(d10, d12, d14, d16));
            this.border = new Polygon();
            this.border.addPoint((int)d9, (int)d10);
            this.border.addPoint((int)d11, (int)d12);
            this.border.addPoint((int)d13, (int)d14);
            this.border.addPoint((int)d15, (int)d16);
            super.build_sc_bbox();
            this.timestamp = System.currentTimeMillis();
        }
        catch (Throwable throwable) {
            System.err.println("-E- FigText.update_bbox: internal error: " + throwable);
            throwable.printStackTrace();
        }
    }

    private final int min(double d, double d2, double d3, double d4) {
        return (int)Math.min(Math.min(d, d2), Math.min(d3, d4));
    }

    private final int max(double d, double d2, double d3, double d4) {
        return (int)Math.max(Math.max(d, d2), Math.max(d3, d4));
    }

    private double[] getTexModeBoundingBox() {
        LP2 lP2 = new LP2();
        lP2.setFontIndex(this.attribs.fig_font);
        lP2.setFontPtSize(this.attribs.fontSize);
        lP2.setColorIndex(this.attribs.fig_line_color);
        lP2.setEnableDisplayBoxes(false);
        lP2.setEnableDumpTokens(false);
        lP2.parse(this.str);
        FigCompound figCompound = new FigCompound();
        figCompound.setTrafo(this.getTrafo());
        lP2.convertToFig(figCompound);
        figCompound.update_bbox();
        FigBbox figBbox = figCompound.getBbox();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = figBbox.getXr() - figBbox.getXl();
        double d4 = figBbox.getYt();
        double d5 = figBbox.getYb();
        if (this.attribs.textAlign == 1) {
            d = 0.0;
            d2 = d3;
        } else if (this.attribs.textAlign == 3) {
            d = -d3;
            d2 = 0.0;
        } else if (this.attribs.textAlign == 2) {
            d = -d3 / 2.0;
            d2 = d3 / 2.0;
        }
        double[] dArray = new double[]{d, d2, d3, d4, d5};
        return dArray;
    }

    public void paint(Graphics graphics) {
        if (this.timestamp < this.trafo.getTimestamp()) {
            this.rebuild();
        }
        if (this.renderer != null) {
            this.renderer.paint(graphics);
            return;
        }
    }

    public void paint(Graphics graphics, FigTrafo2D figTrafo2D) {
        this.paint(graphics);
    }

    public void paintSave(Graphics graphics, FigTrafo2D figTrafo2D) {
        Graphics graphics2 = graphics.create();
        this.setTrafo(figTrafo2D);
        this.rebuild();
        this.paint(graphics2);
        graphics2.dispose();
    }

    public void showCursor(boolean bl) {
        this.showCursorFlag = bl;
    }

    public void setCursor(int n, int n2) {
        if (this.fm == null) {
            this.update_bbox();
        }
        int n3 = this.trafo.wc_to_screen_x(this.x);
        int n4 = this.trafo.wc_to_screen_y(this.y);
        double d = -this.attribs.fig_angle;
        int n5 = this.fm.stringWidth(this.str);
        if (this.attribs.textAlign == 1) {
            n5 = 0;
        } else if (this.attribs.textAlign == 2) {
            n5 /= 2;
        } else if (this.attribs.textAlign == 3) {
            n5 = 1 * n5;
        }
        int n6 = n3 - (int)((double)n5 * Math.cos(d) + 0.5);
        int n7 = n4 - (int)((double)n5 * Math.sin(d) + 0.5);
        int n8 = (int)Math.sqrt((n6 - n) * (n6 - n) + (n7 - n2) * (n7 - n2));
        int n9 = 0;
        int n10 = 0;
        while (n9 <= n8 && n10 < this.str.length()) {
            n9 = this.fm.stringWidth(this.str.substring(0, n10++));
        }
        if (n10 >= 1) {
            --n10;
        }
        this.textCursorIndex = n10;
    }

    public int initializeCursor(int n, int n2) {
        this.setCursor(n, n2);
        return this.textCursorIndex;
    }

    public void moveCursorTo(int n) {
        this.textCursorIndex = n;
    }

    public void move(int n, int n2) {
        this.x += n;
        this.y += n2;
        this.rebuild();
    }

    public FigObject copy() {
        FigText figText = new FigText(new Point(this.x, this.y), this.str, this.attribs.getClone(), this.trafo);
        return figText;
    }

    public boolean canRotate(double d) {
        return true;
    }

    public void rotate(Point point, double d) {
        if (this.debug) {
            this.message("-#- FigText.rotate: " + point + " " + d);
        }
        this.x -= point.x;
        this.y -= point.y;
        double d2 = (double)this.x * Math.cos(d) - (double)this.y * Math.sin(d);
        double d3 = (double)this.x * Math.sin(d) + (double)this.y * Math.cos(d);
        this.x = (int)d2 + point.x;
        this.y = (int)d3 + point.y;
        this.attribs.fig_angle += -d;
        if (this.attribs.fig_angle >= Math.PI * 2) {
            this.attribs.fig_angle -= Math.PI * 2;
        }
        if (this.attribs.fig_angle <= 0.0) {
            this.attribs.fig_angle += Math.PI * 2;
        }
        this.rebuild();
    }

    public void scale(Point point, double d, double d2) {
        this.attribs.fontSize = (int)((double)this.attribs.fontSize * Math.abs(d));
        super.scale(point, d, d2);
        this.rebuild();
    }

    public void mirrorX(int n, int n2) {
        int n3 = 2 * n - this.x;
        int n4 = this.y;
        if (this.attribs.textAlign == 1) {
            this.attribs.textAlign = 3;
        } else if (this.attribs.textAlign == 3) {
            this.attribs.textAlign = 1;
        }
        this.move(n3 - this.x, 0);
    }

    public void mirrorY(int n, int n2) {
        int n3 = this.x;
        int n4 = 2 * n2 - this.y;
        this.move(0, n4 - this.y);
    }

    public void update(FigAttribs figAttribs) {
        this.attribs.update(figAttribs);
        this.rebuild();
    }

    public double minDistance_OLD(Point point) {
        double d = this.bbox.minDistance(point);
        double d2 = Double.MAX_VALUE;
        if (this.bbox.inside(point.x, point.y)) {
            d2 = this.trafo.getSnap();
        }
        return Math.min(d, d2);
    }

    public double minDistance(Point point) {
        double d;
        double d2;
        block2: {
            d2 = Math.abs(point.x - this.x) + Math.abs(point.y - this.y);
            d = this.bbox.minDistance(point);
            if (!this.bbox.isInside(point)) {
                return Math.min(d2, d);
            }
            if (this.border == null) {
                this.update_bbox();
            }
            if (!this.border.contains(point.x, point.y)) break block2;
            d = 0.9 * (double)this.trafo.getSnapRelative();
        }
        return Math.min(d2, d);
    }

    public double minDistanceEuclid(Point point) {
        return this.minDistance(point);
    }

    public Point[] getPoints() {
        Point[] pointArray = new Point[]{new Point(this.x, this.y)};
        return pointArray;
    }

    public void setPoints(Point[] pointArray) {
        if (pointArray == null || pointArray.length < 1) {
            return;
        }
        this.x = pointArray[0].x;
        this.y = pointArray[0].y;
        this.rebuild();
    }

    public String getText() {
        return this.str;
    }

    public void setText(String string) {
        this.str = string != null ? string : " ";
        this.timestamp = 0L;
    }

    public void setTrafo(FigTrafo2D figTrafo2D) {
        this.trafo = figTrafo2D;
        this.timestamp = 0L;
    }

    public void setFont(int n) {
        this.attribs.fig_font = n;
        this.timestamp = 0L;
    }

    public void setFontSize(int n) {
        this.attribs.fontSize = n;
        this.timestamp = 0L;
    }

    public void setTextAlignment(int n) {
        this.attribs.textAlign = n;
        this.timestamp = 0L;
    }

    public void setColor(Color color) {
        int n;
        this.attribs.fig_line_color = n = ColorCache.getColorCache().registerUserColor(color);
        this.attribs.lineColor = color;
    }

    public void keyPressed(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        int n = keyEvent.getKeyCode();
        if (this.debug) {
            this.message(this.toString() + ".keyPressed: " + keyEvent);
        }
        if (keyEvent.isActionKey()) {
            if (n == 37) {
                --this.textCursorIndex;
                if (this.textCursorIndex < 0) {
                    this.textCursorIndex = 0;
                }
            } else if (n == 39) {
                ++this.textCursorIndex;
                if (this.textCursorIndex >= this.str.length()) {
                    this.textCursorIndex = this.str.length();
                }
            } else if (n == 38 || n == 40) {
                // empty if block
            }
        }
        if (c == '\b' || c == '\u007f' || c == '\b' || c == '\uffff' || c == '\uff08') {
            if (this.str.length() > 0) {
                if (this.str.length() > this.textCursorIndex) {
                    this.str = this.str.substring(0, this.textCursorIndex) + this.str.substring(this.textCursorIndex + 1, this.str.length());
                } else {
                    this.str = this.str.substring(0, this.textCursorIndex - 1);
                    --this.textCursorIndex;
                }
            }
        } else {
            if (c < ' ') {
                if (this.debug) {
                    this.message("Ignoring control char: '" + c);
                }
                return;
            }
            if (c > '\u00ff') {
                char c2 = c;
            } else {
                int n2;
                if (keyEvent.isAltDown()) {
                    if (c == 'a') {
                        n2 = 228;
                    } else if (c == 'A') {
                        n2 = 196;
                    } else if (c == 'o') {
                        n2 = 246;
                    } else if (c == 'O') {
                        n2 = 214;
                    } else if (c == 'u') {
                        n2 = 252;
                    } else if (c == 'U') {
                        n2 = 220;
                    } else if (c == 's') {
                        n2 = 223;
                    } else {
                        this.message("FigText: ignored <ALT> modifier for key:" + c);
                        n2 = c;
                    }
                } else {
                    n2 = c;
                }
                this.str = this.str.substring(0, this.textCursorIndex) + (char)n2 + this.str.substring(this.textCursorIndex, this.str.length());
                ++this.textCursorIndex;
            }
        }
        this.update_bbox();
        super.build_sc_bbox();
    }

    public static String symbol_recode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            stringBuffer.append(recode_table[string.charAt(n)]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public String toString() {
        String string = "FigText at " + this.x + "," + this.y + " layer " + this.attribs.currentLayer + " timestamp " + this.timestamp + " text: '" + this.str + "' ";
        return string;
    }

    public FigText() {
        this.attribs.currentLayer = 5;
        this.debug = false;
        this.selected = false;
        this.timestamp = 0L;
        this.str = "";
        this.update_bbox();
        this.createRenderer();
    }

    public FigText(Point point, String string, FigAttribs figAttribs, FigTrafo2D figTrafo2D) {
        this();
        this.x = point.x;
        this.y = point.y;
        this.str = new String(string);
        this.attribs = figAttribs.getClone();
        this.trafo = figTrafo2D;
        this.update_bbox();
    }

    static {
        int n = 0;
        while (n < 65535) {
            FigText.recode_table[n] = n;
            n = (char)(n + 1);
        }
        FigText.recode_table[97] = 945;
        FigText.recode_table[98] = 946;
        FigText.recode_table[99] = 967;
        FigText.recode_table[100] = 948;
        FigText.recode_table[101] = 949;
        FigText.recode_table[102] = 966;
        FigText.recode_table[103] = 947;
        FigText.recode_table[104] = 951;
        FigText.recode_table[105] = 953;
        FigText.recode_table[106] = 981;
        FigText.recode_table[107] = 954;
        FigText.recode_table[108] = 955;
        FigText.recode_table[109] = 956;
        FigText.recode_table[110] = 957;
        FigText.recode_table[111] = 959;
        FigText.recode_table[112] = 960;
        FigText.recode_table[113] = 952;
        FigText.recode_table[114] = 961;
        FigText.recode_table[115] = 963;
        FigText.recode_table[116] = 964;
        FigText.recode_table[117] = 965;
        FigText.recode_table[118] = 982;
        FigText.recode_table[119] = 969;
        FigText.recode_table[120] = 958;
        FigText.recode_table[121] = 968;
        FigText.recode_table[122] = 950;
        FigText.recode_table[65] = 913;
        FigText.recode_table[66] = 914;
        FigText.recode_table[67] = 935;
        FigText.recode_table[68] = 916;
        FigText.recode_table[69] = 917;
        FigText.recode_table[70] = 934;
        FigText.recode_table[71] = 915;
        FigText.recode_table[72] = 919;
        FigText.recode_table[73] = 921;
        FigText.recode_table[74] = 977;
        FigText.recode_table[75] = 922;
        FigText.recode_table[76] = 923;
        FigText.recode_table[77] = 924;
        FigText.recode_table[78] = 925;
        FigText.recode_table[79] = 927;
        FigText.recode_table[80] = 928;
        FigText.recode_table[81] = 920;
        FigText.recode_table[82] = 929;
        FigText.recode_table[83] = 931;
        FigText.recode_table[84] = 932;
        FigText.recode_table[85] = 933;
        FigText.recode_table[86] = 962;
        FigText.recode_table[87] = 937;
        FigText.recode_table[88] = 926;
        FigText.recode_table[89] = 936;
        FigText.recode_table[90] = 918;
        FigText.recode_table[161] = 978;
        FigText.recode_table[162] = 39;
        FigText.recode_table[163] = 8804;
        FigText.recode_table[164] = 8725;
        FigText.recode_table[165] = 8734;
        FigText.recode_table[166] = 102;
        FigText.recode_table[167] = 10088;
        FigText.recode_table[168] = 10069;
        FigText.recode_table[169] = 10084;
        FigText.recode_table[170] = 10085;
        FigText.recode_table[171] = 63;
        FigText.recode_table[172] = 63;
        FigText.recode_table[173] = 63;
        FigText.recode_table[174] = 63;
        FigText.recode_table[175] = 63;
        FigText.recode_table[176] = 8728;
        FigText.recode_table[177] = 177;
        FigText.recode_table[178] = 34;
        FigText.recode_table[179] = 8805;
        FigText.recode_table[180] = 10005;
        FigText.recode_table[181] = 8733;
        FigText.recode_table[182] = 100;
        FigText.recode_table[183] = 8729;
        FigText.recode_table[184] = 37;
        FigText.recode_table[185] = 8800;
        FigText.recode_table[186] = 8805;
        FigText.recode_table[187] = 8805;
        FigText.recode_table[188] = 8805;
        FigText.recode_table[193] = 73;
        FigText.recode_table[194] = 82;
        FigText.recode_table[195] = 63;
        FigText.recode_table[196] = 8855;
        FigText.recode_table[197] = 8853;
        FigText.recode_table[198] = 8709;
        FigText.recode_table[199] = 8745;
        FigText.recode_table[200] = 8746;
        FigText.recode_table[201] = 8835;
        FigText.recode_table[202] = 8839;
        FigText.recode_table[203] = 8836;
        FigText.recode_table[204] = 8834;
        FigText.recode_table[205] = 8838;
        FigText.recode_table[206] = 8712;
        FigText.recode_table[207] = 8713;
        FigText.recode_table[208] = 63;
        FigText.recode_table[209] = 8711;
        FigText.recode_table[210] = 174;
        FigText.recode_table[211] = 169;
        FigText.recode_table[212] = 63;
        FigText.recode_table[213] = 8719;
        FigText.recode_table[214] = 8730;
        FigText.recode_table[215] = 8901;
        FigText.recode_table[216] = 173;
        FigText.recode_table[217] = 8743;
        FigText.recode_table[218] = 8744;
        FigText.recode_table[219] = 63;
        FigText.recode_table[220] = 63;
        FigText.recode_table[221] = 63;
        FigText.recode_table[222] = 63;
        FigText.recode_table[223] = 63;
        FigText.recode_table[224] = 8900;
        FigText.recode_table[229] = 8721;
        FigText.recode_table[242] = 8747;
        FigText.recode_table[92] = 8756;
        FigText.recode_table[64] = 8773;
        FigText.recode_table[36] = 8707;
        FigText.recode_table[34] = 8704;
        FigText.recode_table[39] = 8717;
        FigText.recode_table[94] = 8869;
        FigText.recode_table[96] = 8722;
    }
}

