/*
 * Decompiled with CFR 0.152.
 */
package jfig.objects;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import jfig.canvas.FigTrafo2D;
import jfig.gui.ColorCache;
import jfig.objects.FigAttribs;
import jfig.objects.FigBaseobject;
import jfig.objects.FigBbox;
import jfig.objects.FigObject;
import jfig.objects.FigObjectFactory;
import jfig.objects.FigRenderer;

public class FigRectangle
extends FigBaseobject {
    protected FigRenderer renderer;
    protected boolean use_rounded_corners;
    protected int radius;
    protected int pixel_width;

    public void createRenderer() {
        this.renderer = FigObjectFactory.getDefaultObjectFactory().createRectangleRenderer(this);
    }

    public void rebuild() {
        this.renderer.rebuild();
    }

    public void setAttributes(FigAttribs figAttribs) {
        super.setAttributes(figAttribs);
        this.rebuild();
    }

    public void setLayer(int n) {
        this.attribs.currentLayer = n;
    }

    public void setLineColor(Color color) {
        int n;
        this.attribs.fig_line_color = n = ColorCache.getColorCache().registerUserColor(color);
        this.attribs.lineColor = color;
    }

    public void setLineWidth(int n) {
        this.attribs.setFigLineWidth(n);
        this.rebuild();
    }

    public void setLineStyle(int n) {
        this.attribs.lineStyle = n;
        this.rebuild();
    }

    public void setFillColor(Color color) {
        int n;
        this.attribs.fig_fill_color = n = ColorCache.getColorCache().registerUserColor(color);
        this.attribs.fillColor = color;
    }

    public void setFillStyle(int n) {
        if (n < 0) {
            this.attribs.fillStyle = 1;
        } else if (n < 41) {
            this.attribs.fillStyle = 2;
            this.attribs.fig_area_fill = n;
        } else if (n <= 56) {
            this.attribs.fillStyle = 3;
            this.attribs.fig_area_fill = n;
        } else {
            this.message("setFillStyle: value out of range: " + n);
        }
        this.rebuild();
    }

    public boolean isRounded() {
        return this.use_rounded_corners;
    }

    public Point[] getPoints() {
        Point[] pointArray = new Point[]{new Point(this.bbox.getXl(), this.bbox.getYt()), new Point(this.bbox.getXr(), this.bbox.getYb())};
        return pointArray;
    }

    public void setPoints(Point[] pointArray) {
        if (pointArray == null || pointArray.length < 2 || pointArray.length > 3) {
            this.message("-E- a rectangle needs 2 Points for setPoints()");
            return;
        }
        this.bbox.set(pointArray[0].x, pointArray[0].y, pointArray[1].x, pointArray[1].y);
        this.x = this.bbox.getXl();
        this.y = this.bbox.getYt();
        this.rebuild();
    }

    public void update(FigAttribs figAttribs) {
        if (this.debug) {
            this.message("FigRectangle.update()...");
        }
        this.attribs.update(figAttribs);
        this.rebuild();
    }

    public FigObject copy() {
        if (this.debug) {
            this.message("FigRectangle.copy()...");
        }
        FigRectangle figRectangle = new FigRectangle(this.bbox.getXl(), this.bbox.getYt(), this.bbox.getXr(), this.bbox.getYb(), this.use_rounded_corners, this.attribs.getClone(), this.trafo);
        return figRectangle;
    }

    public void move(int n, int n2) {
        this.bbox = new FigBbox(this.bbox.getXl() + n, this.bbox.getYt() + n2, this.bbox.getXr() + n, this.bbox.getYb() + n2);
        this.x = this.bbox.getXl();
        this.y = this.bbox.getYt();
        this.rebuild();
    }

    public void mirrorX(int n, int n2) {
        Point[] pointArray = this.getPoints();
        pointArray[0].x = 2 * n - pointArray[0].x;
        pointArray[1].x = 2 * n - pointArray[1].x;
        this.setPoints(pointArray);
    }

    public void mirrorY(int n, int n2) {
        Point[] pointArray = this.getPoints();
        pointArray[0].y = 2 * n2 - pointArray[0].y;
        pointArray[1].y = 2 * n2 - pointArray[1].y;
        this.setPoints(pointArray);
    }

    public boolean canRotate(double d) {
        int n = (int)(180.0 * Math.abs(d) / Math.PI + 0.5);
        return n % 90 == 0;
    }

    public boolean supportsPointOps() {
        return true;
    }

    public boolean isClosed() {
        return true;
    }

    public void appendPoint(Point point) {
    }

    public Point deletePoint(Point point) {
        return null;
    }

    public void insertPoint(Point point, Point point2) {
    }

    public Point[] getMovePointNeighbors(Point point) {
        int n = Math.abs(point.x - this.bbox.getXl()) < Math.abs(point.x - this.bbox.getXr()) ? this.bbox.getXr() : this.bbox.getXl();
        int n2 = Math.abs(point.y - this.bbox.getYt()) < Math.abs(point.y - this.bbox.getYb()) ? this.bbox.getYb() : this.bbox.getYt();
        Point point2 = new Point(n, n2);
        Point[] pointArray = new Point[]{point2};
        return pointArray;
    }

    public void movePoint(Point point, Point point2) {
        int n = Math.abs(point.x - this.bbox.getXl());
        int n2 = Math.abs(point.x - this.bbox.getXr());
        int n3 = Math.abs(point.y - this.bbox.getYt());
        int n4 = Math.abs(point.y - this.bbox.getYb());
        int n5 = n < n2 ? this.bbox.getXr() : this.bbox.getXl();
        int n6 = n3 < n4 ? this.bbox.getYb() : this.bbox.getYt();
        Point point3 = new Point(n5, n6);
        this.bbox.set(point2.x, point2.y, point3.x, point3.y);
        this.x = this.bbox.getXl();
        this.y = this.bbox.getYt();
        this.rebuild();
    }

    public Point getNearestPoint(Point point) {
        int n = Math.abs(point.x - this.bbox.getXl());
        int n2 = Math.abs(point.x - this.bbox.getXr());
        int n3 = Math.abs(point.y - this.bbox.getYt());
        int n4 = Math.abs(point.y - this.bbox.getYb());
        int n5 = n > n2 ? this.bbox.getXr() : this.bbox.getXl();
        int n6 = n3 > n4 ? this.bbox.getYb() : this.bbox.getYt();
        return new Point(n5, n6);
    }

    public Point[] getNeighborPoints(Point point) {
        Point[] pointArray = new Point[]{point, point, point};
        return pointArray;
    }

    public double minDistance(Point point) {
        return this.bbox.minDistanceInside(point);
    }

    public double minDistanceEuclid(Point point) {
        double d = this.bbox.minDistance(point);
        if (this.bbox.isInside(point)) {
            d = Math.min(d, 0.4 * (double)this.trafo.getSnapRelative());
        }
        return d;
    }

    public void paint(Graphics graphics) {
        this.renderer.paint(graphics);
    }

    public void paint(Graphics graphics, FigTrafo2D figTrafo2D) {
        this.renderer.paint(graphics, figTrafo2D);
    }

    public void paintSave(Graphics graphics, FigTrafo2D figTrafo2D) {
        Graphics graphics2 = graphics.create();
        this.renderer.paint(graphics2, figTrafo2D);
        graphics2.dispose();
    }

    public String toString() {
        String string = "FigRectangle  " + this.bbox + " layer " + this.attribs.currentLayer + " colors " + this.attribs.lineColor + " " + this.attribs.fillColor;
        return string;
    }

    public FigRectangle() {
        this(0, 0, 2400, 2400, 10);
    }

    public FigRectangle(int n, int n2, int n3, int n4, int n5) {
        int n6;
        this.createRenderer();
        if (n > n3) {
            n6 = n3;
            n3 = n;
            n = n6;
        }
        if (n2 > n4) {
            n6 = n4;
            n4 = n2;
            n2 = n6;
        }
        this.x = n;
        this.y = n2;
        this.attribs.currentLayer = n5;
        this.bbox.set(n, n2, n3, n4);
        this.rebuild();
    }

    public FigRectangle(FigBbox figBbox, int n) {
        this(figBbox.getXl(), figBbox.getYt(), figBbox.getXr(), figBbox.getYb(), n);
        this.x = figBbox.getXl();
        this.y = figBbox.getYb();
        this.attribs.currentLayer = n;
        this.attribs.lineColor = Color.black;
        this.attribs.fillColor = Color.black;
        this.rebuild();
    }

    public FigRectangle(int n, int n2, int n3, int n4, boolean bl, FigAttribs figAttribs, FigTrafo2D figTrafo2D) {
        this(n, n2, n3, n4, 1);
        this.trafo = figTrafo2D;
        this.attribs = figAttribs.getClone();
        this.use_rounded_corners = bl;
        if (!bl) {
            this.attribs.cornerRadius = 0;
        }
        this.rebuild();
    }
}

