/*
 * Decompiled with CFR 0.152.
 */
package jfig.objects;

import java.awt.Point;
import java.util.Enumeration;
import jfig.objects.FigObject;
import jfig.objects.ListNode;
import jfig.utils.ShellSort;

public final class FigObjectList
implements Enumeration {
    ListNode root;
    ListNode otmp;
    String name;
    ListNode enumerationNode;

    public final ListNode get_root() {
        return this.root;
    }

    public final ListNode get_first() {
        if (this.root.next != this.root) {
            return this.root.next;
        }
        return null;
    }

    public final ListNode get_last() {
        if (this.root.prev != this.root) {
            return this.root.prev;
        }
        return null;
    }

    public final ListNode get_next(ListNode listNode) {
        if (listNode == null) {
            return null;
        }
        if (listNode.next != this.root) {
            return listNode.next;
        }
        return null;
    }

    public final ListNode get_prev(ListNode listNode) {
        if (listNode == null) {
            return null;
        }
        if (listNode.prev != this.root) {
            return listNode.prev;
        }
        return null;
    }

    public final void append(FigObject figObject) {
        ListNode listNode;
        this.root.prev.next = listNode = new ListNode(figObject, this.root.prev, this.root);
        this.root.prev = listNode;
    }

    public final void prepend(FigObject figObject) {
        ListNode listNode;
        this.root.next.prev = listNode = new ListNode(figObject, this.root, this.root.next);
        this.root.next = listNode;
    }

    public final void insert(FigObject figObject) {
        ListNode listNode;
        int n = figObject.getLayer();
        this.otmp = this.root.next;
        while (this.otmp != this.root) {
            if (this.otmp.get_obj().getLayer() <= n) {
                ListNode listNode2;
                this.otmp.prev.next = listNode2 = new ListNode(figObject, this.otmp.prev, this.otmp);
                this.otmp.prev = listNode2;
                return;
            }
            this.otmp = this.otmp.next;
        }
        this.root.prev.next = listNode = new ListNode(figObject, this.root.prev, this.root);
        this.root.prev = listNode;
    }

    public final boolean delete(ListNode listNode) {
        this.otmp = this.root.next;
        while (this.otmp != this.root) {
            if (this.otmp == listNode) {
                this.otmp.prev.next = this.otmp.next;
                this.otmp.next.prev = this.otmp.prev;
                this.otmp = null;
                return true;
            }
            this.otmp = this.otmp.next;
        }
        return false;
    }

    public final boolean delete(FigObject figObject) {
        this.otmp = this.root.next;
        while (this.otmp != this.root) {
            if (this.otmp.get_obj() == figObject) {
                this.otmp.prev.next = this.otmp.next;
                this.otmp.next.prev = this.otmp.prev;
                this.otmp = null;
                return true;
            }
            this.otmp = this.otmp.next;
        }
        return false;
    }

    public final boolean deleteAllSLOW() {
        this.otmp = this.root.next;
        while (this.otmp != this.root) {
            this.otmp.prev.next = this.otmp.next;
            this.otmp.next.prev = this.otmp.prev;
            this.otmp = this.otmp.next;
        }
        return true;
    }

    public final boolean deleteAll() {
        this.root.next = this.root;
        this.root.prev = this.root;
        return true;
    }

    public final FigObjectList copy() {
        FigObjectList figObjectList = new FigObjectList();
        this.otmp = this.root.next;
        while (this.otmp != this.root) {
            figObjectList.append(this.otmp.obj);
            this.otmp = this.otmp.next;
        }
        return figObjectList;
    }

    public final ListNode search(Point point) {
        return this.search(point, this.root.next);
    }

    public final ListNode search(Point point, ListNode listNode) {
        double d = 1.0E10;
        ListNode listNode2 = null;
        this.otmp = listNode;
        while (this.otmp != this.root) {
            double d2 = this.otmp.obj.minDistance(point);
            if (d2 < d) {
                d = d2;
                listNode2 = this.otmp;
            }
            if (d2 == 0.0) {
                return this.otmp;
            }
            this.otmp = this.otmp.next;
        }
        return listNode2;
    }

    public ListNode search(Point point, ListNode listNode, int n) {
        double d = n;
        ListNode listNode2 = null;
        if (listNode == null) {
            listNode = this.root.next;
        }
        this.otmp = listNode;
        while (this.otmp != this.root) {
            double d2 = this.otmp.obj.minDistance(point);
            if (d2 < d) {
                d = d2;
                listNode2 = this.otmp;
            }
            if (d2 == 0.0) {
                return this.otmp;
            }
            this.otmp = this.otmp.next;
        }
        return listNode2;
    }

    public ListNode search(Point point, int n) {
        return this.search(point, this.root.next, n);
    }

    public void print() {
        System.out.println(this.name + ".print():");
        this.otmp = this.root.next;
        while (this.otmp != this.root) {
            System.out.println(this.otmp.get_obj().toString());
            this.otmp = this.otmp.next;
        }
        System.out.println(this.name + " ok");
    }

    public boolean empty() {
        return this.root.next == this.root;
    }

    public Enumeration elements_old() {
        this.enumerationNode = this.root;
        return this;
    }

    public boolean hasMoreElements() {
        return this.enumerationNode.get_next() != this.root;
    }

    public Object nextElement() {
        if (this.enumerationNode.get_next() == this.root) {
            return null;
        }
        this.enumerationNode = this.enumerationNode.get_next();
        return this.enumerationNode.get_obj();
    }

    public Enumeration elements() {
        FigObjectList figObjectList = this;
        if (figObjectList == null) {
            throw null;
        }
        return figObjectList.new ListEnumerator();
    }

    public Enumeration reverseElements() {
        FigObjectList figObjectList = this;
        if (figObjectList == null) {
            throw null;
        }
        return figObjectList.new ReverseListEnumerator();
    }

    public void sort() {
        FigObjectList figObjectList = this;
        synchronized (figObjectList) {
            int n = 0;
            this.otmp = this.root.next;
            while (this.otmp != this.root) {
                ++n;
                this.otmp = this.otmp.next;
            }
            if (n < 2) {
                Object var2_3 = null;
                return;
            }
            double[] dArray = new double[n];
            Object[] objectArray = new ListNode[n];
            this.otmp = this.root.next;
            int n2 = 0;
            while (n2 < n) {
                objectArray[n2] = this.otmp;
                dArray[n2] = this.otmp.get_obj().getLayer();
                this.otmp = this.otmp.next;
                ++n2;
            }
            ShellSort.shellSort(dArray, objectArray);
            this.deleteAll();
            n2 = 0;
            while (n2 < n) {
                ((ListNode)objectArray[n2]).next = this.root.next;
                this.root.next.prev = objectArray[n2];
                this.root.next = objectArray[n2];
                ((ListNode)objectArray[n2]).prev = this.root;
                ++n2;
            }
        }
    }

    public FigObjectList() {
        this.enumerationNode = this.root;
        this.root.next = this.root = new ListNode();
        this.root.prev = this.root;
        this.root.obj = null;
        this.name = "unnamed Object list";
    }

    public FigObjectList(String string) {
        this();
        this.name = string;
    }

    class ListEnumerator
    implements Enumeration {
        ListNode cursor = null;

        public Object nextElement() {
            if (this.cursor.get_next() == null) {
                return null;
            }
            if (this.cursor.get_next() == FigObjectList.this.root) {
                return null;
            }
            this.cursor = this.cursor.get_next();
            return this.cursor.get_obj();
        }

        public boolean hasMoreElements() {
            return this.cursor.get_next() != null && this.cursor.get_next() != FigObjectList.this.root;
        }

        public ListEnumerator() {
            this.cursor = FigObjectList.this.root;
        }
    }

    class ReverseListEnumerator
    implements Enumeration {
        ListNode cursor = null;

        public Object nextElement() {
            if (this.cursor.get_prev() == null) {
                return null;
            }
            if (this.cursor.get_prev() == FigObjectList.this.root) {
                return null;
            }
            this.cursor = this.cursor.get_prev();
            return this.cursor.get_obj();
        }

        public boolean hasMoreElements() {
            return this.cursor.get_prev() != null && this.cursor.get_prev() != FigObjectList.this.root;
        }

        public ReverseListEnumerator() {
            this.cursor = FigObjectList.this.root;
        }
    }
}

