/*
 * Decompiled with CFR 0.152.
 */
package jfig.objects;

import java.awt.Point;
import jfig.canvas.FigTrafo2D;
import jfig.objects.FigAttribs;
import jfig.objects.FigObject;
import jfig.objects.FigXSpline;

public class FigGeneralXSpline
extends FigXSpline {
    public void createSfactors() {
        if (this.sfactors == null || this.sfactors.length != this.wcp.length) {
            this.sfactors = new double[this.wcp.length];
            int n = 0;
            while (n < this.sfactors.length) {
                this.sfactors[n] = -1.0;
                ++n;
            }
            if (!this.is_closed) {
                this.sfactors[0] = 0.0;
                this.sfactors[this.sfactors.length - 1] = 0.0;
            }
        }
    }

    public FigObject copy() {
        FigGeneralXSpline figGeneralXSpline = new FigGeneralXSpline(this.wcp[0].x, this.wcp[0].y, this.is_closed, this.attribs.getClone(), this.trafo);
        figGeneralXSpline.setPoints(this.getPoints());
        double[] dArray = new double[this.sfactors.length];
        System.arraycopy(this.sfactors, 0, dArray, 0, this.sfactors.length);
        figGeneralXSpline.setSFactors(dArray);
        return figGeneralXSpline;
    }

    public void insertPoint(Point point, Point point2) {
        if (this.debug) {
            this.message("FigGeneralXSpline.insertPoint()...");
        }
        boolean bl = false;
        int n = -1;
        int n2 = 0;
        while (n2 < this.wcp.length) {
            if (point2.x == this.wcp[n2].x && point2.y == this.wcp[n2].y) {
                n = n2;
            }
            if (point.x == this.wcp[n2].x && point.y == this.wcp[n2].y) {
                bl = true;
            }
            ++n2;
        }
        if (n == -1) {
            this.message("FigGeneralXSpline.insertPoint(): Point wprev " + point2.toString() + "is not a Point on this polyline!");
            return;
        }
        if (bl) {
            this.message("FigGeneralXSpline.insertPoint(): Point wp " + point.toString() + "is already a Point on this polyline!");
            return;
        }
        Point[] pointArray = new Point[this.wcp.length + 1];
        double[] dArray = new double[this.wcp.length + 1];
        int n3 = 0;
        while (n3 <= n) {
            pointArray[n3] = this.wcp[n3];
            dArray[n3] = this.sfactors[n3];
            ++n3;
        }
        pointArray[n + 1] = new Point(point.x, point.y);
        dArray[n + 1] = 1.0;
        n3 = n + 2;
        while (n3 < pointArray.length) {
            pointArray[n3] = this.wcp[n3 - 1];
            dArray[n3] = this.sfactors[n3 - 1];
            ++n3;
        }
        this.wcp = pointArray;
        this.sfactors = dArray;
        this.rebuild();
    }

    public Point deletePoint(Point point) {
        if (this.debug) {
            this.message("FigGeneralXSpline.deletePoint()...");
        }
        if (this.wcp.length <= this.min_num_points) {
            return null;
        }
        int n = this.indexOfNearestNeighbor(point);
        if (n == -1) {
            this.message("FigGeneralXSpline.delete(): Point wp " + point.toString() + "is not a Point on this polyline!");
            return null;
        }
        Point point2 = n > 0 ? this.wcp[n - 1] : this.wcp[0];
        Point[] pointArray = new Point[this.wcp.length - 1];
        double[] dArray = new double[this.wcp.length - 1];
        int n2 = 0;
        while (n2 < n) {
            pointArray[n2] = this.wcp[n2];
            dArray[n2] = this.sfactors[n2];
            ++n2;
        }
        n2 = n;
        while (n2 < pointArray.length) {
            pointArray[n2] = this.wcp[n2 + 1];
            dArray[n2] = this.sfactors[n2 + 1];
            ++n2;
        }
        this.wcp = pointArray;
        this.sfactors = dArray;
        this.rebuild();
        return point2;
    }

    public void rebuild() {
        super.rebuild();
    }

    public FigGeneralXSpline(int n, int n2, FigAttribs figAttribs, FigTrafo2D figTrafo2D) {
        super(n, n2, figAttribs, figTrafo2D);
    }

    public FigGeneralXSpline(int n, int n2, boolean bl, FigAttribs figAttribs, FigTrafo2D figTrafo2D) {
        super(n, n2, bl, figAttribs, figTrafo2D);
    }
}

