/*
 * Decompiled with CFR 0.152.
 */
package jfig.objects;

import java.awt.Graphics;
import java.awt.Point;
import jfig.canvas.FigTrafo2D;
import jfig.canvas.ObjectPainter;
import jfig.objects.FigAttribs;
import jfig.objects.FigBaseobject;
import jfig.objects.FigBbox;
import jfig.objects.FigObject;
import jfig.objects.FigObjectList;
import jfig.objects.ListNode;

public class FigCompound
extends FigBaseobject {
    FigObjectList members = new FigObjectList();

    public void addMember(FigObject figObject) {
        this.members.insert(figObject);
        this.update_bbox();
    }

    public void fastAddMember(FigObject figObject) {
        this.members.insert(figObject);
    }

    public boolean deleteMember(FigObject figObject) {
        boolean bl = this.members.delete(figObject);
        if (bl) {
            this.update_bbox();
        }
        return bl;
    }

    public boolean deleteAllMembers() {
        boolean bl = this.members.elements().hasMoreElements();
        this.members = new FigObjectList();
        this.update_bbox();
        return bl;
    }

    public boolean isMember(FigObject figObject) {
        ListNode listNode = this.members.get_first();
        while (listNode != null) {
            if (listNode.obj == figObject) {
                return true;
            }
            listNode = this.members.get_next(listNode);
        }
        return false;
    }

    public void update_bbox() {
        ListNode listNode;
        if (this.members.get_first() == null) {
            this.bbox = new FigBbox(0, 0, 0, 0);
        } else {
            this.bbox = new FigBbox(this.members.get_first().obj.getBbox());
            listNode = this.members.get_first();
            while (listNode != null) {
                this.bbox = this.bbox.union(listNode.obj.getBbox());
                listNode = this.members.get_next(listNode);
            }
        }
        this.sc_bbox_timestamp = 0L;
        this.build_sc_bbox();
        listNode = this.members.get_last();
        if (listNode != null) {
            this.attribs.currentLayer = listNode.obj.getAttributes().currentLayer;
        }
    }

    public FigObjectList getMembers() {
        return this.members;
    }

    public void move(int n, int n2) {
        super.move(n, n2);
        if (this.members == null) {
            return;
        }
        ListNode listNode = this.members.get_first();
        while (listNode != null) {
            listNode.obj.move(n, n2);
            listNode = this.members.get_next(listNode);
        }
        this.update_bbox();
    }

    public void mirrorX(int n, int n2) {
        int n3;
        ListNode listNode = this.members.get_first();
        while (listNode != null) {
            listNode.obj.mirrorX(n, n2);
            listNode = this.members.get_next(listNode);
        }
        this.x = n3 = 2 * n - this.x;
        this.update_bbox();
    }

    public void mirrorY(int n, int n2) {
        int n3;
        ListNode listNode = this.members.get_first();
        while (listNode != null) {
            listNode.obj.mirrorY(n, n2);
            listNode = this.members.get_next(listNode);
        }
        this.y = n3 = 2 * n2 - this.y;
        this.update_bbox();
    }

    public void scale(Point point, double d, double d2) {
        if (this.members == null) {
            return;
        }
        ListNode listNode = this.members.get_first();
        while (listNode != null) {
            listNode.obj.scale(point, d, d2);
            listNode = this.members.get_next(listNode);
        }
        this.update_bbox();
    }

    public void update(FigAttribs figAttribs) {
        if (this.members == null) {
            return;
        }
        this.attribs.update(figAttribs);
        ListNode listNode = this.members.get_first();
        while (listNode != null) {
            listNode.obj.update(figAttribs);
            listNode = this.members.get_next(listNode);
        }
        this.update_bbox();
    }

    public void rebuild() {
        if (this.members == null) {
            return;
        }
        ListNode listNode = this.members.get_first();
        while (listNode != null) {
            listNode.obj.rebuild();
            listNode = this.members.get_next(listNode);
        }
        this.update_bbox();
    }

    public void changeLayerRecursively(FigAttribs figAttribs) {
        ListNode listNode = this.members.get_last();
        int n = figAttribs.currentLayer;
        int n2 = 0;
        int n3 = 0;
        if (listNode != null) {
            n2 = listNode.obj.getAttributes().currentLayer;
        }
        n3 = n - n2;
        listNode = this.members.get_first();
        while (listNode != null) {
            FigObject figObject = listNode.obj;
            FigAttribs figAttribs2 = figObject.getAttributes();
            figAttribs2.currentLayer += n3;
            if (figObject instanceof FigCompound) {
                ((FigCompound)figObject).changeLayerRecursively(figAttribs);
            }
            listNode = this.members.get_next(listNode);
        }
    }

    public FigObject copy() {
        if (this.members == null) {
            return null;
        }
        FigCompound figCompound = new FigCompound();
        figCompound.setTrafo(this.trafo);
        ListNode listNode = this.members.get_first();
        while (listNode != null) {
            figCompound.fastAddMember(listNode.obj.copy());
            listNode = this.members.get_next(listNode);
        }
        figCompound.update_bbox();
        return figCompound;
    }

    public void setTrafo(FigTrafo2D figTrafo2D) {
        ListNode listNode = this.members.get_first();
        while (listNode != null) {
            listNode.obj.setTrafo(figTrafo2D);
            listNode = this.members.get_next(listNode);
        }
        super.setTrafo(figTrafo2D);
        this.update_bbox();
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
        ListNode listNode = this.members.get_first();
        while (listNode != null) {
            listNode.obj.setVisible(bl);
            listNode = this.members.get_next(listNode);
        }
    }

    public void setObjectPainter(ObjectPainter objectPainter) {
        ListNode listNode = this.members.get_first();
        while (listNode != null) {
            listNode.obj.setObjectPainter(objectPainter);
            listNode = this.members.get_next(listNode);
        }
        this.painter = objectPainter;
    }

    public void paint(Graphics graphics) {
        if (this.members == null) {
            return;
        }
        ListNode listNode = this.members.get_first();
        while (listNode != null) {
            listNode.obj.paint(graphics);
            listNode = this.members.get_next(listNode);
        }
        super.paint(graphics);
    }

    public void paintSave(Graphics graphics, FigTrafo2D figTrafo2D) {
        if (this.members == null) {
            return;
        }
        ListNode listNode = this.members.get_first();
        while (listNode != null) {
            Graphics graphics2 = graphics.create();
            listNode.obj.paintSave(graphics2, figTrafo2D);
            graphics2.dispose();
            listNode = this.members.get_next(listNode);
        }
    }

    public void paintInverse(Graphics graphics) {
        if (this.members == null) {
            return;
        }
        ListNode listNode = this.members.get_last();
        while (listNode != null) {
            listNode.obj.paint(graphics);
            listNode = this.members.get_prev(listNode);
        }
        super.paint(graphics);
    }

    public boolean canRotate(double d) {
        if (this.members == null) {
            return false;
        }
        boolean bl = true;
        ListNode listNode = this.members.get_first();
        while (listNode != null) {
            bl = bl && listNode.obj.canRotate(d);
            listNode = this.members.get_next(listNode);
        }
        return bl;
    }

    public void rotate(Point point, double d) throws Exception {
        if (this.members == null) {
            return;
        }
        ListNode listNode = this.members.get_first();
        while (listNode != null) {
            listNode.obj.rotate(point, d);
            listNode = this.members.get_next(listNode);
        }
        this.update_bbox();
    }

    public void paint(Graphics graphics, FigBbox figBbox) {
        if (this.members == null) {
            return;
        }
        ListNode listNode = this.members.get_first();
        while (listNode != null) {
            if (listNode.obj.getBbox().isVisible(figBbox)) {
                if (listNode.obj instanceof FigCompound) {
                    ((FigCompound)listNode.obj).paint(graphics, figBbox);
                } else {
                    listNode.obj.paint(graphics);
                }
            }
            listNode = this.members.get_next(listNode);
        }
        super.paint(graphics);
    }

    public double minDistanceEuclid(Point point) {
        double d = this.bbox.minDistance(point);
        if (this.bbox.isInside(point)) {
            d = Math.min(d, 0.4 * (double)this.trafo.getSnapRelative());
        }
        return d;
    }

    public String toString() {
        String string = "FigCompound at (" + this.x + ", " + this.y + ") on layer " + this.getLayer();
        if (this.members != null) {
            ListNode listNode = this.members.get_first();
            while (listNode != null) {
                string = string + "\n..." + listNode.obj.toString();
                listNode = this.members.get_next(listNode);
            }
        }
        return string;
    }

    public FigCompound() {
        this.update_bbox();
    }
}

