/*
 * Decompiled with CFR 0.152.
 */
package jfig.objects;

import java.awt.Point;
import jfig.canvas.FigTrafo2D;
import jfig.objects.FigAttribs;
import jfig.objects.FigObject;
import jfig.objects.FigObjectFactory;
import jfig.objects.FigPolyline;

public class FigBezier
extends FigPolyline {
    static final int PPMAX = 6000;
    static Point[] pp = new Point[6000];
    Point[] wcp_spline;
    Point[] wcp1;
    ControlPoint[] cpp;
    int ii = 0;
    double[][] stack = new double[20][8];
    int stack_p = 0;
    final double T;
    final double _2xPI = Math.PI * 2;
    final double _1dSQR2;
    final double _SQR2;
    final double M_PI_2;

    public void createRenderer() {
        this.renderer = FigObjectFactory.getDefaultObjectFactory().createBezierSplineRenderer(this);
    }

    final int round(double d) {
        return (int)(d + 0.5);
    }

    public double[] getControlPoints() {
        double[] dArray = new double[4 * this.cpp.length];
        int n = 0;
        while (n < this.cpp.length) {
            dArray[4 * n] = this.cpp[n].lx;
            dArray[4 * n + 1] = this.cpp[n].ly;
            dArray[4 * n + 2] = this.cpp[n].rx;
            dArray[4 * n + 3] = this.cpp[n].ry;
            ++n;
        }
        return dArray;
    }

    public Point[] getSplinePoints() {
        return this.wcp_spline;
    }

    private void build_PP() {
        Point point = this.wcp1[0];
        ControlPoint controlPoint = this.cpp[0];
        this.ii = 0;
        int n = 1;
        while (n < this.wcp1.length) {
            Point point2 = this.wcp1[n];
            ControlPoint controlPoint2 = this.cpp[n];
            this.bezier_spline(point.x, point.y, controlPoint.rx, controlPoint.ry, controlPoint2.lx, controlPoint2.ly, point2.x, point2.y);
            point = point2;
            controlPoint = controlPoint2;
            ++n;
        }
        FigBezier.pp[this.ii++] = new Point(this.wcp1[this.wcp1.length - 1].x, this.wcp1[this.wcp1.length - 1].y);
    }

    private void bezier_spline(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        double d9 = Math.max(20.0 / this.trafo.getZoom(), 20.0);
        this.clear_stack();
        this.push(d, d2, d3, d4, d5, d6, d7, d8);
        while (this.pop()) {
            double d10 = this.stack[this.stack_p][0];
            double d11 = this.stack[this.stack_p][1];
            double d12 = this.stack[this.stack_p][2];
            double d13 = this.stack[this.stack_p][3];
            double d14 = this.stack[this.stack_p][4];
            double d15 = this.stack[this.stack_p][5];
            double d16 = this.stack[this.stack_p][6];
            double d17 = this.stack[this.stack_p][7];
            if (Math.abs(d10 - d16) < d9 && Math.abs(d11 - d17) < d9) {
                if (this.ii > 5996) break;
                FigBezier.pp[this.ii++] = new Point(this.round(d10), this.round(d11));
                continue;
            }
            double d18 = 0.5 * (d12 + d14);
            double d19 = 0.5 * (d13 + d15);
            double d20 = 0.5 * (d10 + d12);
            double d21 = 0.5 * (d11 + d13);
            double d22 = 0.5 * (d20 + d18);
            double d23 = 0.5 * (d21 + d19);
            double d24 = 0.5 * (d14 + d16);
            double d25 = 0.5 * (d15 + d17);
            double d26 = 0.5 * (d24 + d18);
            double d27 = 0.5 * (d25 + d19);
            double d28 = 0.5 * (d22 + d26);
            double d29 = 0.5 * (d23 + d27);
            this.push(d28, d29, d26, d27, d24, d25, d16, d17);
            this.push(d10, d11, d20, d21, d22, d23, d28, d29);
        }
    }

    private void clear_stack() {
        this.stack_p = 0;
    }

    private void push(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        this.stack[this.stack_p][0] = d;
        this.stack[this.stack_p][1] = d2;
        this.stack[this.stack_p][2] = d3;
        this.stack[this.stack_p][3] = d4;
        this.stack[this.stack_p][4] = d5;
        this.stack[this.stack_p][5] = d6;
        this.stack[this.stack_p][6] = d7;
        this.stack[this.stack_p][7] = d8;
        ++this.stack_p;
    }

    private boolean pop() {
        if (this.stack_p == 0) {
            return false;
        }
        --this.stack_p;
        return true;
    }

    public String toString() {
        String string = "FigBezier with " + this.wcp.length + " control points: ";
        int n = 0;
        while (n < this.wcp.length) {
            string = string + "( " + this.wcp[n].x + ", " + this.wcp[n].y + "), ";
            ++n;
        }
        if (this.wcp_spline != null) {
            string = string + "\n#interpolated points: " + this.wcp_spline.length;
        }
        return string;
    }

    private void create_wcp1() {
        this.wcp1 = this.is_closed ? new Point[this.wcp.length + 1] : new Point[this.wcp.length];
        int n = 0;
        while (n < this.wcp.length) {
            this.wcp1[n] = this.wcp[n];
            ++n;
        }
        if (this.is_closed) {
            this.wcp1[this.wcp.length] = this.wcp[0];
        }
    }

    private void create_control_points() {
        this.cpp = new ControlPoint[this.wcp1.length];
        int n = 0;
        while (n < this.cpp.length) {
            FigBezier figBezier = this;
            if (figBezier == null) {
                throw null;
            }
            this.cpp[n] = figBezier.new ControlPoint();
            ++n;
        }
    }

    private void compute_control_points() {
        Point point;
        double d = this.wcp1[0].x;
        double d2 = this.wcp1[0].y;
        Point point2 = point = this.wcp1[1];
        double d3 = point.x;
        double d4 = point.y;
        Point point3 = this.wcp1[2];
        double d5 = point3.x;
        double d6 = point3.y;
        double d7 = d - d3;
        double d8 = d4 - d2;
        double d9 = Math.sqrt(d7 * d7 + d8 * d8);
        double d10 = d9 == 0.0 ? 0.0 : Math.atan2(d8, d7);
        d7 = d5 - d3;
        d8 = d4 - d6;
        double d11 = Math.sqrt(d7 * d7 + d8 * d8);
        double d12 = d11 == 0.0 ? 0.0 : Math.atan2(d8, d7);
        if (d10 < 0.0) {
            d10 += Math.PI * 2;
        }
        if (d12 < 0.0) {
            d12 += Math.PI * 2;
        }
        ControlPoint controlPoint = this.cpp[1];
        this.set_control_point(d3, d4, d9, d11, d10, d12, 0.45, controlPoint);
        if (!this.is_closed) {
            this.cpp[0].lx = 0.0;
            this.cpp[0].ly = 0.0;
            this.cpp[0].rx = (d + 3.0 * controlPoint.lx) * 0.25;
            this.cpp[0].ry = (d2 + 3.0 * controlPoint.ly) * 0.25;
            controlPoint.lx = (3.0 * controlPoint.lx + d3) * 0.25;
            controlPoint.ly = (3.0 * controlPoint.ly + d4) * 0.25;
        }
        int n = 2;
        while (true) {
            d3 = d5;
            d4 = d6;
            d9 = d11;
            d10 = d12 >= Math.PI ? d12 - Math.PI : d12 + Math.PI;
            if (n >= this.wcp1.length - 1) break;
            point3 = this.wcp1[++n];
            point2 = this.wcp1[n - 1];
            d5 = point3.x;
            d7 = d5 - d3;
            d6 = point3.y;
            d8 = d4 - d6;
            d11 = Math.sqrt(d7 * d7 + d8 * d8);
            d12 = d11 == 0.0 ? 0.0 : Math.atan2(d8, d7);
            if (d12 < 0.0) {
                d12 += Math.PI * 2;
            }
            controlPoint = this.cpp[n - 1];
            this.set_control_point(d3, d4, d9, d11, d10, d12, 0.45, controlPoint);
        }
        if (this.is_closed) {
            d7 = (double)point.x - d3;
            d8 = d4 - (double)point.y;
            d11 = Math.sqrt(d7 * d7 + d8 * d8);
            d12 = Math.atan2(d8, d7);
            if (d12 < 0.0) {
                d12 += Math.PI * 2;
            }
            controlPoint = this.cpp[this.cpp.length - 1];
            this.set_control_point(d3, d4, d9, d11, d10, d12, 0.45, controlPoint);
            this.cpp[0].lx = controlPoint.lx;
            this.cpp[0].ly = controlPoint.ly;
            this.cpp[0].rx = controlPoint.rx;
            this.cpp[0].ry = controlPoint.ry;
        } else {
            ControlPoint controlPoint2 = this.cpp[this.cpp.length - 1];
            controlPoint2.lx = (3.0 * controlPoint.rx + d3) * 0.25;
            controlPoint2.ly = (3.0 * controlPoint.ry + d4) * 0.25;
            controlPoint2.rx = 0.0;
            controlPoint2.ry = 0.0;
            controlPoint.rx = ((double)point2.x + 3.0 * controlPoint.rx) * 0.25;
            controlPoint.ry = ((double)point2.y + 3.0 * controlPoint.ry) * 0.25;
        }
        if (this.debug) {
            System.out.println("FigBezier.compute_control_points(): ");
            n = 0;
            while (n < this.wcp1.length) {
                System.out.println("wcp1[" + n + "]= (" + this.wcp1[n].x + ", " + this.wcp1[n].y + ")  cpp[]= (" + this.cpp[n].lx + ", " + this.cpp[n].ly + ", " + this.cpp[n].rx + ", " + this.cpp[n].rx + ") ");
                ++n;
            }
        }
    }

    void set_control_point(double d, double d2, double d3, double d4, double d5, double d6, double d7, ControlPoint controlPoint) {
        double d8;
        double d9 = 1.0 - d7;
        double d10 = 0.5 * (d5 + d6);
        if (d5 > d6) {
            d8 = Math.sin(d10 - d6);
            d5 = d10 + 1.5707963267948966;
            d6 = d10 - 1.5707963267948966;
        } else {
            d8 = Math.sin(d6 - d10);
            d5 = d10 - 1.5707963267948966;
            d6 = d10 + 1.5707963267948966;
        }
        if (d8 > 0.7071) {
            d8 = 1.4142 - d8;
        }
        controlPoint.lx = d + (d3 *= (d8 *= d9)) * Math.cos(d5);
        controlPoint.ly = d2 - d3 * Math.sin(d5);
        controlPoint.rx = d + (d4 *= d8) * Math.cos(d6);
        controlPoint.ry = d2 - d4 * Math.sin(d6);
    }

    public void rebuild() {
        if (this.wcp.length >= 3) {
            Point[] pointArray = pp;
            synchronized (pointArray) {
                this.create_wcp1();
                this.create_control_points();
                this.compute_control_points();
                this.build_PP();
                this.wcp_spline = new Point[this.ii];
                int n = 0;
                while (n < this.ii) {
                    this.wcp_spline[n] = pp[n];
                    ++n;
                }
            }
        } else if (this.wcp.length == 2) {
            this.wcp_spline = new Point[2];
            this.wcp_spline[0] = this.wcp[0];
            this.wcp_spline[1] = this.wcp[1];
        } else {
            this.wcp_spline = new Point[]{this.wcp[0]};
        }
        this.update_bbox();
        this.renderer.rebuild();
    }

    public FigObject copy() {
        if (this.debug) {
            System.out.println("FigBezier.copy()...");
        }
        FigBezier figBezier = new FigBezier(this.wcp[0].x, this.wcp[0].y, this.is_closed, this.attribs.getClone(), this.trafo);
        figBezier.setPoints(this.getPoints());
        return figBezier;
    }

    public FigBezier(int n, int n2, boolean bl, FigAttribs figAttribs, FigTrafo2D figTrafo2D) {
        super(n, n2, bl, figAttribs, figTrafo2D);
        this.T = 0.45;
        this._1dSQR2 = 0.7071;
        this._SQR2 = 1.4142;
        this.M_PI_2 = 1.5707963267948966;
        this.min_num_points = bl ? 3 : 2;
    }

    public class ControlPoint {
        public double lx;
        public double ly;
        public double rx;
        public double ry;

        public String toString() {
            String string = "ControlPoint( " + this.lx + ", " + this.ly + ", " + this.rx + ", " + this.ry + ") ";
            return string;
        }

        ControlPoint() {
        }

        ControlPoint(double d, double d2, double d3, double d4) {
            this.lx = d;
            this.ly = d2;
            this.rx = d3;
            this.ry = d4;
        }
    }
}

