/*
 * Decompiled with CFR 0.152.
 */
package jfig.objects;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import jfig.canvas.FigTrafo2D;
import jfig.objects.FigArrow;
import jfig.objects.FigAttribs;
import jfig.objects.FigRenderer;
import jfig.objects.FigXSpline;
import jfig.objects.FillWrapper;
import jfig.objects.LineWrapper;

public class AWTXSplineRenderer
implements FigRenderer {
    FigXSpline spline;
    LineWrapper wline;
    FillWrapper wfill;
    FigArrow b_arrow;
    FigArrow f_arrow;
    long timestamp;

    public void rebuild() {
        int n;
        FigTrafo2D figTrafo2D = this.spline.getTrafo();
        FigAttribs figAttribs = this.spline.getAttributes();
        Point[] pointArray = this.spline.getSplinePoints();
        if (pointArray == null) {
            return;
        }
        boolean bl = this.spline.isClosed();
        this.wline = new LineWrapper(this.spline, figTrafo2D, pointArray, bl);
        this.wfill = figAttribs.fillStyle == 2 && pointArray.length >= 3 ? new FillWrapper(this.spline, figTrafo2D, pointArray) : null;
        this.b_arrow = null;
        this.f_arrow = null;
        if (pointArray.length < 2) {
            return;
        }
        if ((figAttribs.arrowMode & 2) > 0) {
            n = Math.min(4, pointArray.length - 1);
            this.b_arrow = FigArrow.create(this.spline, pointArray[n], pointArray[0], false);
        }
        if ((figAttribs.arrowMode & 1) > 0) {
            n = Math.max(pointArray.length - 4, 0);
            this.f_arrow = FigArrow.create(this.spline, pointArray[n], pointArray[pointArray.length - 1], true);
        }
        this.timestamp = System.currentTimeMillis();
    }

    public void paint(Graphics graphics) {
        this.paint(graphics, this.spline.getTrafo());
    }

    public void paint(Graphics graphics, FigTrafo2D figTrafo2D) {
        int n;
        int n2;
        int n3;
        if (!this.spline.isVisible()) {
            return;
        }
        if (this.timestamp < figTrafo2D.getTimestamp()) {
            this.rebuild();
        }
        if (this.wfill != null) {
            this.wfill.paint(graphics);
        }
        if (this.wline != null) {
            this.wline.paint(graphics);
        }
        if (this.b_arrow != null) {
            this.b_arrow.paint(graphics);
        }
        if (this.f_arrow != null) {
            this.f_arrow.paint(graphics);
        }
        Point[] pointArray = this.spline.getPoints();
        if (this.spline.isShowPoints()) {
            n3 = 0;
            while (n3 < pointArray.length) {
                n2 = figTrafo2D.wc_to_screen_x(pointArray[n3].x);
                n = figTrafo2D.wc_to_screen_y(pointArray[n3].y);
                graphics.setColor(Color.black);
                graphics.drawRect(n2 - 2, n - 2, 4, 4);
                graphics.setColor(Color.white);
                graphics.fillRect(n2 - 1, n - 1, 3, 3);
                ++n3;
            }
        }
        if (this.spline.isSelected()) {
            n3 = 0;
            while (n3 < pointArray.length) {
                n2 = figTrafo2D.wc_to_screen_x(pointArray[n3].x);
                n = figTrafo2D.wc_to_screen_y(pointArray[n3].y);
                graphics.setColor(Color.black);
                graphics.fillRect(n2 - 2, n - 2, 5, 5);
                graphics.setColor(Color.white);
                graphics.drawRect(n2 - 3, n - 3, 6, 6);
                ++n3;
            }
        }
    }

    public AWTXSplineRenderer(FigXSpline figXSpline) {
        this.spline = figXSpline;
        this.rebuild();
    }
}

