/*
 * Decompiled with CFR 0.152.
 */
package jfig.objects;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import jfig.canvas.FigTrafo2D;
import jfig.gui.FontCache;
import jfig.objects.FigAttribs;
import jfig.objects.FigRenderer;
import jfig.objects.FigText;
import jfig.utils.SetupManager;

public class AWTTextRenderer
implements FigRenderer {
    private FigText textObject;
    private FontCache fontCache;
    private boolean showBoundingBoxes;

    public void rebuild() {
    }

    public void paint(Graphics graphics) {
        this.paint(graphics, this.textObject.getTrafo());
    }

    public void paint(Graphics graphics, FigTrafo2D figTrafo2D) {
        try {
            if (!this.textObject.isVisible()) {
                return;
            }
            Point point = this.textObject.getPosition();
            FigAttribs figAttribs = this.textObject.getAttributes();
            String string = this.textObject.getText();
            if (string == null) {
                return;
            }
            if (figAttribs.fig_font == 32) {
                string = FigText.symbol_recode(string);
            }
            int n = (int)((double)figAttribs.fontSize * figTrafo2D.getZoom());
            Font font = this.fontCache.getFont(figAttribs.fig_font, n);
            FontMetrics fontMetrics = this.fontCache.getFontMetrics(figAttribs.fig_font, n);
            int n2 = fontMetrics.stringWidth(string);
            int n3 = fontMetrics.getAscent();
            int n4 = fontMetrics.getDescent();
            int n5 = figTrafo2D.wc_to_screen_x(point.x);
            int n6 = figTrafo2D.wc_to_screen_y(point.y);
            int n7 = 0;
            if (figAttribs.textAlign == 2) {
                n7 = n2 / 2;
            }
            if (figAttribs.textAlign == 3) {
                n7 = n2;
            }
            if (this.showBoundingBoxes) {
                graphics.setColor(Color.yellow);
                graphics.drawLine(n5 - n7, n6, n5 - n7 + n2, n6);
                graphics.drawRect(n5 - n7, n6 - n3, n2, n3 + n4);
            }
            graphics.setColor(figAttribs.lineColor);
            graphics.setFont(font);
            graphics.drawString(string, n5 - n7, n6);
            if (string != null && this.textObject.isShowCursor()) {
                String string2 = string.substring(0, this.textObject.getTextCursorIndex());
                int n8 = fontMetrics.stringWidth(string2);
                int n9 = fontMetrics.getAscent();
                graphics.setColor(Color.blue);
                graphics.drawLine(n5 - n7 + n8, n6, n5 - n7 + n8, n6 - n9);
            }
            if (this.textObject.isShowPoints()) {
                int n10 = fontMetrics.getAscent();
                this.showOnePoint(graphics, n5, n6, false);
                this.showOnePoint(graphics, n5, n6 - n10, false);
            }
            if (this.textObject.isSelected()) {
                int n11 = fontMetrics.getAscent();
                this.showOnePoint(graphics, n5, n6, true);
                this.showOnePoint(graphics, n5, n6 - n11, true);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private void showOnePoint(Graphics graphics, int n, int n2, boolean bl) {
        Color color = bl ? Color.white : Color.black;
        Color color2 = bl ? Color.black : Color.white;
        graphics.setColor(color);
        graphics.drawRect(n - 2, n2 - 2, 4, 4);
        graphics.setColor(color2);
        graphics.fillRect(n - 1, n2 - 1, 3, 3);
    }

    public AWTTextRenderer(FigText figText) {
        this.textObject = figText;
        this.fontCache = FontCache.getFontCache();
        this.showBoundingBoxes = SetupManager.getBoolean("jfig.objects.FigText.showBoundingBoxes", false);
        this.rebuild();
    }
}

