/*
 * Decompiled with CFR 0.152.
 */
package jfig.objects;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import jfig.canvas.FigTrafo2D;
import jfig.objects.FigAttribs;
import jfig.objects.FigBbox;
import jfig.objects.FigImage;
import jfig.objects.FigRenderer;
import jfig.objects.LineWrapper;

public class AWTImageRenderer
implements FigRenderer {
    protected FigImage imageObject;
    protected LineWrapper wline;
    protected long timestamp = 0L;

    public void rebuild() {
        FigBbox figBbox = this.imageObject.getBbox();
        FigTrafo2D figTrafo2D = this.imageObject.getTrafo();
        Point[] pointArray = new Point[]{new Point(figBbox.getXl(), figBbox.getYt()), new Point(figBbox.getXr(), figBbox.getYt()), new Point(figBbox.getXr(), figBbox.getYb()), new Point(figBbox.getXl(), figBbox.getYb())};
        this.wline = new LineWrapper(this.imageObject, figTrafo2D, pointArray, true);
        this.timestamp = System.currentTimeMillis();
    }

    public void paint(Graphics graphics) {
        this.paint(graphics, this.imageObject.getTrafo());
    }

    public void paint(Graphics graphics, FigTrafo2D figTrafo2D) {
        if (!this.imageObject.isVisible()) {
            return;
        }
        if (this.timestamp < figTrafo2D.getTimestamp()) {
            this.rebuild();
        }
        FigBbox figBbox = this.imageObject.getBbox();
        FigAttribs figAttribs = this.imageObject.getAttributes();
        Image image = this.imageObject.getImage();
        FigImage figImage = this.imageObject;
        if (this.wline != null && figAttribs.lineColor != null) {
            graphics.setColor(figAttribs.lineColor);
            this.wline.paint(graphics);
        }
        int n = figTrafo2D.wc_to_screen_x(figBbox.getXl());
        int n2 = figTrafo2D.wc_to_screen_y(figBbox.getYt());
        int n3 = figTrafo2D.wc_to_screen_x(figBbox.getXr());
        int n4 = figTrafo2D.wc_to_screen_y(figBbox.getYb());
        if (image != null) {
            try {
                graphics.drawImage(image, n, n2, n3 + 1, n4 + 1, 0, 0, image.getWidth(figImage), image.getHeight(figImage), figImage);
            }
            catch (RuntimeException runtimeException) {
                System.err.println("-E- internal in FigImageRenderer: " + runtimeException);
            }
        } else {
            graphics.setColor(Color.black);
            graphics.setFont(FigAttribs.defaultFont);
            graphics.drawString("image not ready", n + 10, n2 + (n4 - n2) / 2);
            graphics.drawString("or not found", n + 10, n2 + (n4 - n2) / 2 + 20);
        }
        if (this.imageObject.isShowPoints()) {
            graphics.setColor(Color.black);
            graphics.drawRect(n - 2, n2 - 2, 4, 4);
            graphics.drawRect(n3 - 2, n2 - 2, 4, 4);
            graphics.drawRect(n - 2, n4 - 2, 4, 4);
            graphics.drawRect(n3 - 2, n4 - 2, 4, 4);
            graphics.setColor(Color.white);
            graphics.fillRect(n - 1, n2 - 1, 3, 3);
            graphics.fillRect(n3 - 1, n2 - 1, 3, 3);
            graphics.fillRect(n - 1, n4 - 1, 3, 3);
            graphics.fillRect(n3 - 1, n4 - 1, 3, 3);
            graphics.setColor(Color.black);
        }
        if (this.imageObject.isSelected()) {
            graphics.setColor(Color.black);
            graphics.fillRect(n - 1, n2 - 1, 3, 3);
            graphics.fillRect(n3 - 1, n2 - 1, 3, 3);
            graphics.fillRect(n - 1, n4 - 1, 3, 3);
            graphics.fillRect(n3 - 1, n4 - 1, 3, 3);
            graphics.setColor(Color.white);
            graphics.drawRect(n - 2, n2 - 2, 4, 4);
            graphics.drawRect(n3 - 2, n2 - 2, 4, 4);
            graphics.drawRect(n - 2, n4 - 2, 4, 4);
            graphics.drawRect(n3 - 2, n4 - 2, 4, 4);
        }
    }

    public AWTImageRenderer(FigImage figImage) {
        this.imageObject = figImage;
    }
}

