/*
 * Decompiled with CFR 0.152.
 */
package jfig.java2d;

import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import jfig.canvas.FigTrafo2D;
import jfig.java2d.FigTools2D;
import jfig.objects.FigAttribs;
import jfig.objects.FigBbox;
import jfig.objects.FigRectangle;
import jfig.objects.FigRenderer;
import jfig.objects.FillPatterns;

public class FigRectangleRenderer
implements FigRenderer {
    FigRectangle rectangle;
    Shape rect2D;
    BasicStroke stroke;
    AffineTransform cachedAffineTransform;

    public void rebuild() {
        this.createRectangle();
        this.stroke = FigTools2D.createStroke(this.rectangle.getAttributes());
    }

    public void createRectangle() {
        FigAttribs figAttribs = this.rectangle.getAttributes();
        FigBbox figBbox = this.rectangle.getBbox();
        if (figAttribs.cornerRadius > 0) {
            float f = 2.0f * (float)figAttribs.cornerRadius;
            this.rect2D = new RoundRectangle2D.Float(figBbox.getXl(), figBbox.getYt(), figBbox.getXr() - figBbox.getXl(), figBbox.getYb() - figBbox.getYt(), f, f);
        } else {
            this.rect2D = new Rectangle2D.Float(figBbox.getXl(), figBbox.getYt(), figBbox.getXr() - figBbox.getXl(), figBbox.getYb() - figBbox.getYt());
        }
    }

    public void paint(Graphics graphics) {
        this.paint(graphics, this.rectangle.getTrafo());
    }

    public void paint(Graphics graphics, FigTrafo2D figTrafo2D) {
        if (!this.rectangle.isVisible()) {
            return;
        }
        try {
            boolean bl = false;
            Graphics2D graphics2D = (Graphics2D)graphics;
            FigAttribs figAttribs = this.rectangle.getAttributes();
            AffineTransform affineTransform = graphics2D.getTransform();
            Stroke stroke = graphics2D.getStroke();
            if (this.cachedAffineTransform != affineTransform) {
                this.cachedAffineTransform = FigTools2D.createCompoundTransform(affineTransform, figTrafo2D);
                graphics2D.setTransform(this.cachedAffineTransform);
                bl = true;
            }
            if (figAttribs.fig_area_fill > 40) {
                graphics2D.setPaint(FillPatterns.getTexturePaint(figAttribs.fig_area_fill - 40 + 20, 32, figAttribs.lineColor, figAttribs.fillColor));
                graphics2D.fill(this.rect2D);
            } else if (figAttribs.fillStyle == 2) {
                graphics2D.setColor(figAttribs.fillColor);
                graphics2D.fill(this.rect2D);
            }
            graphics2D.setColor(figAttribs.lineColor);
            if (this.stroke != null) {
                graphics2D.setStroke(this.stroke);
            }
            if ((double)this.stroke.getLineWidth() > 0.0) {
                graphics2D.draw(this.rect2D);
            }
            graphics2D.setTransform(affineTransform);
            graphics2D.setStroke(stroke);
            FigBbox figBbox = this.rectangle.getBbox();
            if (this.rectangle.isShowPoints()) {
                FigTools2D.showPoints(graphics, figTrafo2D, figBbox);
            }
            if (this.rectangle.isSelected()) {
                FigTools2D.showSelected(graphics, figTrafo2D, figBbox);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public FigRectangleRenderer(FigRectangle figRectangle) {
        this.rectangle = figRectangle;
        this.rebuild();
    }
}

