/*
 * Decompiled with CFR 0.152.
 */
package jfig.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JFrame;
import jfig.gui.ImageHelper;
import jfig.gui.StatusMessage;
import jfig.utils.SetupManager;

public class JUpdateModeButton
extends JComponent
implements MouseListener {
    public static boolean debug = false;
    Component parent;
    Image passive;
    Image active;
    int width;
    int height;
    boolean state;
    boolean mouseIsDown;
    boolean mouseInside;
    String label;
    StatusMessage helper;
    String helpMessage;
    ActionListener actionListener = null;

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = actionListener;
    }

    public boolean get_state() {
        return this.state;
    }

    public boolean isSelected() {
        return this.state;
    }

    public String getLabel() {
        return this.label;
    }

    public void setStatusMessage(StatusMessage statusMessage) {
        this.helper = statusMessage;
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.width, this.height);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.width, this.height);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.helper != null) {
            this.helper.pushStatusMessage(this.helpMessage);
        }
        this.mouseInside = true;
        this.repaint();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.helper != null) {
            this.helper.popStatusMessage();
        }
        this.mouseInside = false;
        this.repaint();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (debug && this.helper != null) {
            this.helper.setStatusMessage("JUpdateModeButton:mousePressed()");
        }
        this.mouseIsDown = true;
        this.repaint();
        this.createActionEvent(3 * mouseEvent.getX() / this.width);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.mouseIsDown = false;
        this.repaint();
    }

    public void createActionEvent(int n) {
        String string = "Invalid Mode" + n;
        switch (n) {
            case 0: {
                string = "UpdateNone";
                break;
            }
            case 1: {
                string = "UpdateAll";
                break;
            }
            case 2: {
                string = "UpdateInvert";
                break;
            }
        }
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, string));
        }
    }

    public void paint(Graphics graphics) {
        graphics.setColor(this.getBackground());
        if (this.state || this.mouseIsDown) {
            graphics.draw3DRect(0, 0, this.width - 1, this.height - 1, false);
            if (this.active != null) {
                graphics.drawImage(this.active, 1, 1, this.width - 1, this.height - 1, 0, 0, this.width - 2, this.height - 2, this.getBackground(), null);
            } else {
                graphics.setColor(Color.red);
                graphics.drawString(this.label, 3, this.height - 4);
            }
        } else if (this.mouseInside) {
            graphics.draw3DRect(0, 0, this.width - 1, this.height - 1, true);
            if (this.passive != null) {
                graphics.drawImage(this.passive, 1, 1, this.width - 1, this.height - 1, 0, 0, this.width - 2, this.height - 2, this.getBackground(), null);
            } else {
                graphics.setColor(Color.red);
                graphics.drawString(this.label, 3, this.height - 4);
            }
        } else {
            graphics.setColor(this.getBackground());
            graphics.drawRect(0, 0, this.width - 1, this.height - 1);
            if (this.passive != null) {
                graphics.drawImage(this.passive, 1, 1, this.width - 1, this.height - 1, 0, 0, this.width - 2, this.height - 2, this.getBackground(), null);
            } else {
                graphics.setColor(Color.red);
                graphics.drawString(this.label, 3, this.height - 4);
            }
        }
    }

    public void select() {
        this.state = true;
        this.repaint();
    }

    public void deselect() {
        this.state = false;
        this.repaint();
    }

    public String toString() {
        String string = "JUpdateModeButton" + this.label;
        return string;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("JUpdateModeButton demo");
        JUpdateModeButton jUpdateModeButton = new JUpdateModeButton(jFrame, "update mode", null, "Select update mode");
        jFrame.getContentPane().add("North", jUpdateModeButton);
        jFrame.pack();
        jFrame.show();
    }

    public JUpdateModeButton(Component component, String string, StatusMessage statusMessage, String string2) {
        this.parent = component;
        this.label = string;
        this.helper = statusMessage;
        this.helpMessage = string2;
        this.passive = this.active = ImageHelper.loadResourceImage("/jfig/images/updatebutton.gif");
        if (this.passive != null) {
            this.width = this.passive.getWidth(this) + 2;
            this.height = this.passive.getHeight(this) + 2;
        } else {
            this.width = 70;
            this.height = 20;
        }
        try {
            Color color = SetupManager.getColor("jfig.gui.JUpdateModeButton.BackgroundColor", null);
            if (color != null) {
                this.setBackground(color);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.state = false;
        this.mouseIsDown = false;
        this.mouseInside = false;
        this.setSize(new Dimension(this.width, this.height));
        this.addMouseListener(this);
        this.setToolTipText("Select update mode (none, all, invert)");
    }
}

