/*
 * Decompiled with CFR 0.152.
 */
package jfig.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import jfig.gui.JWindowCloser;
import jfig.utils.SetupManager;

public class JTextViewerDialog
extends JDialog {
    private JTextArea ta;
    private JButton okButton;
    private int t;
    private Timer enabler;
    private Timer countdown;

    private void getDefaultFonts() {
        String string = SetupManager.getProperty("jfig.gui.JTextViewer.JTextViewerFontName", "");
        int n = SetupManager.getInteger("jfig.gui.JTextViewer.JTextViewerFontSize", 12);
        int n2 = 0;
        if (!"".equals(string)) {
            this.ta.setFont(new Font(string, n2, n));
        }
        string = SetupManager.getProperty("jfig.gui.JTextViewer.ButtonFontName", "");
        n = SetupManager.getInteger("jfig.gui.JTextViewer.ButtonFontSize", 12);
        n2 = 0;
        if (!"".equals(string)) {
            this.okButton.setFont(new Font(string, n2, n));
        }
    }

    public void initialize(String string) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            int n = Integer.parseInt(stringTokenizer.nextToken());
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            int n3 = Integer.parseInt(stringTokenizer.nextToken());
            int n4 = Integer.parseInt(stringTokenizer.nextToken());
            this.show();
            ((Component)this).setLocation(n, n2);
            ((Component)this).setSize(n3, n4);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void setText(String string) {
        this.ta.setText(string);
    }

    public void parseResource(String string) {
        try {
            InputStream inputStream = this.getClass().getResourceAsStream(string);
            this.parse(inputStream);
        }
        catch (Exception exception) {
            this.setText("-E- Could not find or open resource: " + string + "\n" + "Please check your CLASSPATH and Java installation!");
        }
    }

    public void parseFile(String string) {
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            this.parse(fileInputStream);
        }
        catch (Exception exception) {
            this.setText("-E- Could not find or open file: " + string + "\n" + "Please check your CLASSPATH and Java installation!");
        }
    }

    public void parse(InputStream inputStream) throws Exception {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = inputStream.read()) != -1) {
            byteArrayOutputStream.write((byte)n);
        }
        this.setText(byteArrayOutputStream.toString());
    }

    public void setCaretPosition(int n) {
        this.ta.setCaretPosition(n);
    }

    public void setTimeoutToEnableClosing(int n) {
        this.t = n / 1000;
        this.okButton.setEnabled(false);
        JTextViewerDialog jTextViewerDialog = this;
        if (jTextViewerDialog == null) {
            throw null;
        }
        this.countdown = new Timer(1000, new ActionListener(jTextViewerDialog){
            private final /* synthetic */ JTextViewerDialog this$0;

            public void actionPerformed(ActionEvent actionEvent) {
                JTextViewerDialog jTextViewerDialog = this.this$0;
                JTextViewerDialog.access$1(jTextViewerDialog, JTextViewerDialog.access$0(jTextViewerDialog) - 1);
                if (JTextViewerDialog.access$0(this.this$0) > 0) {
                    JTextViewerDialog.access$2(this.this$0).setText("" + JTextViewerDialog.access$0(this.this$0));
                }
            }
            {
                this.this$0 = jTextViewerDialog;
                this.constructor$0(jTextViewerDialog);
            }

            private final void constructor$0(JTextViewerDialog jTextViewerDialog) {
            }
        });
        this.countdown.setDelay(1000);
        this.countdown.start();
        JTextViewerDialog jTextViewerDialog2 = this;
        if (jTextViewerDialog2 == null) {
            throw null;
        }
        this.enabler = new Timer(n, new ActionListener(jTextViewerDialog2){
            private final /* synthetic */ JTextViewerDialog this$0;

            public void actionPerformed(ActionEvent actionEvent) {
                JTextViewerDialog.access$2(this.this$0).setText("OK");
                JTextViewerDialog.access$2(this.this$0).setEnabled(true);
                if (JTextViewerDialog.access$3(this.this$0) != null) {
                    JTextViewerDialog.access$3(this.this$0).stop();
                }
            }
            {
                this.this$0 = jTextViewerDialog;
                this.constructor$0(jTextViewerDialog);
            }

            private final void constructor$0(JTextViewerDialog jTextViewerDialog) {
            }
        });
        this.enabler.setRepeats(false);
        this.enabler.start();
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        JTextViewerDialog jTextViewerDialog = new JTextViewerDialog((Frame)jFrame, 20, 70);
        jTextViewerDialog.setTitle("JTextViewerDialog demo");
        jTextViewerDialog.setModal(true);
        jTextViewerDialog.setTimeoutToEnableClosing(14000);
        jTextViewerDialog.parseResource("/jfig/doc/xfig/FORMAT3.2");
        jTextViewerDialog.setVisible(true);
    }

    static /* synthetic */ int access$0(JTextViewerDialog jTextViewerDialog) {
        return jTextViewerDialog.t;
    }

    static /* synthetic */ void access$1(JTextViewerDialog jTextViewerDialog, int n) {
        jTextViewerDialog.t = n;
    }

    static /* synthetic */ JButton access$2(JTextViewerDialog jTextViewerDialog) {
        return jTextViewerDialog.okButton;
    }

    static /* synthetic */ Timer access$3(JTextViewerDialog jTextViewerDialog) {
        return jTextViewerDialog.countdown;
    }

    public JTextViewerDialog(Frame frame) {
        this(frame, 20, 70);
    }

    public JTextViewerDialog(Frame frame, int n, int n2) {
        super(frame);
        Object object;
        this.ta = new JTextArea(n, n2);
        this.ta.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.ta);
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setViewportBorder(new EmptyBorder(5, 5, 5, 5));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1));
        this.okButton = new JButton("OK");
        jPanel.add(this.okButton);
        this.getDefaultFonts();
        try {
            object = SetupManager.getColor("jfig.gui.Editor.BackgroundColor", null);
            if (object != null) {
                this.setBackground((Color)object);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add("Center", jScrollPane);
        this.getContentPane().add("South", jPanel);
        this.setDefaultCloseOperation(0);
        object = new JWindowCloser(this, false);
        this.okButton.addActionListener((ActionListener)object);
        this.pack();
    }
}

