/*
 * Decompiled with CFR 0.152.
 */
package jfig.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import jfig.gui.JWindowCloser;
import jfig.utils.SetupManager;

public class JTextViewer
extends JFrame {
    private JTextArea ta;
    private JButton okButton;

    private void getDefaultFonts() {
        String string = SetupManager.getProperty("jfig.gui.JTextViewer.JTextViewerFontName", "MonoSpaced");
        int n = SetupManager.getInteger("jfig.gui.JTextViewer.JTextViewerFontSize", 14);
        int n2 = 0;
        if (!"".equals(string)) {
            this.ta.setFont(new Font(string, n2, n));
        }
        string = SetupManager.getProperty("jfig.gui.JTextViewer.ButtonFontName", "");
        n = SetupManager.getInteger("jfig.gui.JTextViewer.ButtonFontSize", 12);
        n2 = 0;
        if (!"".equals(string)) {
            this.okButton.setFont(new Font(string, n2, n));
        }
    }

    public void initialize(String string) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            int n = Integer.parseInt(stringTokenizer.nextToken());
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            int n3 = Integer.parseInt(stringTokenizer.nextToken());
            int n4 = Integer.parseInt(stringTokenizer.nextToken());
            this.show();
            ((Component)this).setLocation(n, n2);
            ((Component)this).setSize(n3, n4);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void setText(String string) {
        this.ta.setText(string);
    }

    public void parseResource(String string) {
        try {
            InputStream inputStream = this.getClass().getResourceAsStream(string);
            this.parse(inputStream);
        }
        catch (Exception exception) {
            this.setText("-E- Could not find or open resource: " + string + "\n" + "Please check your CLASSPATH and Java installation!");
        }
    }

    public void parseFile(String string) {
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            this.parse(fileInputStream);
        }
        catch (Exception exception) {
            this.setText("-E- Could not find or open file: " + string + "\n" + "Please check your CLASSPATH and Java installation!");
        }
    }

    public void parse(InputStream inputStream) throws Exception {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = inputStream.read()) != -1) {
            byteArrayOutputStream.write((byte)n);
        }
        this.setText(byteArrayOutputStream.toString());
    }

    public void setCaretPosition(int n) {
        this.ta.setCaretPosition(n);
    }

    public static void main(String[] stringArray) {
        JTextViewer jTextViewer = new JTextViewer("Resource", 20, 70);
        jTextViewer.parseResource("/jfig/doc/xfig/FORMAT3.2");
        jTextViewer.setVisible(true);
    }

    public JTextViewer() {
        this("jfig text viewer", 20, 70);
    }

    public JTextViewer(String string) {
        this(string, 20, 70);
    }

    public JTextViewer(String string, int n, int n2) {
        Object object;
        this.setTitle(string);
        this.ta = new JTextArea(n, n2);
        this.ta.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.ta);
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setViewportBorder(new EmptyBorder(5, 5, 5, 5));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1));
        this.okButton = new JButton("OK");
        jPanel.add(this.okButton);
        this.getDefaultFonts();
        try {
            object = SetupManager.getColor("jfig.gui.Editor.BackgroundColor", null);
            if (object != null) {
                this.setBackground((Color)object);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add("Center", jScrollPane);
        this.getContentPane().add("South", jPanel);
        object = new JWindowCloser(this, false);
        this.addWindowListener((WindowListener)object);
        this.okButton.addActionListener((ActionListener)object);
        this.pack();
    }
}

