/*
 * Decompiled with CFR 0.152.
 */
package jfig.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jfig.gui.JImageButton;
import jfig.gui.JStateButtonMouseWheelHandler;
import jfig.gui.StatusMessage;
import jfig.utils.MouseMapper;
import jfig.utils.SetupManager;

public class JStateButton
extends JPanel
implements MouseListener {
    public static boolean debug = false;
    public static final int UPDATE_RECT_SIZE = 5;
    protected String label;
    protected Image[] images;
    protected Object[] objs;
    protected Component parent;
    protected int width;
    protected int height;
    protected int img_width;
    protected int img_height;
    protected int state;
    protected boolean updateMode = false;
    protected boolean updateStatus = false;
    protected boolean mouseInside = false;
    protected StatusMessage helper;
    protected String helpMessage;
    protected String ttt;
    protected ActionListener actionListener = null;
    protected SelectDialog sd = null;

    public void calculateSize() {
        if (this.images != null && this.images[0] != null) {
            this.img_width = this.images[0].getWidth(this);
            this.img_height = this.images[0].getHeight(this);
            this.width = this.img_width + 2 + 5 + 1;
            this.height = this.img_height + 2;
            this.setSize(new Dimension(this.width, this.height));
        }
    }

    public void checkCreateMouseWheelHandler() {
        boolean bl = SetupManager.getBoolean("jfig.gui.Editor.EnableMouseWheelSupport", true);
        if (!bl) {
            return;
        }
        try {
            Class<?> clazz = Class.forName("java.awt.event.MouseWheelEvent");
            JStateButtonMouseWheelHandler jStateButtonMouseWheelHandler = new JStateButtonMouseWheelHandler(this);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = actionListener;
    }

    public void createActionEvent() {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, this.label));
        }
    }

    public String getLabel() {
        return this.label;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int n) {
        this.state = n;
        if (this.state < 0) {
            this.state = 0;
        }
        if (this.images == null) {
            this.state = 0;
        } else if (this.state >= this.images.length) {
            this.state = this.images.length - 1;
        }
        this.repaint();
    }

    public void setUpdateMode(boolean bl) {
        this.updateMode = bl;
        this.repaint();
    }

    public boolean getUpdateMode() {
        return this.updateMode;
    }

    public void setUpdateStatus(boolean bl) {
        this.updateStatus = bl;
        this.repaint();
    }

    public boolean getUpdateStatus() {
        return this.updateStatus;
    }

    public Dialog getDialog() {
        return this.sd;
    }

    public Point getToolTipLocation(MouseEvent mouseEvent) {
        return new Point(15, -20);
    }

    public Object getObject() {
        return this.objs[this.state];
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.width, this.height);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.width, this.height);
    }

    public void setBackgroundColor(Color color) {
        this.setBackground(color);
        this.repaint();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.helper != null) {
            this.helper.pushStatusMessage(this.helpMessage + "    [L: select M: prev R: next]");
        }
        this.mouseInside = true;
        this.repaint();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.helper != null) {
            this.helper.popStatusMessage();
        }
        this.mouseInside = false;
        this.repaint();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (debug) {
            this.helper.setStatusMessage("JStateButton:mousePressed()state[" + this.state + "]");
        }
        if (MouseMapper.isMiddleClick(mouseEvent)) {
            --this.state;
            if (this.state < 0) {
                this.state = this.images.length - 1;
            }
            this.createActionEvent();
            this.repaint();
        } else if (MouseMapper.isRightClick(mouseEvent)) {
            ++this.state;
            if (this.state >= this.images.length) {
                this.state = 0;
            }
            this.createActionEvent();
            this.repaint();
        } else if (this.updateMode && mouseEvent.getX() <= 7) {
            this.updateStatus = !this.updateStatus;
            this.repaint();
        } else {
            if (this.sd == null) {
                JStateButton jStateButton = this;
                if (jStateButton == null) {
                    throw null;
                }
                this.sd = jStateButton.new SelectDialog(this.findParentFrame());
                this.sd.pack();
                this.sd.setModal(true);
            }
            this.sd.setLocation(Math.max(0, this.getLocationOnScreen().x - 50), Math.max(0, this.getLocationOnScreen().y - this.sd.getBounds().height));
            this.disableToolTip();
            this.sd.setVisible(true);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.repaint();
    }

    public void disableToolTip() {
        this.ttt = this.getToolTipText();
        this.setToolTipText(null);
    }

    public void reEnableToolTip() {
        this.setToolTipText(this.ttt);
    }

    public void paintOLD(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        graphics.setColor(this.getBackground());
        if (this.mouseInside) {
            graphics.draw3DRect(0, 0, this.width - 1, this.height - 1, true);
        } else {
            graphics.drawRect(0, 0, this.width - 1, this.height - 1);
        }
        int n = 5;
        graphics.drawImage(this.images[this.state], n + 2, 1, this.img_width + n + 2, this.img_height + 1, 0, 0, this.img_width, this.img_height, this);
        if (this.updateMode) {
            if (this.updateStatus) {
                graphics.setColor(this.getBackground());
                graphics.fillRect(1, 1, n + 1, this.height - 2);
                graphics.setColor(Color.black);
                graphics.fillRect(1, 1, n + 1, n + 1);
            } else {
                graphics.setColor(this.getBackground());
                graphics.fillRect(1, 1, n + 1, this.height - 2);
                graphics.setColor(Color.black);
                graphics.drawRect(1, 1, n, n);
            }
        } else {
            graphics.setColor(this.getBackground());
            graphics.fillRect(1, 1, n + 1, this.height - 2);
        }
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (graphics == null) {
            return;
        }
        graphics.setColor(this.getBackground());
        int n = 5;
        if (this.mouseInside) {
            graphics.draw3DRect(n + 1, 0, this.width - n - 2, this.height - 1, true);
        } else {
            graphics.drawRect(n + 1, 0, this.width - n - 2, this.height - 1);
        }
        graphics.drawImage(this.images[this.state], n + 2, 1, this.img_width + n + 2, this.img_height + 1, 0, 0, this.img_width, this.img_height, this.getBackground(), this);
        if (this.updateMode) {
            if (this.updateStatus) {
                graphics.setColor(this.getBackground());
                graphics.fillRect(0, 0, n + 1, this.height);
                graphics.setColor(Color.black);
                graphics.fillRect(0, 0, n + 1, n + 1);
            } else {
                graphics.setColor(this.getBackground());
                graphics.fillRect(0, 0, n + 1, this.height);
                graphics.setColor(Color.black);
                graphics.drawRect(0, 0, n, n);
            }
        } else {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, n + 1, this.height);
        }
    }

    public String toString() {
        return "JStateButton";
    }

    public Frame findParentFrame() {
        Container container = this;
        do {
            if ((container = container.getParent()) == null || !(container instanceof Frame)) continue;
            return (Frame)container;
        } while (container != null);
        System.out.println("JStateButton.findParentFrame: NO FRAME FOUND!");
        return new Frame("dummy frame");
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("JStateButton selftest");
        jFrame.setVisible(true);
        Object[] objectArray = new Image[4];
        int n = 0;
        while (n < objectArray.length) {
            objectArray[n] = jFrame.createImage(50, 50);
            System.out.println("-#- (debug) " + n + " " + objectArray[n]);
            ++n;
        }
        Color[] colorArray = new Color[]{Color.red, Color.blue, Color.green, Color.orange};
        JStateButton jStateButton = new JStateButton(jFrame, "Demo button", (Image[])objectArray, objectArray);
        jStateButton.setToolTipText("No tooltip yet");
        jFrame.getContentPane().add("North", new JLabel("Swing is slow"));
        jFrame.getContentPane().add("Center", jStateButton);
        jFrame.getContentPane().add("South", new JButton("click me"));
        jFrame.pack();
        int n2 = 0;
        while (n2 < objectArray.length) {
            Graphics graphics = ((Image)objectArray[n2]).getGraphics();
            graphics.setColor(colorArray[n2]);
            graphics.fillRect(0, 0, 50, 50);
            graphics.setColor(Color.black);
            graphics.drawString("" + n2, 3, 17);
            ++n2;
        }
    }

    public JStateButton(Component component, String string, Image[] imageArray, Object[] objectArray) {
        this.label = string;
        this.images = imageArray;
        this.objs = objectArray;
        this.parent = component;
        this.calculateSize();
        this.state = 0;
        this.addMouseListener(this);
        this.checkCreateMouseWheelHandler();
        try {
            Color color = SetupManager.getColor("jfig.gui.Editor.BackgroundColor", null);
            if (color != null) {
                this.setBackground(color);
            }
        }
        catch (Throwable throwable) {
            System.err.println("-E- StateButton<init>: could not set background color:" + throwable);
        }
        this.mouseInside = false;
        this.setToolTipText(string + " [L: select M: prev R: next]");
    }

    public JStateButton(Component component, String string, Image[] imageArray, Object[] objectArray, StatusMessage statusMessage, String string2) {
        this(component, string, imageArray, objectArray);
        this.helper = statusMessage;
        this.helpMessage = string2;
        this.setToolTipText(string2 + " [L: select M: prev R: next]");
    }

    public JStateButton(String string, Image[] imageArray, Object[] objectArray, StatusMessage statusMessage, String string2) {
        this(null, string, imageArray, objectArray);
        this.helper = statusMessage;
        this.helpMessage = string2;
        this.setToolTipText(string2 + " [L: select M: prev R: next]");
    }

    class SelectDialog
    extends JDialog
    implements ActionListener {
        private JButton cancelButton = new JButton("Cancel");
        private JPanel ibuttonPanel;
        private JPanel cancelPanel;
        private JImageButton[] iButtons;

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if ("Cancel".equals(string)) {
                this.setVisible(false);
                JStateButton.this.reEnableToolTip();
                JStateButton.this.repaint();
            } else {
                try {
                    JStateButton.this.state = Integer.parseInt(string);
                    this.setVisible(false);
                    JStateButton.this.reEnableToolTip();
                    JStateButton.this.repaint();
                }
                catch (Exception exception) {
                    this.msg("-E- SelectDialog: unknown button arg: " + string);
                }
            }
        }

        public void msg(String string) {
            System.out.println(string);
        }

        public SelectDialog(Frame frame) {
            super(frame, "Select value:");
            this.cancelButton.addActionListener(this);
            this.cancelPanel = new JPanel(new FlowLayout(1));
            this.cancelPanel.add(this.cancelButton);
            this.ibuttonPanel = new JPanel(new FlowLayout(1));
            this.iButtons = new JImageButton[JStateButton.this.images.length];
            int n = 0;
            while (n < JStateButton.this.images.length) {
                this.iButtons[n] = new JImageButton(this, "" + n, null, "no help", JStateButton.this.images[n]);
                this.iButtons[n].addActionListener(this);
                this.ibuttonPanel.add(this.iButtons[n]);
                ++n;
            }
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add("Center", this.ibuttonPanel);
            this.getContentPane().add("South", this.cancelPanel);
            this.pack();
        }
    }
}

