/*
 * Decompiled with CFR 0.152.
 */
package jfig.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import jfig.gui.JConsole;
import jfig.utils.SetupManager;
import jfig.utils.ShellSort;

public class JPropertiesViewer
extends JFrame
implements ActionListener {
    protected Properties properties;
    protected JTextArea textArea;
    protected JButton okButton;
    protected JButton applyButton;
    protected JButton reloadButton;
    protected JButton saveAsUserPropertiesButton;
    protected JButton saveAsWorkingDirPropertiesButton;
    protected JTextField userPropertiesTF;
    protected JTextField workingDirPropertiesTF;

    public String getDefaultPropertiesFileName() {
        return ".jfigrc";
    }

    public void getGUIDefaults() {
        String string = SetupManager.getProperty("jfig.gui.EditDialog.FontName", "MonoSpaced");
        int n = SetupManager.getInteger("jfig.gui.EditDialog.FontSize", 12);
        int n2 = SetupManager.getInteger("jfig.gui.EditDialog.FontStyle", 0);
        Font font = new Font(string, n2, n);
        try {
            Color color = SetupManager.getColor("jfig.gui.EditDialog.BackgroundColor", null);
            if (color != null) {
                this.setBackground(color);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (font != null) {
            this.textArea.setFont(font);
        }
    }

    public void buildGUI() {
        Object object;
        this.textArea = new JTextArea(30, 80);
        this.textArea.setFont(new Font("MonoSpaced", 0, 14));
        this.getGUIDefaults();
        JScrollPane jScrollPane = new JScrollPane(this.textArea);
        jScrollPane.setViewportBorder(new EmptyBorder(5, 5, 5, 5));
        this.okButton = new JButton("OK");
        this.applyButton = new JButton("Apply");
        this.reloadButton = new JButton("Reload");
        String string = this.getDefaultPropertiesFileName();
        this.saveAsUserPropertiesButton = new JButton("Save as <home>/" + string);
        this.saveAsWorkingDirPropertiesButton = new JButton("Save as local " + string);
        String string2 = string;
        String string3 = string;
        try {
            string3 = new File(string).getAbsolutePath();
            object = System.getSecurityManager();
            if (object != null) {
                ((SecurityManager)object).checkPropertyAccess("user.home");
            }
            string2 = System.getProperty("user.home") + File.separatorChar + string;
        }
        catch (SecurityException securityException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.userPropertiesTF = new JTextField(string2, 50);
        this.workingDirPropertiesTF = new JTextField(string3, 50);
        this.userPropertiesTF.setEditable(false);
        this.workingDirPropertiesTF.setEditable(false);
        object = new JPanel();
        ((Container)object).setLayout(new FlowLayout(2));
        ((Container)object).add(this.saveAsUserPropertiesButton);
        ((Container)object).add(this.userPropertiesTF);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2));
        jPanel.add(this.saveAsWorkingDirPropertiesButton);
        jPanel.add(this.workingDirPropertiesTF);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(2));
        jPanel2.add(this.reloadButton);
        jPanel2.add(this.applyButton);
        jPanel2.add(this.okButton);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel3.add("North", (Component)object);
        jPanel3.add("Center", jPanel);
        jPanel3.add("South", jPanel2);
        this.getContentPane().add("Center", jScrollPane);
        this.getContentPane().add("South", jPanel3);
        this.pack();
        this.okButton.addActionListener(this);
        this.applyButton.addActionListener(this);
        this.reloadButton.addActionListener(this);
        this.saveAsUserPropertiesButton.addActionListener(this);
        this.saveAsWorkingDirPropertiesButton.addActionListener(this);
        this.setDefaultCloseOperation(1);
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void showProperties() {
        if (this.properties == null) {
            return;
        }
        String[] stringArray = new String[this.properties.size()];
        Enumeration<?> enumeration = this.properties.propertyNames();
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = (String)enumeration.nextElement();
            ++n;
        }
        ShellSort.shellSort(stringArray);
        StringBuffer stringBuffer = new StringBuffer(10000);
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (!stringArray[n2].equals("line.separator")) {
                stringBuffer.append(this._padding(stringArray[n2], 38));
                stringBuffer.append("  ");
                stringBuffer.append(this.properties.get(stringArray[n2]));
                stringBuffer.append("\n");
            }
            ++n2;
        }
        this.textArea.setText(stringBuffer.toString());
    }

    private String _padding(String string, int n) {
        if (string.length() >= n) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        stringBuffer.append(string);
        int n2 = string.length();
        while (n2 < n) {
            stringBuffer.append(' ');
            ++n2;
        }
        return stringBuffer.toString();
    }

    public String _escapeBackslashes(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            char c = string.charAt(n);
            stringBuffer.append(c);
            if (c == '\\') {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public void doReload() {
        this.showProperties();
    }

    public void doApply() {
        this.err("-I- JPropertiewViewer.doApply: trying to (re-) apply properties");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.getEscapedVisibleText().getBytes());
        try {
            this.properties.load(byteArrayInputStream);
            byteArrayInputStream.close();
        }
        catch (Exception exception) {
            this.err("-E- in writePropertiesFromVisibleText: " + exception);
            exception.printStackTrace();
        }
    }

    public void doOK() {
        this.setVisible(false);
    }

    public void doSaveUserProperties() {
        this.err("-I- Saving user properties...");
        String string = null;
        try {
            string = System.getProperty("user.home") + File.separatorChar + this.getDefaultPropertiesFileName();
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            PrintStream printStream = new PrintStream(fileOutputStream);
            this.writePropertiesFromVisibleText(printStream, "jfig local properties");
            fileOutputStream.close();
        }
        catch (Exception exception) {
            this.err("-E- Failed to save user properties: " + exception);
        }
    }

    public void doSaveWorkingDirProperties() {
        this.err("-I- Saving working dir properties...");
        String string = null;
        try {
            string = new File(this.getDefaultPropertiesFileName()).getAbsolutePath();
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            PrintStream printStream = new PrintStream(fileOutputStream);
            this.writePropertiesFromVisibleText(printStream, "jfig local properties");
            fileOutputStream.close();
        }
        catch (Exception exception) {
            this.err("-E- Failed to save local properties: " + exception);
        }
    }

    public void writeProperties(PrintStream printStream, String string) {
        printStream.println("#" + string);
        String[] stringArray = new String[this.properties.size()];
        Enumeration<?> enumeration = this.properties.propertyNames();
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = (String)enumeration.nextElement();
            ++n;
        }
        ShellSort.shellSort(stringArray);
        n = 0;
        while (n < stringArray.length) {
            if (this.checkShouldWriteProperty(stringArray[n])) {
                printStream.print(this._padding(stringArray[n], 38));
                printStream.print("  ");
                printStream.print(this._escapeBackslashes((String)this.properties.get(stringArray[n])));
                printStream.println();
            }
            ++n;
        }
    }

    public String getEscapedVisibleText() {
        String string = this.textArea.getText();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            char c = string.charAt(n);
            stringBuffer.append(c);
            if (c == '\\') {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public void writePropertiesFromVisibleText(PrintStream printStream, String string) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.getEscapedVisibleText().getBytes());
        Properties properties = new Properties();
        try {
            properties.load(byteArrayInputStream);
            byteArrayInputStream.close();
        }
        catch (Exception exception) {
            this.err("-E- in writePropertiesFromVisibleText: " + exception);
        }
        String[] stringArray = new String[properties.size()];
        Enumeration<?> enumeration = properties.propertyNames();
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = (String)enumeration.nextElement();
            ++n;
        }
        ShellSort.shellSort(stringArray);
        printStream.println("#" + string);
        n = 0;
        while (n < stringArray.length) {
            if (this.checkShouldWriteProperty(stringArray[n])) {
                printStream.print(this._padding(stringArray[n], 38));
                printStream.print("  ");
                printStream.print(this._escapeBackslashes((String)properties.get(stringArray[n])));
                printStream.println();
            }
            ++n;
        }
    }

    public boolean checkShouldWriteProperty(String string) {
        if (string == null) {
            return false;
        }
        return string.startsWith("jfig");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JButton) {
            String string = actionEvent.getActionCommand();
            if (string.equals("OK")) {
                this.doOK();
            } else if (string.equals("Apply")) {
                this.doApply();
            } else if (string.equals("Reload")) {
                this.doReload();
            } else if (actionEvent.getSource() == this.saveAsUserPropertiesButton) {
                this.doSaveUserProperties();
            } else if (actionEvent.getSource() == this.saveAsWorkingDirPropertiesButton) {
                this.doSaveWorkingDirProperties();
            } else {
                this.err("-E- Unknown event source: " + actionEvent);
            }
        }
    }

    public void err(String string) {
        try {
            JConsole jConsole = JConsole.getConsole();
            if (jConsole != null) {
                jConsole.println(string);
            } else {
                System.err.println(string);
            }
        }
        catch (Throwable throwable) {
            System.err.println(string);
        }
    }

    public static void main(String[] stringArray) {
        SetupManager.loadGlobalProperties("jfig/jfig.cnf");
        SetupManager.loadUserProperties("jfig.cnf");
        SetupManager.loadLocalProperties("jfig.cnf");
        JPropertiesViewer jPropertiesViewer = new JPropertiesViewer(SetupManager.getProperties());
        jPropertiesViewer.setTitle("SetupManager properties");
        jPropertiesViewer.showProperties();
        jPropertiesViewer.show();
    }

    public JPropertiesViewer(Properties properties) {
        this.properties = properties;
        this.buildGUI();
    }
}

