/*
 * Decompiled with CFR 0.152.
 */
package jfig.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import jfig.gui.ConsoleMessage;
import jfig.gui.ImageHelper;
import jfig.gui.JImageButton;
import jfig.gui.StatusMessage;
import jfig.utils.SetupManager;

public class JModeButtonPanel
extends JPanel {
    JPanel commandButtonPanel;
    JPanel zoomButtonPanel;
    JImageButton circleButton;
    JImageButton ovalButton;
    JImageButton rectButton;
    JImageButton roundrectButton;
    JImageButton polylineButton;
    JImageButton polygonButton;
    JImageButton splineButton;
    JImageButton csplineButton;
    JImageButton bezierButton;
    JImageButton cbezierButton;
    JImageButton arcButton;
    JImageButton imageButton;
    JImageButton textButton;
    JImageButton linkButton;
    JImageButton libraryObjectButton;
    JImageButton openCompoundButton;
    JImageButton createCompoundButton;
    JImageButton breakCompoundButton;
    JImageButton scaleButton;
    JImageButton alignButton;
    JImageButton movePointButton;
    JImageButton moveButton;
    JImageButton addPointButton;
    JImageButton copyButton;
    JImageButton cutPointButton;
    JImageButton deleteButton;
    JImageButton convertButton;
    JImageButton rotateCWButton;
    JImageButton rotateCCWButton;
    JImageButton updateButton;
    JImageButton editButton;
    JImageButton mirrorXButton;
    JImageButton mirrorYButton;
    JImageButton textSizeButton;
    JImageButton zoomRegionButton;
    JImageButton zoomIn2Button;
    JImageButton zoomOut2Button;
    JImageButton zoom11Button;
    JImageButton panHomeButton;
    Image buttonImages;
    Image[] crop;
    ConsoleMessage printer;
    StatusMessage statusField;
    private JImageButton selectedButton = null;

    public void setConsole(ConsoleMessage consoleMessage) {
        this.printer = consoleMessage;
    }

    public Image[] cropButtonImages() {
        Color color = this.getBackground();
        this.crop = new Image[120];
        int n = 0;
        while (n < 8) {
            int n2 = 0;
            while (n2 < 15) {
                this.crop[n + 8 * n2] = ImageHelper.createImage(20, 20);
                Graphics graphics = this.crop[n + 8 * n2].getGraphics();
                if (this.buttonImages != null) {
                    graphics.drawImage(this.buttonImages, 0, 0, 20, 20, 20 * n, 20 * n2, 20 * n + 20, 20 * n2 + 20, color, null);
                } else {
                    graphics.setColor(Color.black);
                    graphics.drawLine(2, 2, 18, 18);
                    graphics.drawLine(2, 18, 18, 2);
                }
                ++n2;
            }
            ++n;
        }
        return this.crop;
    }

    public void createCommandButtons() {
        this.commandButtonPanel = new JPanel();
        this.commandButtonPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.commandButtonPanel.setLayout(new GridLayout(21, 2, 1, 1));
        this.commandButtonPanel.setBackground(this.getBackground());
        this.circleButton = new JImageButton(this, "Circle", this.statusField, "create a circle", this.crop[40]);
        this.ovalButton = new JImageButton(this, "Ellipse", this.statusField, "create an ellipse", this.crop[41]);
        this.rectButton = new JImageButton(this, "Rectangle", this.statusField, "create a rectangle", this.crop[42]);
        this.roundrectButton = new JImageButton(this, "roundRect", this.statusField, "create a rounded rectangle", this.crop[43]);
        this.polygonButton = new JImageButton(this, "Polygon", this.statusField, "create a polygon", this.crop[49]);
        this.polylineButton = new JImageButton(this, "Polyline", this.statusField, "create a polyline", this.crop[48]);
        this.csplineButton = new JImageButton(this, "c.Spline", this.statusField, "create a (closed) spline", this.crop[51]);
        this.splineButton = new JImageButton(this, "Spline", this.statusField, "create a (open) spline", this.crop[50]);
        this.cbezierButton = new JImageButton(this, "c.Bezier", this.statusField, "create a (closed) Bezier spline", this.crop[53]);
        this.bezierButton = new JImageButton(this, "Bezier", this.statusField, "create an (open) Bezier spline", this.crop[52]);
        this.arcButton = new JImageButton(this, "Arc", this.statusField, "create an arc (defined by three points)", this.crop[46]);
        this.imageButton = new JImageButton(this, "Image", this.statusField, "create an embedded image", this.crop[44]);
        this.textButton = new JImageButton(this, "Text", this.statusField, "create a text object", this.crop[45]);
        this.linkButton = new JImageButton(this, "Link", this.statusField, "create hyper-graphics links | click again to show/hide all links", this.crop[101]);
        this.libraryObjectButton = new JImageButton(this, "Library object", this.statusField, "add library object", this.crop[28]);
        this.openCompoundButton = new JImageButton(this, "Open [@]", this.statusField, "open a compound object", this.crop[117]);
        this.createCompoundButton = new JImageButton(this, "Create [@]", this.statusField, "create a compound object", this.crop[56]);
        this.breakCompoundButton = new JImageButton(this, "Break [@]", this.statusField, "break a compound object", this.crop[57]);
        this.movePointButton = new JImageButton(this, "Move point", this.statusField, "move a polyline point", this.crop[58]);
        this.moveButton = new JImageButton(this, "Move", this.statusField, "move an object", this.crop[59]);
        this.addPointButton = new JImageButton(this, "Add point", this.statusField, "insert a point to a polyline", this.crop[60]);
        this.copyButton = new JImageButton(this, "Copy", this.statusField, "copy an object", this.crop[61]);
        this.cutPointButton = new JImageButton(this, "Cut point", this.statusField, "cut a point from a polyline", this.crop[62]);
        this.deleteButton = new JImageButton(this, "Delete", this.statusField, "delete an object", this.crop[63]);
        this.updateButton = new JImageButton(this, "Update", this.statusField, "update object attributes", this.crop[64]);
        this.editButton = new JImageButton(this, "Edit", this.statusField, "edit object", this.crop[65]);
        this.mirrorYButton = new JImageButton(this, "Mirror Y", this.statusField, "mirror object on y-axis", this.crop[67]);
        this.mirrorXButton = new JImageButton(this, "Mirror X", this.statusField, "mirror object on x-axis", this.crop[66]);
        this.scaleButton = new JImageButton(this, "Scale", this.statusField, "scale object", this.crop[97]);
        this.alignButton = new JImageButton(this, "Align", this.statusField, "align object in compound", this.crop[98]);
        this.convertButton = new JImageButton(this, "Convert", this.statusField, "convert polyline/spline", this.crop[96]);
        this.rotateCWButton = new JImageButton(this, "Rotate CW", this.statusField, "rotate object clockwise", this.crop[118]);
        this.rotateCCWButton = new JImageButton(this, "Rotate CCW", this.statusField, "rotate object counter-clockwise", this.crop[119]);
        this.textSizeButton = new JImageButton(this, "Text size", this.statusField, "change text font size", this.crop[100]);
        this.commandButtonPanel.add(this.circleButton);
        this.commandButtonPanel.add(this.ovalButton);
        this.commandButtonPanel.add(this.csplineButton);
        this.commandButtonPanel.add(this.splineButton);
        this.commandButtonPanel.add(this.cbezierButton);
        this.commandButtonPanel.add(this.bezierButton);
        this.commandButtonPanel.add(this.polygonButton);
        this.commandButtonPanel.add(this.polylineButton);
        this.commandButtonPanel.add(this.rectButton);
        this.commandButtonPanel.add(this.roundrectButton);
        this.commandButtonPanel.add(this.libraryObjectButton);
        this.commandButtonPanel.add(this.arcButton);
        this.commandButtonPanel.add(this.imageButton);
        this.commandButtonPanel.add(this.textButton);
        this.commandButtonPanel.add(new JLabel(""));
        this.commandButtonPanel.add(this.openCompoundButton);
        this.commandButtonPanel.add(this.createCompoundButton);
        this.commandButtonPanel.add(this.breakCompoundButton);
        this.commandButtonPanel.add(this.scaleButton);
        this.commandButtonPanel.add(this.alignButton);
        this.commandButtonPanel.add(this.movePointButton);
        this.commandButtonPanel.add(this.moveButton);
        this.commandButtonPanel.add(this.addPointButton);
        this.commandButtonPanel.add(this.copyButton);
        this.commandButtonPanel.add(this.cutPointButton);
        this.commandButtonPanel.add(this.deleteButton);
        this.commandButtonPanel.add(this.updateButton);
        this.commandButtonPanel.add(this.editButton);
        this.commandButtonPanel.add(this.mirrorYButton);
        this.commandButtonPanel.add(this.mirrorXButton);
        this.commandButtonPanel.add(this.rotateCWButton);
        this.commandButtonPanel.add(this.rotateCCWButton);
        this.commandButtonPanel.add(this.convertButton);
        this.commandButtonPanel.add(this.textSizeButton);
    }

    public void createZoomButtons() {
        this.zoomButtonPanel = new JPanel();
        this.zoomButtonPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.zoomButtonPanel.setLayout(new GridLayout(6, 2, 1, 1));
        this.zoomButtonPanel.setBackground(this.getBackground());
        this.zoomRegionButton = new JImageButton(this, "Zoom Region", this.statusField, "zoom in (select region)", this.crop[84]);
        this.zoomIn2Button = new JImageButton(this, "Zoom In", this.statusField, "zoom in (factor 1.4)", this.crop[80]);
        this.zoomOut2Button = new JImageButton(this, "Zoom Out", this.statusField, "zoom out (factor 0.7)", this.crop[81]);
        this.zoom11Button = new JImageButton(this, "Zoom 1:1", this.statusField, "restore zoom to normal size 1:1", this.crop[68]);
        this.panHomeButton = new JImageButton(this, "Pan home", this.statusField, "pan home to origin (0,0)", this.crop[83]);
        this.commandButtonPanel.add(this.zoomRegionButton);
        this.commandButtonPanel.add(this.zoom11Button);
        this.commandButtonPanel.add(this.zoomIn2Button);
        this.commandButtonPanel.add(this.zoomOut2Button);
    }

    public void addActionListener(ActionListener actionListener) {
        this.ovalButton.addActionListener(actionListener);
        this.circleButton.addActionListener(actionListener);
        this.polygonButton.addActionListener(actionListener);
        this.polylineButton.addActionListener(actionListener);
        this.csplineButton.addActionListener(actionListener);
        this.splineButton.addActionListener(actionListener);
        this.cbezierButton.addActionListener(actionListener);
        this.bezierButton.addActionListener(actionListener);
        this.rectButton.addActionListener(actionListener);
        this.roundrectButton.addActionListener(actionListener);
        this.arcButton.addActionListener(actionListener);
        this.imageButton.addActionListener(actionListener);
        this.textButton.addActionListener(actionListener);
        this.linkButton.addActionListener(actionListener);
        this.libraryObjectButton.addActionListener(actionListener);
        this.openCompoundButton.addActionListener(actionListener);
        this.createCompoundButton.addActionListener(actionListener);
        this.breakCompoundButton.addActionListener(actionListener);
        this.scaleButton.addActionListener(actionListener);
        this.alignButton.addActionListener(actionListener);
        this.movePointButton.addActionListener(actionListener);
        this.moveButton.addActionListener(actionListener);
        this.addPointButton.addActionListener(actionListener);
        this.copyButton.addActionListener(actionListener);
        this.cutPointButton.addActionListener(actionListener);
        this.deleteButton.addActionListener(actionListener);
        this.updateButton.addActionListener(actionListener);
        this.editButton.addActionListener(actionListener);
        this.mirrorYButton.addActionListener(actionListener);
        this.mirrorXButton.addActionListener(actionListener);
        this.convertButton.addActionListener(actionListener);
        this.rotateCWButton.addActionListener(actionListener);
        this.rotateCCWButton.addActionListener(actionListener);
        this.textSizeButton.addActionListener(actionListener);
        if (this.zoomRegionButton != null) {
            this.zoomRegionButton.addActionListener(actionListener);
            this.zoomIn2Button.addActionListener(actionListener);
            this.zoomOut2Button.addActionListener(actionListener);
            this.zoom11Button.addActionListener(actionListener);
            this.panHomeButton.addActionListener(actionListener);
        }
    }

    public void selectModeButton(Object object) {
        JImageButton jImageButton = null;
        try {
            if (object instanceof ActionEvent) {
                jImageButton = (JImageButton)((ActionEvent)object).getSource();
            } else if (object instanceof String) {
                jImageButton = this.findButton((String)object);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.selectedButton != null) {
            this.selectedButton.deselect();
        }
        if (jImageButton != null) {
            this.selectedButton = jImageButton;
            jImageButton.select();
        }
    }

    public JImageButton findButton(String string) {
        JImageButton jImageButton = null;
        Component[] componentArray = this.commandButtonPanel.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] instanceof JImageButton && (jImageButton = (JImageButton)componentArray[n]).getLabel().equals(string)) {
                return jImageButton;
            }
            ++n;
        }
        return null;
    }

    public void setLinkMessage(String string) {
        this.linkButton.setHelpMessage(string);
    }

    public void message(String string) {
        if (this.printer != null) {
            this.printer.consoleMessage(string);
        } else {
            System.out.println(string);
        }
    }

    public static void main(String[] stringArray) {
        System.out.println("jfig.gui.JModeButtonPanel selftest...");
        JFrame jFrame = new JFrame();
        ImageHelper.setVisibleParent(jFrame);
        JModeButtonPanel jModeButtonPanel = new JModeButtonPanel(null);
        jFrame.getContentPane().add("West", jModeButtonPanel);
        jFrame.pack();
        jFrame.setSize(400, 700);
        jFrame.setVisible(true);
    }

    public JModeButtonPanel(StatusMessage statusMessage) {
        this.statusField = statusMessage;
        try {
            Color color = SetupManager.getColor("jfig.gui.Editor.BackgroundColor", null);
            if (color != null) {
                this.setBackground(color);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setLayout(new BorderLayout());
        this.buttonImages = ImageHelper.loadResourceImage("/jfig/images/buttons.gif");
        this.crop = this.cropButtonImages();
        this.createCommandButtons();
        this.createZoomButtons();
        this.add("North", this.commandButtonPanel);
    }
}

