/*
 * Decompiled with CFR 0.152.
 */
package jfig.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import jfig.gui.ImageHelper;
import jfig.gui.StatusMessage;

public class JImageButton
extends JPanel
implements MouseListener {
    public static boolean debug = false;
    Component parent;
    Image passive;
    Image active;
    int width;
    int height;
    boolean state;
    boolean mouseIsDown;
    boolean mouseInside;
    boolean enabled;
    String label;
    StatusMessage helper;
    String helpMessage;
    ActionListener actionListener = null;

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = actionListener;
    }

    public boolean get_state() {
        return this.state;
    }

    public boolean isSelected() {
        return this.state;
    }

    public String getLabel() {
        return this.label;
    }

    public void setStatusMessage(StatusMessage statusMessage) {
        this.helper = statusMessage;
    }

    public void setHelpMessage(String string) {
        this.helpMessage = string;
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.width, this.height);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.width, this.height);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (!this.enabled) {
            return;
        }
        if (this.helper != null) {
            this.helper.pushStatusMessage(this.helpMessage);
        }
        this.mouseInside = true;
        this.repaint();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.enabled && this.helper != null) {
            this.helper.popStatusMessage();
        }
        this.mouseInside = false;
        this.mouseIsDown = false;
        this.repaint();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.enabled) {
            return;
        }
        if (debug && this.helper != null) {
            this.helper.setStatusMessage("JImageButton:mousePressed()");
        }
        this.mouseIsDown = true;
        this.repaint();
        this.createActionEvent();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.mouseIsDown = false;
        this.repaint();
    }

    public void createActionEvent() {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, this.label));
        }
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        graphics.setColor(this.getBackground());
        if (this.state || this.mouseIsDown) {
            graphics.draw3DRect(0, 0, this.width - 1, this.height - 1, false);
            graphics.draw3DRect(1, 1, this.width - 3, this.height - 3, false);
            if (this.active != null) {
                graphics.drawImage(this.active, 2, 2, this.width - 2, this.height - 2, 0, 0, this.width - 4, this.height - 4, this.getBackground(), null);
            } else {
                graphics.setColor(Color.red);
                graphics.drawString(this.label, 3, this.height - 4);
            }
        } else if (this.mouseInside && this.enabled) {
            graphics.draw3DRect(0, 0, this.width - 1, this.height - 1, true);
            graphics.draw3DRect(1, 1, this.width - 3, this.height - 3, true);
            if (this.passive != null) {
                graphics.drawImage(this.passive, 2, 2, this.width - 2, this.height - 2, 0, 0, this.width - 4, this.height - 4, this.getBackground(), null);
            } else {
                graphics.setColor(Color.red);
                graphics.drawString(this.label, 3, this.height - 4);
            }
        } else {
            graphics.setColor(this.getBackground());
            graphics.drawRect(0, 0, this.width - 1, this.height - 1);
            graphics.drawRect(1, 1, this.width - 3, this.height - 3);
            if (this.passive != null) {
                graphics.drawImage(this.passive, 2, 2, this.width - 2, this.height - 2, 0, 0, this.width - 4, this.height - 4, this.getBackground(), null);
            } else {
                graphics.setColor(Color.red);
                graphics.drawString(this.label, 3, this.height - 4);
            }
        }
    }

    public void select() {
        this.state = true;
        this.repaint();
    }

    public void deselect() {
        this.state = false;
        this.repaint();
    }

    public void setActive(boolean bl) {
        this.enabled = bl;
    }

    public String toString() {
        String string = "JImageButton" + this.label;
        return string;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("JStateButton selftest");
        jFrame.setVisible(true);
        Image image = ImageHelper.createImage(50, 30);
        Image image2 = ImageHelper.createImage(50, 30);
        Graphics graphics = image.getGraphics();
        graphics.drawString("passive", 3, 25);
        graphics = image2.getGraphics();
        graphics.drawString("active", 3, 25);
        JImageButton jImageButton = new JImageButton(jFrame, "Demo button", image, image2);
        jImageButton.setToolTipText("Create Polyline");
        jFrame.getContentPane().add("North", new JLabel("Swing is slow"));
        jFrame.getContentPane().add("Center", jImageButton);
        jFrame.getContentPane().add("South", new JButton("click me"));
        jFrame.pack();
    }

    public JImageButton(Component component, String string, Image image, Image image2) {
        this.parent = component;
        this.passive = image;
        this.active = image2;
        this.label = string;
        if (component != null) {
            this.setBackground(component.getBackground());
        }
        if (image != null) {
            this.width = image.getWidth(this) + 4;
            this.height = image.getHeight(this) + 4;
        } else {
            this.width = 20;
            this.height = 20;
        }
        this.state = false;
        this.mouseIsDown = false;
        this.mouseInside = false;
        this.enabled = true;
        this.setSize(new Dimension(this.width, this.height));
        this.addMouseListener(this);
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
    }

    public JImageButton(Component component, String string, StatusMessage statusMessage, String string2, Image image, Image image2) {
        this(component, string, image, image2);
        this.helpMessage = string2;
        this.helper = statusMessage;
        this.setToolTipText(string2);
    }

    public JImageButton(Component component, String string, StatusMessage statusMessage, String string2, Image image) {
        this(component, string, statusMessage, string2, image, image);
    }

    public JImageButton(String string, StatusMessage statusMessage, String string2, Image image) {
        this(null, string, statusMessage, string2, image, image);
    }
}

