/*
 * Decompiled with CFR 0.152.
 */
package jfig.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import jfig.gui.ImageHelper;
import jfig.gui.JImageButton;
import jfig.gui.JStateButton;
import jfig.gui.StatusMessage;
import jfig.utils.MouseMapper;

public class JFontButton
extends JStateButton
implements MouseListener {
    SelectFontDialog selectFontDialog;

    public void loadFontMenuImage() {
        try {
            Image image = ImageHelper.loadResourceImage("/jfig/images/fontmenu.gif");
            this.images = new Image[35];
            int n = 0;
            while (n < this.images.length) {
                this.images[n] = ImageHelper.createImage(220, 20);
                Graphics graphics = this.images[n].getGraphics();
                graphics.setColor(Color.yellow);
                graphics.fillRect(0, 0, 221, 21);
                int n2 = n + 1;
                int n3 = (n2 & 1) * 220;
                int n4 = (n2 >>> 1) * 20;
                if (image != null) {
                    graphics.drawImage(image, 0, 0, 220, 20, n3, n4, n3 + 220, n4 + 20, null);
                }
                ++n;
            }
        }
        catch (Exception exception) {
            System.err.println("-#- internal error: " + exception);
            exception.printStackTrace();
        }
    }

    public Dialog getDialog() {
        return this.selectFontDialog;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (debug) {
            this.helper.setStatusMessage("StateButton:mousePressed()state[" + this.state + "]");
        }
        if (MouseMapper.isMiddleClick(mouseEvent)) {
            --this.state;
            if (this.state < 0) {
                this.state = this.images.length - 1;
            }
            this.createActionEvent();
            this.repaint();
        } else if (MouseMapper.isRightClick(mouseEvent)) {
            ++this.state;
            if (this.state >= this.images.length) {
                this.state = 0;
            }
            this.createActionEvent();
            this.repaint();
        } else if (this.updateMode && mouseEvent.getX() <= 7) {
            this.updateStatus = !this.updateStatus;
            this.repaint();
        } else {
            if (this.selectFontDialog == null) {
                JFontButton jFontButton = this;
                if (jFontButton == null) {
                    throw null;
                }
                this.selectFontDialog = jFontButton.new SelectFontDialog(this.findParentFrame());
            }
            this.selectFontDialog.setModal(true);
            this.selectFontDialog.setLocation(Math.max(0, this.getLocationOnScreen().x - 50), Math.max(0, this.getLocationOnScreen().y - this.selectFontDialog.getBounds().height));
            this.disableToolTip();
            this.selectFontDialog.setVisible(true);
        }
    }

    public String toString() {
        String string = "JFontButton" + this.helpMessage;
        return string;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("JFontButton selftest");
        jFrame.setSize(300, 100);
        jFrame.show();
        JFontButton jFontButton = new JFontButton((Component)jFrame, "Select font", null, "Select font");
        jFrame.getContentPane().add("South", jFontButton);
        jFrame.pack();
        jFrame.show();
    }

    public JFontButton(Component component, String string, StatusMessage statusMessage, String string2) {
        super(component, string, null, null, statusMessage, string2);
        this.loadFontMenuImage();
        this.calculateSize();
        this.state = 0;
        this.setToolTipText("Select font:  [L: select M: prev R: next]");
    }

    class SelectFontDialog
    extends JDialog
    implements ActionListener {
        private JButton cancelButton = new JButton("Cancel");
        private JPanel ibuttonPanel;
        private JPanel cancelPanel;
        private JImageButton[] iButtons;

        public int numberOfColors() {
            return this.iButtons.length;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if ("Cancel".equals(string)) {
                this.setVisible(false);
                JFontButton.this.reEnableToolTip();
                JFontButton.this.repaint();
            } else {
                try {
                    JFontButton.this.state = Integer.parseInt(string);
                    this.setVisible(false);
                    JFontButton.this.reEnableToolTip();
                    JFontButton.this.repaint();
                }
                catch (Exception exception) {
                    System.err.println("-E- SelectDialog: unknown button arg: " + string);
                }
            }
        }

        public SelectFontDialog(Frame frame) {
            super(frame, "Select font:");
            this.cancelButton.addActionListener(this);
            this.cancelPanel = new JPanel(new FlowLayout(1));
            this.cancelPanel.add(this.cancelButton);
            this.ibuttonPanel = new JPanel(new GridLayout(0, 2));
            this.ibuttonPanel.add(new Label(""));
            this.iButtons = new JImageButton[JFontButton.this.images.length];
            int n = 0;
            while (n < JFontButton.this.images.length) {
                this.iButtons[n] = new JImageButton("" + n, null, "no help", JFontButton.this.images[n]);
                this.iButtons[n].addActionListener(this);
                this.ibuttonPanel.add(this.iButtons[n]);
                ++n;
            }
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add("Center", this.ibuttonPanel);
            this.getContentPane().add("South", this.cancelPanel);
            this.pack();
        }
    }
}

