/*
 * Decompiled with CFR 0.152.
 */
package jfig.gui;

import gifencoder.GIFEncoder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import jfig.canvas.FigCanvas;
import jfig.commands.FigBasicEditor;
import jfig.gui.JConsole;
import jfig.gui.JWindowCloser;
import jfig.objects.FigBbox;
import jfig.utils.BoundingBoxCalculator;
import jfig.utils.ExceptionTracer;
import jfig.utils.Format;
import jfig.utils.PPMWriter;
import jfig.utils.SetupManager;

public class JExportOptionsDialog
extends JDialog
implements ActionListener,
ItemListener {
    public final int FULL_COLORS;
    public final int IO_COLORS;
    public final int BLACK_WHITE;
    public final String FULL_COLORS_STRING;
    public final String IO_COLORS_STRING;
    public final String BLACK_WHITE_STRING;
    public final int A4_WIDTH;
    public final int A4_HEIGHT;
    Frame parent;
    JTextField magnificationTF;
    JTextField xoffsetTF;
    JTextField yoffsetTF;
    JComboBox languageChoice;
    JComboBox orientationChoice;
    JComboBox centerChoice;
    JComboBox colorChoice;
    JCheckBox autosaveCB;
    JCheckBox quoteNamesCB;
    JButton exportNowButton;
    JButton cancelButton;
    JButton filenameButton;
    JButton fitToPageButton;
    JTextField filenameTF;
    JTextField directoryTF;
    JTextField fig2devPathTF;
    JTextField commandLineTF;
    JLabel sizeLabel;
    JFileChooser fileChooser;
    JConsole console;
    boolean debug = true;
    boolean autosave = true;
    boolean waitExec = true;
    boolean showColorOptions = false;
    boolean requestAntiAliasing = false;
    String[][] data = new String[][]{{"Postscript", "ps", "doExportPS", "no"}, {"Encapsulated Postscript", "eps", "doExportEPS", "no"}, {"IBM GL", "gl", "doExportIBMGL", "no"}, {"Latex", "latex", "doExportLATEX", "no"}, {"Pictex", "pictex", "doExportPICTEX", "no"}, {"PSTEX", "pstex", "doExportPSTEX", "no"}, {"PPM", "ppm", "doExportPPM", "no"}, {"JPEG", "jpg", "doExportJPG", "no"}, {"GIF", "gif", "doExportGIF", "no"}, {"PNG", "png", "doExportPNG", "no"}, {"EPIC", "epic", "doExportEPIC", "no"}, {"EEPIC", "eepic", "doExportEEPIC", "no"}};
    String printCommand;
    String fig2devPath;
    String fig2devPS;
    String fig2devEPS;
    String fig2devIBMGL;
    String fig2devLATEX;
    String fig2devPSTEX;
    String fig2devPICTEX;
    String fig2devJPG;
    String fig2devGIF;
    String fig2devTIFF;
    String fig2devPNG;
    String fig2devPPM;
    String fig2devEPIC;
    String fig2devEEPIC;
    boolean fig2devPSCentered = true;
    boolean fig2devPSOrientation = true;
    double fig2devMagnification = 1.0;
    FigBasicEditor editor = null;
    FigBbox bbox = null;

    public void setEditor(FigBasicEditor figBasicEditor) {
        this.editor = figBasicEditor;
        this.updateCommandLine();
    }

    public void setConsole(JConsole jConsole) {
        this.console = jConsole;
    }

    public void buildGUI() {
        Serializable serializable;
        try {
            serializable = SetupManager.getColor("jfig.gui.EditDialog.BackgroundColor", null);
            if (serializable != null) {
                this.setBackground((Color)serializable);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.cancelButton = new JButton("Cancel");
        this.exportNowButton = new JButton("Export now");
        serializable = new JPanel(new GridLayout(0, 1));
        ((JComponent)serializable).setBorder(new EmptyBorder(10, 10, 10, 5));
        ((Container)serializable).add(new JLabel("output format:", 4));
        if (this.showColorOptions) {
            ((Container)serializable).add(new JLabel("color option:", 4));
            ((Container)serializable).add(new JLabel(" "));
        }
        ((Container)serializable).add(new JLabel("magnification:", 4));
        ((Container)serializable).add(new JLabel("orientation:", 4));
        ((Container)serializable).add(new JLabel("offsets x,y:", 4));
        ((Container)serializable).add(new JLabel(" "));
        ((Container)serializable).add(new JLabel("output filename:", 4));
        ((Container)serializable).add(new JLabel("directory:", 4));
        ((Container)serializable).add(new JLabel("fig2dev path:", 4));
        ((Container)serializable).add(new JLabel(" "));
        ((Container)serializable).add(new JLabel("command line:", 4));
        JPanel jPanel = new JPanel(new FlowLayout(2));
        jPanel.add(this.cancelButton);
        ((Container)serializable).add(jPanel);
        JPanel jPanel2 = new JPanel(new GridLayout(0, 1));
        jPanel2.setBorder(new EmptyBorder(10, 5, 10, 10));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(0));
        this.languageChoice = new JComboBox();
        int n = 0;
        while (n < this.data.length) {
            this.languageChoice.addItem(this.data[n][0]);
            ++n;
        }
        this.languageChoice.setSelectedIndex(0);
        jPanel3.add(this.languageChoice);
        jPanel2.add(jPanel3);
        JPanel jPanel4 = new JPanel(new FlowLayout(0));
        this.colorChoice = new JComboBox();
        this.colorChoice.addItem("full color");
        this.colorChoice.addItem("black and white only");
        this.colorChoice.setSelectedItem("full color");
        jPanel4.add(this.colorChoice);
        if (this.showColorOptions) {
            jPanel2.add(jPanel4);
            jPanel2.add(new JLabel(""));
        }
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new FlowLayout(0));
        this.magnificationTF = new JTextField("100", 6);
        this.sizeLabel = new JLabel("  [10.0 x 10.0 inches]  ");
        this.fitToPageButton = new JButton("Fit to A4");
        this.setMagnification(this.fig2devMagnification);
        jPanel5.add(this.magnificationTF);
        jPanel5.add(new JLabel("% "));
        jPanel5.add(this.sizeLabel);
        jPanel5.add(this.fitToPageButton);
        jPanel2.add(jPanel5);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new FlowLayout(0));
        this.orientationChoice = new JComboBox();
        this.orientationChoice.addItem("landscape");
        this.orientationChoice.addItem("portrait");
        this.setFig2devPSOrientation(this.fig2devPSOrientation);
        this.centerChoice = new JComboBox();
        this.centerChoice.addItem("center");
        this.centerChoice.addItem("flush left");
        this.setFig2devPSCentered(this.fig2devPSCentered);
        jPanel6.add(this.orientationChoice);
        jPanel6.add(this.centerChoice);
        jPanel2.add(jPanel6);
        JPanel jPanel7 = new JPanel(new FlowLayout(0));
        this.xoffsetTF = new JTextField("0", 4);
        this.yoffsetTF = new JTextField("0", 4);
        jPanel7.add(this.xoffsetTF);
        jPanel7.add(this.yoffsetTF);
        jPanel7.add(new JLabel("inches"));
        jPanel2.add(jPanel7);
        jPanel2.add(new JLabel(" "));
        JPanel jPanel8 = new JPanel(new FlowLayout(0));
        this.filenameTF = new JTextField("", 40);
        this.filenameButton = new JButton("Browse");
        jPanel8.add(this.filenameTF);
        jPanel8.add(this.filenameButton);
        jPanel2.add(jPanel8);
        JPanel jPanel9 = new JPanel(new FlowLayout(0));
        this.directoryTF = new JTextField("", 40);
        jPanel9.add(this.directoryTF);
        jPanel2.add(jPanel9);
        JPanel jPanel10 = new JPanel(new FlowLayout(0));
        this.fig2devPathTF = new JTextField("", 40);
        this.fig2devPathTF.setText(this.fig2devPath);
        jPanel10.add(this.fig2devPathTF);
        jPanel2.add(jPanel10);
        JPanel jPanel11 = new JPanel(new FlowLayout(0));
        this.autosaveCB = new JCheckBox("save FIG file before export");
        this.quoteNamesCB = new JCheckBox("quote \"filenames containing spaces\"");
        this.quoteNamesCB.setToolTipText("add quotes around filenames which contain space chars?");
        this.quoteNamesCB.setSelected(SetupManager.getBoolean("jfig.gui.ExportOptionsDialog.QuoteNames", true));
        jPanel11.add(this.quoteNamesCB);
        jPanel2.add(jPanel11);
        JPanel jPanel12 = new JPanel(new FlowLayout(0));
        this.commandLineTF = new JTextField("", 50);
        jPanel12.add(this.commandLineTF);
        jPanel2.add(jPanel12);
        JPanel jPanel13 = new JPanel(new FlowLayout(0));
        jPanel13.add(this.exportNowButton);
        jPanel13.add(new JLabel("using above command"));
        jPanel2.add(jPanel13);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add("West", (Component)serializable);
        this.getContentPane().add("East", jPanel2);
        this.pack();
    }

    public void buildCallbacks() {
        JExportOptionsDialog jExportOptionsDialog = this;
        if (jExportOptionsDialog == null) {
            throw null;
        }
        KeyMultiplexer keyMultiplexer = jExportOptionsDialog.new KeyMultiplexer();
        this.filenameTF.addKeyListener(keyMultiplexer);
        this.directoryTF.addKeyListener(keyMultiplexer);
        this.xoffsetTF.addKeyListener(keyMultiplexer);
        this.yoffsetTF.addKeyListener(keyMultiplexer);
        this.magnificationTF.addKeyListener(keyMultiplexer);
        this.languageChoice.addItemListener(this);
        this.orientationChoice.addItemListener(this);
        this.centerChoice.addItemListener(this);
        this.colorChoice.addItemListener(this);
        this.fitToPageButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.exportNowButton.addActionListener(this);
        this.filenameButton.addActionListener(this);
        this.addWindowListener(new JWindowCloser(this, false));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.fitToPageButton) {
            this.dbg("-#- fitToPageButton: " + actionEvent);
            this.fitToLandscapeA4();
            this.updateCommandLine();
        } else if (object == this.cancelButton) {
            this.dbg("-#- cancelButton: " + actionEvent);
            this.setVisible(false);
        } else if (object == this.exportNowButton) {
            this.dbg("-#- exportNowButton: " + actionEvent);
            this.doExportNow();
        } else if (object == this.filenameButton) {
            this.dbg("-#- filenameButton: " + actionEvent);
            this.doBrowseFilename();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.dbg("-#- optionChangeHandler: " + itemEvent);
        this.updateOutFilenameExtension();
        this.updateCommandLine();
        this.showSize();
    }

    public void loadExportSetup() {
        String string = "jfig.gui.ExportOptionsDialog.";
        this.debug = SetupManager.getBoolean(string + "Debug", true);
        this.autosave = SetupManager.getBoolean(string + "Autosave", true);
        this.waitExec = SetupManager.getBoolean(string + "Autosave", true);
        this.showColorOptions = SetupManager.getBoolean(string + "ShowColorOptions", false);
        this.printCommand = SetupManager.getProperty(string + "Print", "lpr");
        this.fig2devPath = SetupManager.getProperty(string + "fig2devPath", null);
        if (this.fig2devPath == null) {
            String string2 = "fig2dev";
            try {
                String string3 = System.getProperty("os.name").toLowerCase();
                string2 = string3.indexOf("windows") >= 0 ? "c:\\windows\\fig2dev.exe" : "/usr/X11/bin/fig2dev";
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            SetupManager.setProperty(string + "fig2devPath", string2);
            this.fig2devPath = SetupManager.getProperty(string + "fig2devPath", null);
        }
        this.fig2devPS = SetupManager.getProperty(string + "fig2devPS", "-L ps -P");
        this.fig2devEPS = SetupManager.getProperty(string + "fig2devEPS", "-L eps");
        this.fig2devIBMGL = SetupManager.getProperty(string + "fig2devIBMGL", "-L ibmgl");
        this.fig2devLATEX = SetupManager.getProperty(string + "fig2devLATEX", "-L latex");
        this.fig2devPSTEX = SetupManager.getProperty(string + "fig2devPSTEX", "-L latex");
        this.fig2devPICTEX = SetupManager.getProperty(string + "fig2devPICTEX", "-L pictex");
        this.fig2devGIF = SetupManager.getProperty(string + "fig2devGIF", "-L gif");
        this.fig2devJPG = SetupManager.getProperty(string + "fig2devJPG", "-L jpeg");
        this.fig2devPPM = SetupManager.getProperty(string + "fig2devPPM", "-L ppm");
        this.fig2devPNG = SetupManager.getProperty(string + "fig2devPNG", "-L png");
        this.fig2devEEPIC = SetupManager.getProperty(string + "fig2devEEPIC", "-L eepic");
        this.fig2devEPIC = SetupManager.getProperty(string + "fig2devEPIC", "-L epic");
        this.fig2devMagnification = SetupManager.getDouble(string + "fig2devMagnification", 1.0);
        this.fig2devPSCentered = SetupManager.getBoolean(string + "fig2devPSCentered", true);
        this.fig2devPSOrientation = SetupManager.getBoolean(string + "fig2devPSOrientation", true);
        if (this.debug) {
            System.err.println("-#- JExportOptionsDialog.loadExportSetup: \ndebug " + this.debug + " Autosave " + this.autosave + "\n" + "fig2dev path " + this.fig2devPath + "\n" + "fig2devPS " + this.fig2devPS + "\n" + "fig2devEPS " + this.fig2devEPS + "\n" + "fig2devIBMGL " + this.fig2devIBMGL + "\n" + "fig2devLATEX " + this.fig2devLATEX + "\n" + "fig2devPSTEX " + this.fig2devPSTEX + "\n" + "fig2devPICTEX " + this.fig2devPICTEX + "\n");
        }
    }

    public void getAndSetDefaultFont() {
        int n;
        int n2;
        String string = "jfig.gui.JExportOptionsDialog";
        String string2 = SetupManager.getProperty(string + "FontName", "SansSerif");
        Font font = new Font(string2, n2 = 0, n = SetupManager.getInteger(string + "FontSize", 12));
        if (font != null) {
            this.setFont(font);
        }
    }

    public int getColorOption() {
        String string = (String)this.colorChoice.getSelectedItem();
        if (string.equals("full color")) {
            return 2;
        }
        if (string.equals("black and white, I/O colored")) {
            return 3;
        }
        if (string.equals("black and white only")) {
            return 4;
        }
        this.msg("-E- unkwown color selection: " + string);
        return 3;
    }

    public void showSize() {
        if (this.bbox == null) {
            this.updateFigObjectsBoundingBox();
        }
        Dimension dimension = new Dimension(this.bbox.getXr() - this.bbox.getXl(), this.bbox.getYb() - this.bbox.getYt());
        double d = this.getMagnification();
        double d2 = d * (double)dimension.width / 2400.0;
        double d3 = d * (double)dimension.height / 2400.0;
        this.sizeLabel.setText("  [" + new Format("%3.1f").form(d2) + " x " + new Format("%3.1f").form(d3) + " " + "inches]  ");
    }

    public void setMagnification(double d) {
        this.fig2devMagnification = d;
        int n = (int)(100.0 * d + 0.5);
        this.magnificationTF.setText("" + n);
    }

    public double getMagnification() {
        double d;
        try {
            d = 0.01 * Double.valueOf(this.magnificationTF.getText().trim());
        }
        catch (Exception exception) {
            d = 1.0;
        }
        this.fig2devMagnification = d;
        return d;
    }

    public int getOrientation() {
        return "landscape".equals(this.orientationChoice.getSelectedItem()) ? 0 : 1;
    }

    public int getJustification() {
        return "center".equals(this.centerChoice.getSelectedItem()) ? 0 : 1;
    }

    public void setFilename(String string) {
        this.filenameTF.setText(string);
    }

    public String getExtension() {
        return this.data[this.languageChoice.getSelectedIndex()][1];
    }

    public void updateOutFilenameExtension() {
        this.dbg("-#- updateOutFilenameExtension...");
        String string = this.filenameTF.getText();
        try {
            int n = string.lastIndexOf(46);
            string = n >= 0 ? string.substring(0, n) + "." + this.getExtension() : string + "." + this.getExtension();
        }
        catch (Exception exception) {
            this.dbg("-#- " + exception);
        }
        this.filenameTF.setText(string);
    }

    public void updateCommandLine() {
        this.dbg("-#- updateCommandLine...");
        int n = this.languageChoice.getSelectedIndex();
        String string = this.getFigFilename();
        String string2 = this.getOutFilename();
        String string3 = this.getFig2devPath();
        String string4 = null;
        if (this.quoteNamesCB.isSelected()) {
            if (string3.indexOf(32) >= 0) {
                string3 = "\"" + string3 + "\"";
            }
            if (string.indexOf(32) >= 0) {
                string = "\"" + string + "\"";
            }
            if (string2.indexOf(32) >= 0) {
                string2 = "\"" + string2 + "\"";
            }
        }
        switch (n) {
            case 0: {
                string4 = string3 + " " + this.fig2devPS + this.getFig2devMagnification() + this.getFig2devPSCentered() + this.getFig2devPSOrientation() + this.getFig2devPSOffset() + " " + string + " " + string2;
                break;
            }
            case 1: {
                string4 = string3 + " " + this.fig2devEPS + this.getFig2devMagnification() + this.getFig2devPSCentered() + this.getFig2devPSOrientation() + this.getFig2devPSOffset() + " " + string + " " + string2;
                break;
            }
            case 2: {
                string4 = string3 + " " + this.fig2devIBMGL + this.getFig2devMagnification() + " " + string + " " + string2;
                break;
            }
            case 3: {
                string4 = string3 + " " + this.fig2devLATEX + this.getFig2devMagnification() + " " + string + " " + string2;
                break;
            }
            case 4: {
                string4 = string3 + " " + this.fig2devPICTEX + this.getFig2devMagnification() + " " + string + " " + string2;
                break;
            }
            case 5: {
                string4 = "xxx (not yet supported)";
                break;
            }
            case 6: {
                string4 = string3 + " " + this.fig2devPPM + this.getFig2devMagnification() + " " + string + " " + string2;
                break;
            }
            case 7: {
                string4 = string3 + " " + this.fig2devJPG + this.getFig2devMagnification() + " -q 70" + " " + string + " " + string2;
                break;
            }
            case 8: {
                string4 = string3 + " " + this.fig2devGIF + this.getFig2devMagnification() + " " + string + " " + string2;
                break;
            }
            case 9: {
                string4 = string3 + " " + this.fig2devPNG + this.getFig2devMagnification() + " " + string + " " + string2;
                break;
            }
            case 10: {
                string4 = string3 + " " + this.fig2devEPIC + this.getFig2devMagnification() + " " + string + " " + string2;
                break;
            }
            case 11: {
                string4 = string3 + " " + this.fig2devEEPIC + this.getFig2devMagnification() + " " + string + " " + string2;
                break;
            }
            default: {
                this.msg("-E- internal: unknown export language: " + n);
                return;
            }
        }
        this.commandLineTF.setText(string4);
    }

    public String getFigFilename() {
        String string = null;
        try {
            string = this.editor.getFilename();
        }
        catch (Exception exception) {
            string = "unnamed.fig";
        }
        if (string == null) {
            return "unnamed.fig";
        }
        return string;
    }

    public String getOutFilename() {
        String string = this.directoryTF.getText();
        String string2 = this.filenameTF.getText();
        if (string != null && string.length() > 0) {
            return string + File.separator + string2;
        }
        if (string2 == null || string2.length() == 0) {
            return "unnamed.ps";
        }
        return string2;
    }

    public void updateOutFilenameFromFigFilename() {
        this.dbg("-#- updateOutFilenameFromFigFilename...");
        String string = null;
        String string2 = null;
        String string3 = null;
        try {
            string = this.getFigFilename();
            int n = string.lastIndexOf(File.separatorChar);
            if (n < 0) {
                string2 = "";
                string3 = string.substring(n + 1);
            } else {
                string2 = string.substring(0, n);
                string3 = string.substring(n + 1);
            }
            this.filenameTF.setText(string3);
            this.directoryTF.setText(string2);
            this.updateOutFilenameExtension();
        }
        catch (Exception exception) {
            this.msg("-E- internal: " + exception);
            this.msg("-E- filenames: " + string + " " + string2 + " " + string3);
            exception.printStackTrace();
        }
    }

    public String getFig2devPath() {
        return this.fig2devPathTF.getText().trim();
    }

    public String getFig2devMagnification() {
        return " -m " + this.getRoundedValue(this.getMagnification());
    }

    public String getRoundedValue(double d) {
        return new Format("%3.2f").form(d);
    }

    public String getFig2devPSOrientation() {
        if ("landscape".equals(this.orientationChoice.getSelectedItem())) {
            return " -l dummy";
        }
        return "";
    }

    public void setFig2devPSOrientation(boolean bl) {
        if (bl) {
            this.orientationChoice.setSelectedItem("portrait");
        } else {
            this.orientationChoice.setSelectedItem("landscape");
        }
    }

    public String getFig2devPSCentered() {
        if ("center".equals(this.centerChoice.getSelectedItem())) {
            return " -c";
        }
        return " -e";
    }

    public void setFig2devPSCentered(boolean bl) {
        if (bl) {
            this.centerChoice.setSelectedItem("center");
        } else {
            this.centerChoice.setSelectedItem("flush left");
        }
    }

    public String getFig2devPSOffset() {
        double d = 0.0;
        double d2 = 0.0;
        String string = "";
        try {
            d = Double.valueOf(this.xoffsetTF.getText().trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            d2 = Double.valueOf(this.yoffsetTF.getText().trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (d != 0.0) {
            string = string + " -x " + this.getRoundedValue(d / 72.0);
        }
        if (d2 != 0.0) {
            string = string + " -y " + this.getRoundedValue(d2 / 72.0);
        }
        return string;
    }

    public void fitToLandscapeA4() {
        this.updateFigObjectsBoundingBox();
        Dimension dimension = new Dimension(this.bbox.getXr() - this.bbox.getXl(), this.bbox.getYb() - this.bbox.getYt());
        double d = 26173.0 / (double)dimension.width;
        double d2 = 17952.0 / (double)dimension.height;
        double d3 = Math.min(d, d2);
        d3 = Math.max(0.01, d3);
        double d4 = d3 * (double)dimension.width;
        double d5 = d3 * (double)dimension.height;
        this.setMagnification(d3);
        this.showSize();
    }

    public void updateFigObjectsBoundingBox() {
        try {
            this.bbox = BoundingBoxCalculator.getBoundingBox(this.editor.getObjects());
        }
        catch (Throwable throwable) {
            this.bbox = new FigBbox(0, 0, 26173, 17952);
        }
        if (this.debug) {
            this.msg("-#- updateFigObjectBoundingBox: " + this.bbox);
        }
        this.showSize();
    }

    public void doExportNow() {
        this.dbg("-#- doExportNow: " + this.commandLineTF.getText());
        this.doAutoSave();
        try {
            Process process = Runtime.getRuntime().exec(this.commandLineTF.getText());
            if (this.waitExec) {
                process.waitFor();
                this.printSubprocessOutput(process);
            }
        }
        catch (Exception exception) {
            this.msg("-E- exception during export: " + exception);
            exception.printStackTrace();
        }
    }

    public void doExportPS() {
        this.languageChoice.setSelectedIndex(0);
        this.updateOutFilenameExtension();
        this.updateCommandLine();
        this.doExportNow();
    }

    public void doExportEPS() {
        this.languageChoice.setSelectedIndex(1);
        this.updateOutFilenameExtension();
        this.updateCommandLine();
        this.doExportNow();
    }

    public void requestAntiAliasing(boolean bl) {
        this.requestAntiAliasing = bl;
    }

    public void checkRequestAntiAliasing(Graphics graphics) {
        try {
            Graphics2D graphics2D = (Graphics2D)graphics;
            RenderingHints renderingHints = new RenderingHints(null);
            if (this.requestAntiAliasing) {
                renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                renderingHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                renderingHints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            } else {
                renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
            graphics2D.setRenderingHints(renderingHints);
        }
        catch (Exception exception) {
            this.msg("-#- Internal in doExportNativePNG: " + exception);
        }
    }

    public void doExportNativeGIF() {
        this.languageChoice.setSelectedIndex(8);
        this.updateOutFilenameExtension();
        this.updateCommandLine();
        String string = this.getOutFilename();
        this.msg("-I- exporting GIF to file '" + string + "'...");
        FigCanvas figCanvas = this.editor.getObjectCanvas();
        try {
            int n = figCanvas.getSize().width;
            int n2 = figCanvas.getSize().height;
            Image image = this.createImage(n, n2);
            if (image == null) {
                this.msg("-E- Failed to create buffer image, cannot write GIF...");
                return;
            }
            this.msg("...drawing objects...");
            Graphics graphics = image.getGraphics();
            this.checkRequestAntiAliasing(graphics);
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, n, n2);
            figCanvas.drawAllObjects(graphics);
            this.msg("...encoding GIF...");
            GIFEncoder gIFEncoder = new GIFEncoder(image);
            this.msg("...writing GIF to file...");
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            gIFEncoder.Write((OutputStream)bufferedOutputStream);
            fileOutputStream.close();
        }
        catch (Exception exception) {
            this.msg("-E- Exception during GIF export: " + exception.toString());
            ExceptionTracer.trace(exception);
        }
        this.msg("...ready");
    }

    public void doExportNativePNG() {
        this.languageChoice.setSelectedIndex(9);
        this.updateOutFilenameExtension();
        this.updateCommandLine();
        String string = this.getOutFilename();
        this.msg("-I- exporting PNG to file '" + string + "'...");
        FigCanvas figCanvas = this.editor.getObjectCanvas();
        try {
            int n = figCanvas.getSize().width;
            int n2 = figCanvas.getSize().height;
            BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
            if (bufferedImage == null) {
                this.msg("-E- Failed to create buffer image, cannot write GIF...");
                return;
            }
            this.msg("...drawing objects...");
            Graphics graphics = bufferedImage.getGraphics();
            this.checkRequestAntiAliasing(graphics);
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, n, n2);
            figCanvas.drawAllObjects(graphics);
            this.msg("...encoding PNG...");
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            ImageIO.write((RenderedImage)bufferedImage, "PNG", fileOutputStream);
            fileOutputStream.close();
        }
        catch (Exception exception) {
            this.msg("-E- Exception during GIF export: " + exception.toString());
            ExceptionTracer.trace(exception);
        }
        this.msg("...ready");
    }

    public void doExportNativePPM() {
        this.languageChoice.setSelectedIndex(6);
        this.updateOutFilenameExtension();
        this.updateCommandLine();
        String string = this.getOutFilename();
        this.msg("-I- exporting PPM to file '" + string + "'...");
        FigCanvas figCanvas = this.editor.getObjectCanvas();
        try {
            int n = figCanvas.getSize().width;
            int n2 = figCanvas.getSize().height;
            Image image = this.createImage(n, n2);
            if (image == null) {
                this.msg("-E- Failed to create buffer image, cannot write PPM...");
                return;
            }
            this.msg("...drawing objects...");
            Graphics graphics = image.getGraphics();
            this.checkRequestAntiAliasing(graphics);
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, n, n2);
            figCanvas.drawAllObjects(graphics);
            this.msg("...encoding and writing PPM...");
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(string)));
            new PPMWriter().writePPM(image, dataOutputStream);
            dataOutputStream.close();
            this.msg("...ok. ");
        }
        catch (Exception exception) {
            this.msg("-E- Exception during PPM export: " + exception.toString());
            ExceptionTracer.trace(exception);
        }
        this.msg("...ready");
    }

    public void doExportEPIC() {
        this.languageChoice.setSelectedIndex(10);
        this.updateOutFilenameExtension();
        this.updateCommandLine();
        this.doExportNow();
    }

    public void doExportEEPIC() {
        this.languageChoice.setSelectedIndex(11);
        this.updateOutFilenameExtension();
        this.updateCommandLine();
        this.doExportNow();
    }

    public void doExportPrintPS() {
        this.languageChoice.setSelectedIndex(0);
        this.updateOutFilenameExtension();
        this.updateCommandLine();
        String string = this.getFigFilename();
        String string2 = this.getOutFilename();
        String string3 = this.fig2devPath + " " + this.fig2devPS + this.getFig2devMagnification() + this.getFig2devPSCentered() + this.getFig2devPSOrientation() + this.getFig2devPSOffset() + " " + string + " " + string2;
        String string4 = this.printCommand + " " + string2;
        try {
            Process process = Runtime.getRuntime().exec(string3);
            this.msg("-I- " + process.toString() + ": " + string3);
            process.waitFor();
            this.printSubprocessOutput(process);
            process = Runtime.getRuntime().exec(string4);
            this.msg("-I- " + process.toString() + ": " + string4);
            process.waitFor();
            this.printSubprocessOutput(process);
        }
        catch (Exception exception) {
            this.msg("-E- Exception during export: " + exception.toString());
            ExceptionTracer.trace(exception);
        }
    }

    public void doAutoSave() {
        Method method = null;
        try {
            method = this.editor.getClass().getMethod("doAutoSave", new Class[0]);
            method.invoke((Object)this.editor, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (this.debug) {
                this.msg("-I- JExportOptionsDialog: No doAutoSave() method.");
            }
        }
        catch (Exception exception) {
            this.msg("-E- JExportOptionsDialog: Internal: " + exception);
            exception.printStackTrace();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void doAutoSaveDummy() {
        block6: {
            var1_1 = null;
            try {
                var1_1 = File.createTempFile("jfig", ".fig");
                var1_1.deleteOnExit();
            }
            catch (NoSuchMethodError var2_2) {
                var3_6 = 10000;
                var4_7 = true;
                ** while (var4_7)
            }
lbl-1000:
            // 1 sources

            {
                var1_1 = new File("jfig" + ++var3_6 + ".fig");
                var4_7 = var1_1.exists();
                if (var3_6 <= 11000) continue;
                throw new Error("could not create tmp file, tried 10000 times.");
lbl14:
                // 1 sources

                break block6;
            }
            catch (Throwable var2_3) {
                var2_3.printStackTrace();
            }
        }
        try {
            var2_4 = new FileOutputStream(var1_1);
            var2_4.write(120);
            var2_4.close();
        }
        catch (Throwable var2_5) {
            var2_5.printStackTrace();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void printSubprocessOutput(Process var1_1) throws IOException {
        var2_2 = new BufferedReader(new InputStreamReader(var1_1.getInputStream()));
        var3_3 = new BufferedReader(new InputStreamReader(var1_1.getErrorStream()));
        var4_4 = null;
        if (var3_3 != null) ** GOTO lbl7
        return;
lbl-1000:
        // 1 sources

        {
            this.msg("-E- subprocess: " + var4_4);
lbl7:
            // 2 sources

            ** while ((var4_4 = var3_3.readLine()) != null)
        }
lbl8:
        // 1 sources

        if (var2_2 != null) ** GOTO lbl11
        return;
lbl-1000:
        // 1 sources

        {
            this.msg("-I- subprocess: " + var4_4);
lbl11:
            // 2 sources

            ** while ((var4_4 = var2_2.readLine()) != null)
        }
lbl12:
        // 1 sources

    }

    public void doBrowseFilename() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            this.fileChooser.setFileSelectionMode(2);
            this.fileChooser.setDialogTitle("Select output filename:");
        }
        try {
            String string = SetupManager.getProperty("jfig.gui.CurrentFigFileDirectory", null);
            if (string != null) {
                this.fileChooser.setCurrentDirectory(new File(string));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n = this.fileChooser.showSaveDialog(this.parent);
        if (n == 0) {
            File file = this.fileChooser.getSelectedFile();
            this.filenameTF.setText(file.getName());
            this.directoryTF.setText(file.getParent());
        }
        this.updateCommandLine();
    }

    public void msg(String string) {
        if (this.console != null) {
            this.console.println(string);
        } else {
            System.out.println(string);
        }
    }

    public void dbg(String string) {
        if (this.debug) {
            System.out.println(string);
        }
    }

    public static void main(String[] stringArray) {
        SetupManager.loadLocalProperties("jfig.cnf");
        JFrame jFrame = new JFrame("JExportOptionsDialog test.");
        JExportOptionsDialog jExportOptionsDialog = new JExportOptionsDialog(jFrame);
        jExportOptionsDialog.updateFigObjectsBoundingBox();
        jExportOptionsDialog.setEditor(null);
        jExportOptionsDialog.show();
        jExportOptionsDialog.updateOutFilenameFromFigFilename();
    }

    public JExportOptionsDialog(Frame frame) {
        super(frame, "Select Export Options");
        this.FULL_COLORS = 2;
        this.IO_COLORS = 3;
        this.BLACK_WHITE = 4;
        this.FULL_COLORS_STRING = "full color";
        this.IO_COLORS_STRING = "black and white, I/O colored";
        this.BLACK_WHITE_STRING = "black and white only";
        this.A4_WIDTH = 26173;
        this.A4_HEIGHT = 17952;
        this.parent = frame;
        this.getAndSetDefaultFont();
        this.loadExportSetup();
        this.buildGUI();
        this.buildCallbacks();
        this.updateCommandLine();
    }

    class KeyMultiplexer
    implements KeyListener {
        public void keyPressed(KeyEvent keyEvent) {
            JExportOptionsDialog.this.dbg("-*- " + keyEvent);
            this.mux();
        }

        public void keyReleased(KeyEvent keyEvent) {
            JExportOptionsDialog.this.dbg("-*- " + keyEvent);
            this.mux();
        }

        public void keyTyped(KeyEvent keyEvent) {
            JExportOptionsDialog.this.dbg("-*- " + keyEvent);
            this.mux();
        }

        public void mux() {
            JExportOptionsDialog.this.updateCommandLine();
            JExportOptionsDialog.this.showSize();
        }

        KeyMultiplexer() {
        }
    }
}

