/*
 * Decompiled with CFR 0.152.
 */
package jfig.gui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.awt.event.WindowListener;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import jfig.canvas.FigTrafo2D;
import jfig.commands.FigBasicEditor;
import jfig.gui.ImageHelper;
import jfig.gui.JEditBaseobjectDialog;
import jfig.objects.FigAttribs;
import jfig.objects.FigEllipse;
import jfig.utils.AntiDeadlock;
import jfig.utils.ExceptionTracer;
import jfig.utils.SetupManager;

public class JEditEllipseDialog
extends JEditBaseobjectDialog
implements ActionListener,
KeyListener,
WindowListener {
    FigEllipse ellipse;
    Point savedCenter;
    Point savedRadius;
    JTextField centerTF;
    JTextField radiusTF;

    public void setEllipse(FigEllipse figEllipse) {
        if (figEllipse == null) {
            return;
        }
        this.ellipse = figEllipse;
        this.savedAttribs = figEllipse.getAttributes().getClone();
        this.currentAttribs = figEllipse.getAttributes();
        this.showAttribs(this.currentAttribs);
        this.AC.showCoords(figEllipse.getCenterPoint(), this.centerTF);
        this.AC.showCoords(figEllipse.getRadiusPoint(), this.radiusTF);
        this.savedCenter = figEllipse.getCenterPoint();
        this.savedRadius = figEllipse.getRadiusPoint();
    }

    public JPanel buildLabelsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 1, 0, 6));
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel.add(this.lineColorLabel);
        jPanel.add(this.lineWidthLabel);
        jPanel.add(this.fillColorLabel);
        jPanel.add(this.rotationAngleLabel);
        jPanel.add(this.depthLabel);
        jPanel.add(new JLabel("Center point: ", 4));
        jPanel.add(new JLabel("Radii (dx,dy): ", 4));
        return jPanel;
    }

    public JPanel buildAttribsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 1, 0, 6));
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel.add(this.buildLineColorPanel());
        jPanel.add(this.buildLineStylePanel());
        jPanel.add(this.buildFillStylePanel());
        jPanel.add(this.buildRotationAnglePanel());
        jPanel.add(this.buildDepthPanel());
        jPanel.add(this.buildCenterPointPanel());
        jPanel.add(this.buildRadiusPanel());
        this.dbg("-#- buildAttribsPanel ok.");
        return jPanel;
    }

    public JPanel buildCenterPointPanel() {
        this.centerTF = new JTextField("(2400,3600)", 15);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add("Center", this.centerTF);
        return jPanel;
    }

    public JPanel buildRadiusPanel() {
        this.radiusTF = new JTextField("(2400,3600)", 15);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add("Center", this.radiusTF);
        return jPanel;
    }

    public JPanel buildCoordsPanel() {
        return new JPanel();
    }

    public void retrieveAttribs(FigAttribs figAttribs) {
        this.AC.setLineStyle(figAttribs, this.lineStyleButton);
        this.AC.setLineWidth(figAttribs, this.lineWidthButton);
        this.AC.setLineColor(figAttribs, this.lineColorButton);
        this.AC.setDashLength(figAttribs, this.dashLengthField);
        this.AC.setRotationAngle(figAttribs, this.rotationAngleButton);
        this.AC.setFillColor(figAttribs, this.fillColorButton);
        this.AC.setFillPattern(figAttribs, this.fillPatternButton);
        this.AC.setDepth(figAttribs, this.depthButton);
        this.dbg("new attribs= " + figAttribs);
    }

    public void showAttribs(FigAttribs figAttribs) {
        this.AC.showLineStyle(figAttribs, this.lineStyleButton);
        this.AC.showLineWidth(figAttribs, this.lineWidthButton);
        this.AC.showLineColor(figAttribs, this.lineColorButton);
        this.AC.showDashLength(figAttribs, this.dashLengthField);
        this.AC.showRotationAngle(figAttribs, this.rotationAngleButton);
        this.AC.showFillColor(figAttribs, this.fillColorButton);
        this.AC.showFillPattern(figAttribs, this.fillPatternButton);
        this.AC.showDepth(figAttribs, this.depthButton);
        this.dbg("existing attribs= " + figAttribs);
    }

    public void retrievePoints(FigEllipse figEllipse, JTextField jTextField, JTextField jTextField2) {
        Point[] pointArray = this.AC.getCoords(jTextField.getText());
        Point[] pointArray2 = this.AC.getCoords(jTextField2.getText());
        if (pointArray == null) {
            return;
        }
        if (pointArray2 == null) {
            return;
        }
        figEllipse.setCenterAndRadius(pointArray[0], pointArray2[0]);
    }

    public void restorePoints(FigEllipse figEllipse) {
        figEllipse.setCenterAndRadius(this.savedCenter, this.savedRadius);
    }

    public void doCancel() {
        this.dbg("-#- EditEllipseDialog.Cancel");
        this.ellipse.setAttributes(this.savedAttribs);
        this.restorePoints(this.ellipse);
        this.setVisible(false);
        AntiDeadlock.sleep(200L);
        this.doRedraw();
    }

    public void doApply() {
        this.dbg("-#- EditEllipseDialog.Apply");
        this.retrieveAttribs(this.currentAttribs);
        this.ellipse.update(this.currentAttribs);
        this.retrievePoints(this.ellipse, this.centerTF, this.radiusTF);
        this.editor.deleteFromObjectList(this.ellipse);
        this.editor.insertIntoObjectList(this.ellipse);
        this.doRedraw();
    }

    public void doOK() {
        this.dbg("-#- EditEllipseDialog.OK...");
        this.retrieveAttribs(this.currentAttribs);
        this.ellipse.update(this.currentAttribs);
        this.retrievePoints(this.ellipse, this.centerTF, this.radiusTF);
        this.editor.deleteFromObjectList(this.ellipse);
        this.editor.insertIntoObjectList(this.ellipse);
        this.setVisible(false);
        AntiDeadlock.sleep(200L);
        this.doRedraw();
    }

    public static void main(String[] stringArray) {
        ExceptionTracer.setEnabled(true);
        JFrame jFrame = new JFrame("dummy");
        jFrame.setSize(new Dimension(100, 100));
        ImageHelper.setVisibleParent(jFrame);
        SetupManager.loadAllProperties("jfig.cnf");
        JEditEllipseDialog jEditEllipseDialog = new JEditEllipseDialog((Frame)jFrame, null);
        jEditEllipseDialog.setEllipse(new FigEllipse(new Point(4800, 2400), new Point(371, 576), new FigAttribs(), new FigTrafo2D()));
        jEditEllipseDialog.show();
    }

    public JEditEllipseDialog(Frame frame, FigBasicEditor figBasicEditor) {
        super(frame, figBasicEditor, "Edit circle or ellipse");
    }
}

