/*
 * Decompiled with CFR 0.152.
 */
package jfig.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import jfig.commands.FigBasicEditor;
import jfig.gui.ColorCache;
import jfig.gui.ImageHelper;
import jfig.gui.JColorButton;
import jfig.gui.JFillPatternButton;
import jfig.gui.JFontButton;
import jfig.gui.JNumericStateButton;
import jfig.gui.JStateButton;
import jfig.gui.JStatusCanvas;
import jfig.gui.JUpdateModeButton;
import jfig.gui.StatusMessage;
import jfig.objects.FigAttribs;
import jfig.objects.FigObject;
import jfig.utils.Format;
import jfig.utils.SetupManager;

public class JAttribsControlsFactory {
    private static Hashtable _hashtable = new Hashtable(10);
    boolean debug = false;
    JUpdateModeButton updateModeButton;
    JStateButton snapModeButton;
    JComboBox landscapePortraitChoice;
    JComboBox centerFlushLeftChoice;
    JStateButton lineStyleButton;
    JStateButton lineWidthButton;
    JColorButton lineColorButton;
    JStateButton geometryButton;
    JStateButton arrowModeButton;
    JStateButton arrowStyleButton;
    JStateButton fillStyleButton;
    JFillPatternButton fillPatternButton;
    JColorButton fillColorButton;
    JStateButton textAlignButton;
    JFontButton fontSelectButton;
    JNumericStateButton fontSizeButton;
    JStateButton fontFlagButton;
    JComboBox fontFlagChoice;
    JStateButton objectAlignXButton;
    JStateButton objectAlignYButton;
    JNumericStateButton roundRectButton;
    JNumericStateButton depthButton;
    JTextField dashLengthField;
    JNumericStateButton rotationAngleButton;
    JStateButton smartLinksButton;
    ColorCache colorCache;
    StatusMessage helper;
    Color backgroundColor;
    Image allIcons;
    Image[] iconImages;
    Image geometryIcons;

    public static JAttribsControlsFactory getJAttribsControlsFactory(FigBasicEditor figBasicEditor) {
        if (figBasicEditor == null) {
            return new JAttribsControlsFactory();
        }
        if (_hashtable.get(figBasicEditor) != null) {
            return (JAttribsControlsFactory)_hashtable.get(figBasicEditor);
        }
        JAttribsControlsFactory jAttribsControlsFactory = new JAttribsControlsFactory();
        _hashtable.put(figBasicEditor, jAttribsControlsFactory);
        return jAttribsControlsFactory;
    }

    public void setStatusMessage(StatusMessage statusMessage) {
        this.helper = statusMessage;
    }

    private Image[] cropButtonImages() {
        this.backgroundColor = Color.green;
        try {
            Color color = SetupManager.getColor("jfig.gui.Editor.BackgroundColor", null);
            this.backgroundColor = color != null ? color : new JPanel().getBackground();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.iconImages = new Image[120];
        int n = 0;
        while (n < 8) {
            int n2 = 0;
            while (n2 < 15) {
                this.iconImages[n + 8 * n2] = ImageHelper.createImage(20, 20);
                Graphics graphics = this.iconImages[n + 8 * n2].getGraphics();
                if (this.allIcons != null) {
                    graphics.drawImage(this.allIcons, 0, 0, 20, 20, 20 * n, 20 * n2, 20 * n + 20, 20 * n2 + 20, this.backgroundColor, null);
                } else {
                    graphics.setColor(Color.black);
                    graphics.drawLine(2, 2, 18, 18);
                    graphics.drawLine(2, 18, 18, 2);
                }
                ++n2;
            }
            ++n;
        }
        return this.iconImages;
    }

    public JUpdateModeButton createUpdateModeButton(Component component) {
        JUpdateModeButton jUpdateModeButton = new JUpdateModeButton(component, "UpdateMode", this.helper, "enable attribute updates: none/all/invert");
        return jUpdateModeButton;
    }

    public JStateButton createLineStyleButton(Component component) {
        Object[] objectArray = new Image[]{this.iconImages[24], this.iconImages[25], this.iconImages[26], this.iconImages[112], this.iconImages[113], this.iconImages[114]};
        JStateButton jStateButton = new JStateButton("line style", (Image[])objectArray, objectArray, this.helper, "Select line style (solid, dashed, dotted, ...)");
        return jStateButton;
    }

    public JColorButton createLineColorButton(Component component) {
        JColorButton jColorButton = new JColorButton(component, "Select line color", this.helper, "Select line color");
        return jColorButton;
    }

    public JFillPatternButton createFillPatternButton(Component component) {
        JFillPatternButton jFillPatternButton = new JFillPatternButton(component, "fill style", this.helper, "Select fill style and pattern");
        return jFillPatternButton;
    }

    public JStateButton createFillStyleButton(Component component) {
        Object[] objectArray = new Image[]{this.iconImages[72], this.iconImages[73]};
        JStateButton jStateButton = new JStateButton("fill style", (Image[])objectArray, objectArray, this.helper, "Select fill style (none, solid, pattern)");
        return jStateButton;
    }

    public JStateButton createSmartLinksButton(Component component) {
        Object[] objectArray = new Image[]{this.iconImages[72], this.iconImages[73]};
        JStateButton jStateButton = new JStateButton("smart links", (Image[])objectArray, objectArray, this.helper, "Select smart links (off, move, slide)");
        return jStateButton;
    }

    public JColorButton createFillColorButton(Component component) {
        JColorButton jColorButton = new JColorButton(component, "Select fill color", this.helper, "Select fill color");
        return jColorButton;
    }

    public JStateButton createArrowStyleButton(Component component) {
        Object[] objectArray = new Image[]{this.iconImages[0], this.iconImages[1], this.iconImages[2], this.iconImages[3], this.iconImages[4], this.iconImages[5], this.iconImages[6], this.iconImages[7]};
        JStateButton jStateButton = new JStateButton("arrow style", (Image[])objectArray, objectArray, this.helper, "Select arrow style");
        return jStateButton;
    }

    public JStateButton createArrowModeButton(Component component) {
        Object[] objectArray = new Image[]{this.iconImages[8], this.iconImages[9], this.iconImages[10], this.iconImages[11]};
        JStateButton jStateButton = new JStateButton("arrow mode", (Image[])objectArray, objectArray, this.helper, "arrow mode (none, front, back, both)");
        return jStateButton;
    }

    public JTextField createFrontArrowWidthField(Component component) {
        JTextField jTextField = new JTextField("1", 5);
        jTextField.setToolTipText("arrow width [mm]");
        return jTextField;
    }

    public JTextField createFrontArrowLengthField(Component component) {
        JTextField jTextField = new JTextField("5", 5);
        jTextField.setToolTipText("arrow length [mm]");
        return jTextField;
    }

    public JTextField createFrontArrowThicknessField(Component component) {
        JTextField jTextField = new JTextField("1", 5);
        jTextField.setToolTipText("arrow line width [mm]");
        return jTextField;
    }

    public JTextField createBackArrowWidthField(Component component) {
        JTextField jTextField = new JTextField("1", 5);
        jTextField.setToolTipText("arrow width [mm]");
        return jTextField;
    }

    public JTextField createBackArrowLengthField(Component component) {
        JTextField jTextField = new JTextField("5", 5);
        jTextField.setToolTipText("arrow length [mm]");
        return jTextField;
    }

    public JTextField createBackArrowThicknessField(Component component) {
        JTextField jTextField = new JTextField("1", 5);
        jTextField.setToolTipText("arrow line width [mm]");
        return jTextField;
    }

    public JStateButton createTextAlignButton(Component component) {
        Object[] objectArray = new Image[]{this.iconImages[29], this.iconImages[30], this.iconImages[31]};
        JStateButton jStateButton = new JStateButton("text alignment", (Image[])objectArray, objectArray, this.helper, "text alignment (left, center, right)");
        return jStateButton;
    }

    public JFontButton createFontSelectButton(Component component) {
        JFontButton jFontButton = new JFontButton(component, "Select font", this.helper, "Select text font");
        jFontButton.setState(0);
        return jFontButton;
    }

    public JNumericStateButton createFontSizeButton(Component component) {
        int[] nArray = new int[]{5, 6, 8, 9, 10, 11, 12, 14, 15, 17, 18, 20, 22, 24, 27, 30, 35, 40, 50, 60, 70, 100};
        JNumericStateButton jNumericStateButton = new JNumericStateButton(component, "Select font size", this.helper, "Select font size [pt]");
        jNumericStateButton.setSteps(nArray);
        jNumericStateButton.setState(12);
        return jNumericStateButton;
    }

    public JComboBox createFontFlagChoice(Component component) {
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.setToolTipText("Select FIG font flags");
        jComboBox.addItem("normal");
        jComboBox.addItem("special");
        jComboBox.setSelectedItem("normal");
        return jComboBox;
    }

    public JStateButton createFontFlagButton(Component component) {
        Object[] objectArray = new Image[]{this.iconImages[13], this.iconImages[14]};
        JStateButton jStateButton = new JStateButton("font flags", (Image[])objectArray, objectArray, this.helper, "FIG font flag (normal/TeX)");
        jStateButton.setState(0);
        return jStateButton;
    }

    public JStateButton createLineWidthButton(Component component) {
        Object[] objectArray = new Image[]{this.iconImages[15], this.iconImages[16], this.iconImages[17], this.iconImages[18], this.iconImages[19], this.iconImages[20], this.iconImages[21], this.iconImages[22], this.iconImages[23]};
        JStateButton jStateButton = new JStateButton("line width", (Image[])objectArray, objectArray, this.helper, "line width [1/80 inch]");
        jStateButton.setState(1);
        return jStateButton;
    }

    public JStateButton createGeometryButton(Component component) {
        Object object;
        Object[] objectArray = new Image[6];
        try {
            int n = 0;
            while (n < objectArray.length) {
                objectArray[n] = ImageHelper.createImage(20, 20);
                object = ((Image)objectArray[n]).getGraphics();
                if (this.geometryIcons != null) {
                    ((Graphics)object).drawImage(this.geometryIcons, 0, 0, 20, 20, 20 * n, 0, 20 * n + 20, 20, this.backgroundColor, null);
                } else {
                    ((Graphics)object).setColor(Color.black);
                    ((Graphics)object).drawLine(2, 2, 18, 18);
                    ((Graphics)object).drawLine(2, 18, 18, 2);
                }
                ++n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = new JStateButton("geometry", (Image[])objectArray, objectArray, this.helper, "normal, Manhattan, other geometry");
        ((JStateButton)object).setState(0);
        return object;
    }

    public JNumericStateButton createRoundRectButton(Component component) {
        int[] nArray = new int[]{0, 1, 2, 3, 4, 5, 6, 8, 10, 15};
        JNumericStateButton jNumericStateButton = new JNumericStateButton(component, "rounded rectangle corner radius (mm)", this.helper, "rounded rectangle corner radius (mm)");
        jNumericStateButton.setSteps(nArray);
        jNumericStateButton.setState(4);
        return jNumericStateButton;
    }

    public JNumericStateButton createDepthButton(Component component) {
        JNumericStateButton jNumericStateButton = new JNumericStateButton(component, "Set layer", this.helper, "Set layer (depth) [0..999]");
        jNumericStateButton.setMinValue(0);
        jNumericStateButton.setMaxValue(999);
        jNumericStateButton.setState(100);
        return jNumericStateButton;
    }

    public JTextField createDashLengthField(Component component) {
        JTextField jTextField = new JTextField("  4.0", 6);
        jTextField.setToolTipText("dash length [1/80 inch]");
        return jTextField;
    }

    public JStateButton createSnapModeButton(Component component) {
        Object[] objectArray = new Image[]{this.iconImages[76], this.iconImages[77], this.iconImages[78], this.iconImages[79]};
        JStateButton jStateButton = new JStateButton("snap grid spacing", (Image[])objectArray, objectArray, this.helper, "snap grid spacing / point position");
        jStateButton.setState(1);
        return jStateButton;
    }

    public JStateButton createObjectAlignXButton(Component component) {
        Object[] objectArray = new Image[]{this.iconImages[107], this.iconImages[104], this.iconImages[105], this.iconImages[106]};
        JStateButton jStateButton = new JStateButton("object x alignment", (Image[])objectArray, objectArray, this.helper, "Set object x alignment (left, center, right, none)");
        return jStateButton;
    }

    public JStateButton createObjectAlignYButton(Component component) {
        Object[] objectArray = new Image[]{this.iconImages[111], this.iconImages[108], this.iconImages[109], this.iconImages[110]};
        JStateButton jStateButton = new JStateButton("object y alignment", (Image[])objectArray, objectArray, this.helper, "Set object y alignment (top, center, bottom, none)");
        return jStateButton;
    }

    public JNumericStateButton createRotationButton(Component component) {
        JNumericStateButton jNumericStateButton = new JNumericStateButton(component, "Set rotation angle", this.helper, "Set rotation angle (degrees)");
        int[] nArray = new int[]{0, 15, 30, 45, 60, 75, 90, 135, 180, 225, 270, 315, 360};
        jNumericStateButton.setSteps(nArray);
        jNumericStateButton.setState(0);
        return jNumericStateButton;
    }

    public JComboBox createLandscapePortraitChoice(Component component) {
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.setToolTipText("select paper orientation");
        jComboBox.addItem("Landscape");
        jComboBox.addItem("Portrait");
        return jComboBox;
    }

    public JComboBox createCenterFlushLeftChoice(Component component) {
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.setToolTipText("select paper justification");
        jComboBox.addItem("Flush Left");
        jComboBox.addItem("Center");
        return jComboBox;
    }

    public JStateButton createUpdateMaskButton(Component component, String string, String string2) {
        Object[] objectArray = new Image[]{ImageHelper.createImage(1, 20)};
        Graphics graphics = objectArray[0].getGraphics();
        graphics.setColor(this.backgroundColor);
        graphics.drawLine(0, 0, 0, 20);
        JStateButton jStateButton = new JStateButton(string, (Image[])objectArray, objectArray, this.helper, string2);
        return jStateButton;
    }

    public JPanel buildPanel(Component component) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 0, 2));
        this.updateModeButton = this.createUpdateModeButton(component);
        this.snapModeButton = this.createSnapModeButton(component);
        this.lineStyleButton = this.createLineStyleButton(component);
        this.lineWidthButton = this.createLineWidthButton(component);
        this.lineColorButton = this.createLineColorButton(component);
        this.geometryButton = this.createGeometryButton(component);
        this.arrowModeButton = this.createArrowModeButton(component);
        this.arrowStyleButton = this.createArrowStyleButton(component);
        this.dashLengthField = this.createDashLengthField(component);
        this.fillColorButton = this.createFillColorButton(component);
        this.fillStyleButton = this.createFillStyleButton(component);
        this.fillPatternButton = this.createFillPatternButton(component);
        this.fontSelectButton = this.createFontSelectButton(component);
        this.fontSizeButton = this.createFontSizeButton(component);
        this.textAlignButton = this.createTextAlignButton(component);
        this.fontFlagChoice = this.createFontFlagChoice(component);
        this.fontFlagButton = this.createFontFlagButton(component);
        this.smartLinksButton = this.createSmartLinksButton(component);
        this.objectAlignXButton = this.createObjectAlignXButton(component);
        this.objectAlignYButton = this.createObjectAlignYButton(component);
        this.depthButton = this.createDepthButton(component);
        this.roundRectButton = this.createRoundRectButton(component);
        this.rotationAngleButton = this.createRotationButton(component);
        this.landscapePortraitChoice = this.createLandscapePortraitChoice(component);
        this.centerFlushLeftChoice = this.createCenterFlushLeftChoice(component);
        this.dbg("-I- components ok, building panel...");
        jPanel.add(this.updateModeButton);
        jPanel.add(this.snapModeButton);
        jPanel.add(this.lineStyleButton);
        jPanel.add(this.lineWidthButton);
        jPanel.add(this.lineColorButton);
        jPanel.add(this.geometryButton);
        jPanel.add(this.arrowModeButton);
        jPanel.add(this.arrowStyleButton);
        jPanel.add(this.fillColorButton);
        jPanel.add(this.fillStyleButton);
        jPanel.add(this.fillPatternButton);
        jPanel.add(this.textAlignButton);
        jPanel.add(this.fontSelectButton);
        jPanel.add(this.fontSizeButton);
        jPanel.add(this.fontFlagButton);
        jPanel.add(this.depthButton);
        jPanel.add(this.roundRectButton);
        jPanel.add(this.objectAlignXButton);
        jPanel.add(this.objectAlignYButton);
        jPanel.add(this.rotationAngleButton);
        this.dbg("-I- initialization ok.");
        return jPanel;
    }

    public int getObjectAlignXMode() {
        return this.objectAlignXButton.getState();
    }

    public int getObjectAlignYMode() {
        return this.objectAlignYButton.getState();
    }

    public int getSmartLinksMode() {
        return this.smartLinksButton.getState();
    }

    public int getGeometryMode() {
        return this.geometryButton.getState();
    }

    public FigAttribs getValues(FigAttribs figAttribs) {
        this.dbg("-I- JAttribsControlsFactory.getValues()...");
        if (figAttribs == null) {
            figAttribs = new FigAttribs();
        }
        this.setSnapMode(figAttribs, this.snapModeButton);
        this.setLineStyle(figAttribs, this.lineStyleButton);
        this.setLineWidth(figAttribs, this.lineWidthButton);
        this.setLineColor(figAttribs, this.lineColorButton);
        this.setArrowMode(figAttribs, this.arrowModeButton);
        this.setArrowStyle(figAttribs, this.arrowStyleButton);
        this.setFillColor(figAttribs, this.fillColorButton);
        this.setFillPattern(figAttribs, this.fillPatternButton);
        this.selectFont(figAttribs, this.fontSelectButton);
        this.setFontSize(figAttribs, this.fontSizeButton);
        this.setFontFlags(figAttribs, this.fontFlagButton);
        this.setTextAlignment(figAttribs, this.textAlignButton);
        this.setCornerRadius(figAttribs, this.roundRectButton);
        this.setDepth(figAttribs, this.depthButton);
        this.setDashLength(figAttribs, this.dashLengthField);
        this.setLandscapeMode(figAttribs, this.landscapePortraitChoice);
        this.setJustificationMode(figAttribs, this.centerFlushLeftChoice);
        this.setRotationAngle(figAttribs, this.rotationAngleButton);
        return figAttribs;
    }

    public void setDepth(FigAttribs figAttribs, JNumericStateButton jNumericStateButton) {
        figAttribs.currentLayer = jNumericStateButton.getState();
    }

    public void setDashLength(FigAttribs figAttribs, JTextField jTextField) {
        double d = 4.0;
        try {
            d = Double.valueOf(jTextField.getText().trim());
            if (d <= 0.0) {
                d = 1.0;
            }
            if (d >= 30.0) {
                d = 30.0;
            }
        }
        catch (NumberFormatException numberFormatException) {
            JAttribsControlsFactory.msg("-E- Illegal dash length value. Resetting to default 4.0");
            d = 4.0;
        }
        jTextField.setText(new Format("%5.2f").form(d));
        figAttribs.dashLength = 30.0 * d;
    }

    public void setLineWidth(FigAttribs figAttribs, JStateButton jStateButton) {
        figAttribs.lineWidth = 30 * jStateButton.getState();
        this.dbg("-I- setLineWidth= " + figAttribs.lineWidth + " corresponding to [mm] " + figAttribs.lineWidth / 1920.0);
    }

    public void setLineStyle(FigAttribs figAttribs, JStateButton jStateButton) {
        int n = jStateButton.getState();
        if (n == 0) {
            figAttribs.lineStyle = 0;
        } else if (n == 1) {
            figAttribs.lineStyle = 1;
        } else if (n == 2) {
            figAttribs.lineStyle = 2;
        } else if (n == 3) {
            figAttribs.lineStyle = 3;
        } else if (n == 4) {
            figAttribs.lineStyle = 4;
        } else if (n == 5) {
            figAttribs.lineStyle = 5;
        } else {
            JAttribsControlsFactory.msg("-E- setLineStyle internal error,  illegal lineStyle value: " + n);
            figAttribs.lineStyle = 0;
        }
    }

    public void setCornerRadius(FigAttribs figAttribs, JNumericStateButton jNumericStateButton) {
        figAttribs.cornerRadius = 96 * jNumericStateButton.getState();
        this.dbg("-I- cornerRadius= " + figAttribs.cornerRadius);
    }

    public void setLineColor(FigAttribs figAttribs, JColorButton jColorButton) {
        figAttribs.lineColor = jColorButton.getColor();
        figAttribs.fig_line_color = jColorButton.getColorIndex();
    }

    public void setFillColor(FigAttribs figAttribs, JColorButton jColorButton) {
        figAttribs.fillColor = jColorButton.getColor();
        figAttribs.fig_fill_color = jColorButton.getColorIndex();
    }

    public void setFillPattern(FigAttribs figAttribs, JFillPatternButton jFillPatternButton) {
        block9: {
            figAttribs.fillStyle = jFillPatternButton.getFillStyle();
            figAttribs.fig_area_fill = jFillPatternButton.getFigAreaFill();
            if (figAttribs.fillStyle != 2) break block9;
            int n = figAttribs.fig_area_fill;
            if (Color.white.equals(figAttribs.fillColor)) {
                if (n >= 20) {
                    figAttribs.fig_area_fill = n = 20;
                }
                figAttribs.fillColor = this.colorCache.get(figAttribs.fig_fill_color, n);
            } else if (figAttribs.fig_fill_color == 0) {
                if (n <= 20) {
                    n = 20;
                    figAttribs.fig_area_fill = 20;
                } else if (n <= 40) {
                    figAttribs.fig_area_fill = 40 - n;
                    n = 40 - n;
                } else {
                    System.err.println("-E- JAttribsControlsFactory: setFillPattern internalblack color, area fill=" + n);
                    n = 20;
                    figAttribs.fig_area_fill = 20;
                }
                figAttribs.fillColor = this.colorCache.get(figAttribs.fig_fill_color, n);
            } else {
                figAttribs.fillColor = this.colorCache.get(figAttribs.fig_fill_color, n);
            }
        }
    }

    public void setFillStyleOld(FigAttribs figAttribs, JStateButton jStateButton) {
        int n = jStateButton.getState();
        if (n == 0) {
            figAttribs.fillStyle = 1;
            figAttribs.fig_area_fill = -1;
        } else if (n == 1) {
            figAttribs.fillStyle = 2;
            figAttribs.fig_area_fill = 20;
        } else if (n == 2) {
            figAttribs.fillStyle = 3;
            figAttribs.fig_area_fill = -1;
        } else {
            JAttribsControlsFactory.msg("-E- internal error, illegal fillStyle value: " + n);
            figAttribs.fillStyle = 1;
        }
    }

    public void setArrowStyle(FigAttribs figAttribs, JStateButton jStateButton) {
        int n;
        int n2 = jStateButton.getState();
        if (n2 == 0) {
            n = 2;
        } else if (n2 == 1) {
            n = 4;
        } else if (n2 == 2) {
            n = 5;
        } else if (n2 == 3) {
            n = 6;
        } else if (n2 == 4) {
            n = 7;
        } else if (n2 == 5) {
            n = 8;
        } else if (n2 == 6) {
            n = 9;
        } else if (n2 == 7) {
            n = 11;
        } else {
            JAttribsControlsFactory.msg("-E- internal error, illegal arrowStyle value: " + n2);
            n = 2;
        }
        figAttribs.arrow_f_Style = n;
        figAttribs.arrow_b_Style = n;
    }

    public void setFArrowWidth(FigAttribs figAttribs, JTextField jTextField) {
        try {
            figAttribs.arrow_f_Width = 96.0 * Double.valueOf(jTextField.getText().trim());
        }
        catch (Exception exception) {
            figAttribs.arrow_f_Width = 115.19999999999999;
            jTextField.setText("1.2");
        }
    }

    public void setFArrowLength(FigAttribs figAttribs, JTextField jTextField) {
        try {
            figAttribs.arrow_f_Length = 96.0 * Double.valueOf(jTextField.getText().trim());
        }
        catch (Exception exception) {
            figAttribs.arrow_f_Length = 288.0;
            jTextField.setText("3.0");
        }
    }

    public void setFArrowThickness(FigAttribs figAttribs, JTextField jTextField) {
        try {
            figAttribs.arrow_f_Thickness = 30.0 * Double.valueOf(jTextField.getText().trim());
        }
        catch (Exception exception) {
            figAttribs.arrow_f_Thickness = 30.0;
            jTextField.setText("1.0");
        }
    }

    public void setBArrowWidth(FigAttribs figAttribs, JTextField jTextField) {
        try {
            figAttribs.arrow_b_Width = 96.0 * Double.valueOf(jTextField.getText().trim());
        }
        catch (Exception exception) {
            figAttribs.arrow_b_Width = 115.19999999999999;
            jTextField.setText("1.2");
        }
    }

    public void setBArrowLength(FigAttribs figAttribs, JTextField jTextField) {
        try {
            figAttribs.arrow_b_Length = 96.0 * Double.valueOf(jTextField.getText().trim());
        }
        catch (Exception exception) {
            figAttribs.arrow_b_Length = 288.0;
            jTextField.setText("3.0");
        }
    }

    public void setBArrowThickness(FigAttribs figAttribs, JTextField jTextField) {
        try {
            figAttribs.arrow_b_Thickness = 30.0 * Double.valueOf(jTextField.getText().trim());
        }
        catch (Exception exception) {
            figAttribs.arrow_b_Thickness = 30.0;
            jTextField.setText("1.0");
        }
    }

    public void setArrowMode(FigAttribs figAttribs, JStateButton jStateButton) {
        int n = jStateButton.getState();
        if (n == 0) {
            figAttribs.arrowMode = 0;
        } else if (n == 1) {
            figAttribs.arrowMode = 1;
        } else if (n == 2) {
            figAttribs.arrowMode = 2;
        } else if (n == 3) {
            figAttribs.arrowMode = 3;
        } else {
            JAttribsControlsFactory.msg("-E- internal error, illegal arrowMode value: " + n);
            figAttribs.arrowMode = 0;
        }
    }

    public void setTextAlignment(FigAttribs figAttribs, JStateButton jStateButton) {
        int n = jStateButton.getState();
        if (n == 0) {
            figAttribs.textAlign = 1;
        } else if (n == 1) {
            figAttribs.textAlign = 2;
        } else if (n == 2) {
            figAttribs.textAlign = 3;
        } else {
            JAttribsControlsFactory.msg("-E- internal error, illegal textAlign value: " + n);
            figAttribs.textAlign = 1;
        }
    }

    public void setFontSize(FigAttribs figAttribs, JNumericStateButton jNumericStateButton) {
        figAttribs.fontSize = jNumericStateButton.getState();
        if (this.debug) {
            JAttribsControlsFactory.msg("-I- fontSize=" + figAttribs.fontSize);
        }
    }

    public void setFontFlags(FigAttribs figAttribs, JStateButton jStateButton) {
        int n = jStateButton.getState();
        if (n == 0) {
            figAttribs.fig_font_flags &= 0xFFFFFFFD;
        }
        if (n == 1) {
            figAttribs.fig_font_flags |= 2;
        }
    }

    public void setFontFlags(FigAttribs figAttribs, JComboBox jComboBox) {
        String string = (String)jComboBox.getSelectedItem();
        figAttribs.fig_font_flags = string.equals("special") ? (figAttribs.fig_font_flags |= 2) : (figAttribs.fig_font_flags &= 0xFFFFFFFD);
    }

    public void selectFont(FigAttribs figAttribs, JFontButton jFontButton) {
        figAttribs.fig_font = Math.max(0, jFontButton.getState());
    }

    public void setSnapMode(FigAttribs figAttribs, JStateButton jStateButton) {
        int n = jStateButton.getState();
        if (n == 0) {
            int n2 = 2;
        } else if (n == 1) {
            int n3 = 3;
        } else if (n == 2) {
            int n4 = 4;
        } else if (n == 3) {
            boolean bl = true;
        } else {
            JAttribsControlsFactory.msg("-E- internal error: illegal snapMode value " + n);
            int n5 = 4;
        }
    }

    public void setLandscapeMode(FigAttribs figAttribs, JComboBox jComboBox) {
        if ("Landscape".equals(jComboBox.getSelectedItem())) {
            figAttribs.setFigOrientation(0);
        } else {
            figAttribs.setFigOrientation(1);
        }
    }

    public void setJustificationMode(FigAttribs figAttribs, JComboBox jComboBox) {
        if ("Center".equals(jComboBox.getSelectedItem())) {
            figAttribs.setFigJustification(0);
        } else {
            figAttribs.setFigJustification(1);
        }
    }

    public void setRotationAngle(FigAttribs figAttribs, JNumericStateButton jNumericStateButton) {
        figAttribs.fig_angle = (double)jNumericStateButton.getState() * Math.PI / 180.0;
    }

    public void showValues(FigAttribs figAttribs) {
        this.showLineStyle(figAttribs, this.lineStyleButton);
        this.showLineWidth(figAttribs, this.lineWidthButton);
        this.showLineColor(figAttribs, this.lineColorButton);
        this.showArrowMode(figAttribs, this.arrowModeButton);
        this.showArrowStyle(figAttribs, this.arrowStyleButton);
        this.showFillColor(figAttribs, this.fillColorButton);
        this.showFillPattern(figAttribs, this.fillPatternButton);
        this.showFontName(figAttribs, this.fontSelectButton);
        this.showFontSize(figAttribs, this.fontSizeButton);
        this.showFontFlags(figAttribs, this.fontFlagButton);
        this.showTextAlignment(figAttribs, this.textAlignButton);
        this.showDepth(figAttribs, this.depthButton);
        this.showCornerRadius(figAttribs, this.roundRectButton);
        this.showRotationAngle(figAttribs, this.rotationAngleButton);
    }

    public void showDepth(FigAttribs figAttribs, JNumericStateButton jNumericStateButton) {
        jNumericStateButton.setState(figAttribs.currentLayer);
    }

    public void showDashLength(FigAttribs figAttribs, JTextField jTextField) {
        jTextField.setText(new Format("%5.2f").form(figAttribs.dashLength / 30.0));
    }

    public void showLineWidth(FigAttribs figAttribs, JStateButton jStateButton) {
        int n = (int)(figAttribs.lineWidth / 30.0);
        if (n > 8) {
            n = 8;
        }
        if (n < 0) {
            n = 0;
        }
        jStateButton.setState(n);
        this.dbg("-#- showLineWidth, tmp " + figAttribs.lineWidth + " " + n);
    }

    public void showLineStyle(FigAttribs figAttribs, JStateButton jStateButton) {
        switch (figAttribs.lineStyle) {
            case 0: {
                jStateButton.setState(0);
                break;
            }
            case 1: {
                jStateButton.setState(1);
                break;
            }
            case 2: {
                jStateButton.setState(2);
                break;
            }
            case 3: {
                jStateButton.setState(3);
                break;
            }
            case 4: {
                jStateButton.setState(4);
                break;
            }
            case 5: {
                jStateButton.setState(5);
                break;
            }
            default: {
                jStateButton.setState(0);
            }
        }
    }

    public void showLineColor(FigAttribs figAttribs, JColorButton jColorButton) {
        if (figAttribs.lineColor != null) {
            jColorButton.selectColor(figAttribs.lineColor);
        } else {
            jColorButton.selectColor(Color.black);
        }
    }

    public void showFillPattern(FigAttribs figAttribs, JFillPatternButton jFillPatternButton) {
        if (figAttribs.fig_fill_color == 0) {
            int n = figAttribs.fig_area_fill;
            if (n == -1) {
                jFillPatternButton.setFigAreaFill(-1);
            } else if (n > 40) {
                jFillPatternButton.setFigAreaFill(n);
            } else if (n > 20) {
                jFillPatternButton.setFigAreaFill(20);
            } else {
                jFillPatternButton.setFigAreaFill(40 - n);
            }
        } else {
            jFillPatternButton.setFigAreaFill(figAttribs.fig_area_fill);
        }
    }

    public void showFillStyle(FigAttribs figAttribs, JStateButton jStateButton) {
        switch (figAttribs.fillStyle) {
            case 1: {
                jStateButton.setState(0);
                break;
            }
            case 2: {
                jStateButton.setState(1);
                break;
            }
            case 3: {
                jStateButton.setState(2);
                break;
            }
            default: {
                jStateButton.setState(0);
                break;
            }
        }
    }

    public void showFillColor(FigAttribs figAttribs, JColorButton jColorButton) {
        jColorButton.selectColor(figAttribs.fig_fill_color);
    }

    public void showArrowMode(FigAttribs figAttribs, JStateButton jStateButton) {
        switch (figAttribs.arrowMode) {
            case 0: {
                jStateButton.setState(0);
                break;
            }
            case 1: {
                jStateButton.setState(1);
                break;
            }
            case 2: {
                jStateButton.setState(2);
                break;
            }
            case 3: {
                jStateButton.setState(3);
                break;
            }
            default: {
                jStateButton.setState(0);
                break;
            }
        }
    }

    public void showArrowStyle(FigAttribs figAttribs, JStateButton jStateButton) {
        switch (figAttribs.arrow_f_Style) {
            case 2: {
                jStateButton.setState(0);
                break;
            }
            case 4: {
                jStateButton.setState(1);
                break;
            }
            case 5: {
                jStateButton.setState(2);
                break;
            }
            case 6: {
                jStateButton.setState(3);
                break;
            }
            case 7: {
                jStateButton.setState(4);
                break;
            }
            case 8: {
                jStateButton.setState(5);
                break;
            }
            case 9: {
                jStateButton.setState(6);
                break;
            }
            case 11: {
                jStateButton.setState(7);
                break;
            }
            default: {
                jStateButton.setState(0);
                break;
            }
        }
    }

    public void showFArrowWidth(FigAttribs figAttribs, JTextField jTextField) {
        jTextField.setText("" + this.scaleArrow(figAttribs.arrow_f_Width));
    }

    public void showFArrowLength(FigAttribs figAttribs, JTextField jTextField) {
        jTextField.setText("" + this.scaleArrow(figAttribs.arrow_f_Length));
    }

    public void showBArrowWidth(FigAttribs figAttribs, JTextField jTextField) {
        jTextField.setText("" + this.scaleArrow(figAttribs.arrow_b_Width));
    }

    public void showBArrowLength(FigAttribs figAttribs, JTextField jTextField) {
        jTextField.setText("" + this.scaleArrow(figAttribs.arrow_b_Length));
    }

    public void showFArrowThickness(FigAttribs figAttribs, JTextField jTextField) {
        jTextField.setText("" + this.scaleArrowThickness(figAttribs.arrow_f_Thickness));
    }

    public void showBArrowThickness(FigAttribs figAttribs, JTextField jTextField) {
        jTextField.setText("" + this.scaleArrowThickness(figAttribs.arrow_b_Thickness));
    }

    private String scaleArrow(double d) {
        return new Format("%5.2f").form(d / 96.0);
    }

    private String scaleArrowThickness(double d) {
        return new Format("%5.2f").form(d / 30.0);
    }

    public void showTextAlignment(FigAttribs figAttribs, JStateButton jStateButton) {
        switch (figAttribs.textAlign) {
            case 1: {
                jStateButton.setState(0);
                break;
            }
            case 2: {
                jStateButton.setState(1);
                break;
            }
            case 3: {
                jStateButton.setState(2);
                break;
            }
            default: {
                jStateButton.setState(0);
                break;
            }
        }
    }

    public void showFontSize(FigAttribs figAttribs, JNumericStateButton jNumericStateButton) {
        jNumericStateButton.setState(figAttribs.fontSize);
    }

    public void showFontFlags(FigAttribs figAttribs, JComboBox jComboBox) {
        if ((figAttribs.fig_font_flags & 2) > 0) {
            jComboBox.setSelectedItem("special");
        } else {
            jComboBox.setSelectedItem("normal");
        }
    }

    public void showFontFlags(FigAttribs figAttribs, JStateButton jStateButton) {
        if ((figAttribs.fig_font_flags & 2) > 0) {
            jStateButton.setState(1);
        } else {
            jStateButton.setState(0);
        }
    }

    public void showCornerRadius(FigAttribs figAttribs, JNumericStateButton jNumericStateButton) {
        jNumericStateButton.setState(figAttribs.cornerRadius / 96);
    }

    public void showFontName(FigAttribs figAttribs, JFontButton jFontButton) {
        jFontButton.setState(Math.max(0, figAttribs.fig_font));
    }

    public void showLandscapeMode(FigAttribs figAttribs, JComboBox jComboBox) {
        if (figAttribs.getFigOrientation() == 0) {
            jComboBox.setSelectedItem("Landscape");
        } else {
            jComboBox.setSelectedItem("Portrait");
        }
    }

    public void showJustificationMode(FigAttribs figAttribs, JComboBox jComboBox) {
        if (figAttribs.getFigJustification() == 0) {
            jComboBox.setSelectedItem("Center");
        } else {
            jComboBox.setSelectedItem("Flush Left");
        }
    }

    public void showRotationAngle(FigAttribs figAttribs, JNumericStateButton jNumericStateButton) {
        jNumericStateButton.setState((int)(figAttribs.fig_angle * 180.0 / Math.PI));
    }

    public void setUpdateMode(boolean bl) {
        this.snapModeButton.setUpdateMode(bl);
        this.lineStyleButton.setUpdateMode(bl);
        this.lineWidthButton.setUpdateMode(bl);
        this.lineColorButton.setUpdateMode(bl);
        this.arrowModeButton.setUpdateMode(bl);
        this.arrowStyleButton.setUpdateMode(bl);
        this.fillPatternButton.setUpdateMode(bl);
        this.fillColorButton.setUpdateMode(bl);
        this.fontSelectButton.setUpdateMode(bl);
        this.fontSizeButton.setUpdateMode(bl);
        this.textAlignButton.setUpdateMode(bl);
        this.fontFlagButton.setUpdateMode(bl);
        this.roundRectButton.setUpdateMode(bl);
    }

    public void setUpdateStatusAll() {
        this.snapModeButton.setUpdateStatus(true);
        this.lineStyleButton.setUpdateStatus(true);
        this.lineWidthButton.setUpdateStatus(true);
        this.lineColorButton.setUpdateStatus(true);
        this.arrowModeButton.setUpdateStatus(true);
        this.arrowStyleButton.setUpdateStatus(true);
        this.fillColorButton.setUpdateStatus(true);
        this.fillPatternButton.setUpdateStatus(true);
        this.fontSelectButton.setUpdateStatus(true);
        this.fontSizeButton.setUpdateStatus(true);
        this.textAlignButton.setUpdateStatus(true);
        this.fontFlagButton.setUpdateMode(true);
        this.roundRectButton.setUpdateStatus(true);
    }

    public void setUpdateStatusNone() {
        this.snapModeButton.setUpdateStatus(false);
        this.lineStyleButton.setUpdateStatus(false);
        this.lineWidthButton.setUpdateStatus(false);
        this.lineColorButton.setUpdateStatus(false);
        this.arrowModeButton.setUpdateStatus(false);
        this.arrowStyleButton.setUpdateStatus(false);
        this.fontSelectButton.setUpdateStatus(false);
        this.fontSizeButton.setUpdateStatus(false);
        this.fillColorButton.setUpdateStatus(false);
        this.fillPatternButton.setUpdateStatus(false);
        this.textAlignButton.setUpdateStatus(false);
        this.fontFlagButton.setUpdateMode(false);
        this.roundRectButton.setUpdateStatus(false);
    }

    public void invertUpdateStatus() {
        this.snapModeButton.setUpdateStatus(!this.snapModeButton.getUpdateStatus());
        this.lineStyleButton.setUpdateStatus(!this.lineStyleButton.getUpdateStatus());
        this.lineWidthButton.setUpdateStatus(!this.lineWidthButton.getUpdateStatus());
        this.lineColorButton.setUpdateStatus(!this.lineColorButton.getUpdateStatus());
        this.arrowModeButton.setUpdateStatus(!this.arrowModeButton.getUpdateStatus());
        this.arrowStyleButton.setUpdateStatus(!this.arrowStyleButton.getUpdateStatus());
        this.fillColorButton.setUpdateStatus(!this.fillColorButton.getUpdateStatus());
        this.fillPatternButton.setUpdateStatus(!this.fillPatternButton.getUpdateStatus());
        this.fontSelectButton.setUpdateStatus(!this.fontSelectButton.getUpdateStatus());
        this.fontSizeButton.setUpdateStatus(!this.fontSizeButton.getUpdateStatus());
        this.textAlignButton.setUpdateStatus(!this.textAlignButton.getUpdateStatus());
        this.fontFlagButton.setUpdateMode(!this.fontFlagButton.getUpdateStatus());
        this.roundRectButton.setUpdateStatus(!this.roundRectButton.getUpdateStatus());
    }

    public void addUpdateModeButtonListener(ActionListener actionListener) {
        this.updateModeButton.addActionListener(actionListener);
    }

    public void showCoords(Point[] pointArray, JTextArea jTextArea) {
        if (pointArray == null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < pointArray.length) {
            stringBuffer.append("(" + pointArray[n].x + ", " + pointArray[n].y + ")\n");
            ++n;
        }
        jTextArea.setText(stringBuffer.toString());
    }

    public void showCoords(Point[] pointArray, JTextField jTextField) {
        if (pointArray == null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < pointArray.length) {
            stringBuffer.append("(" + pointArray[n].x + ", " + pointArray[n].y + ")\n");
            ++n;
        }
        jTextField.setText(stringBuffer.toString());
    }

    public void showCoords(Point point, JTextField jTextField) {
        if (point == null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(" + point.x + ", " + point.y + ")");
        jTextField.setText(stringBuffer.toString());
    }

    public void retrievePoints(FigObject figObject, JTextArea jTextArea) {
        Point[] pointArray = this.getCoords(jTextArea.getText());
        if (pointArray != null) {
            figObject.setPoints(pointArray);
        }
    }

    public void retrievePoints(FigObject figObject, JTextField jTextField) {
        Point[] pointArray = this.getCoords(jTextField.getText());
        if (pointArray != null) {
            figObject.setPoints(pointArray);
        }
    }

    public Point[] getCoords(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        Vector<Point> vector = new Vector<Point>();
        String string2 = "";
        try {
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "(),\t ");
                Point point = new Point(0, 0);
                point.x = Integer.parseInt(stringTokenizer2.nextToken());
                point.y = Integer.parseInt(stringTokenizer2.nextToken());
                vector.addElement(point);
                this.dbg("---(" + point.x + ", " + point.y + ") ");
            }
            Point[] pointArray = new Point[vector.size()];
            int n = 0;
            while (n < pointArray.length) {
                pointArray[n] = (Point)vector.elementAt(n);
                ++n;
            }
            return pointArray;
        }
        catch (NoSuchElementException noSuchElementException) {
            JAttribsControlsFactory.msg("-E- Illegal number format in line" + string2);
            return null;
        }
        catch (NumberFormatException numberFormatException) {
            JAttribsControlsFactory.msg("-E- Illegal number format in line" + string2);
            return null;
        }
    }

    public static void msg(String string) {
        System.out.println(string);
    }

    public void dbg(String string) {
        if (this.debug) {
            JAttribsControlsFactory.msg(string);
        }
    }

    public static void main(String[] stringArray) {
        JAttribsControlsFactory.msg("-I- JAttribsControlsFactory self test...");
        Frame frame = new Frame("JAttribsControlsFactory self test");
        JStatusCanvas jStatusCanvas = new JStatusCanvas();
        frame.add("North", jStatusCanvas);
        frame.setFont(new Font("SansSerif", 0, 18));
        frame.setSize(new Dimension(600, 200));
        frame.show();
        ImageHelper.setVisibleParent(frame);
        JAttribsControlsFactory jAttribsControlsFactory = JAttribsControlsFactory.getJAttribsControlsFactory(null);
        jAttribsControlsFactory.setStatusMessage(jStatusCanvas);
        frame.add("South", jAttribsControlsFactory.buildPanel(frame));
        frame.setSize(new Dimension(600, 200));
    }

    private JAttribsControlsFactory() {
        this.dbg("-I- JAttribsControlsFactory()...");
        this.colorCache = ColorCache.getColorCache();
        this.allIcons = ImageHelper.loadResourceImage("/jfig/images/buttons.gif");
        this.iconImages = this.cropButtonImages();
        this.geometryIcons = ImageHelper.loadResourceImage("/jfig/images/manhattan.gif");
    }
}

