/*
 * Decompiled with CFR 0.152.
 */
package jfig.gui;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.net.URL;
import jfig.utils.ExceptionTracer;

public class ImageCanvas
extends Canvas {
    protected Image icon = null;
    protected int x_offset = 0;
    protected int y_offset = 0;

    public void paint(Graphics graphics) {
        if (this.icon != null) {
            graphics.drawImage(this.icon, this.x_offset, this.y_offset, this);
        }
    }

    public Dimension getMinimumSize() {
        if (this.icon != null) {
            return new Dimension(this.x_offset + this.icon.getWidth(this), this.y_offset + this.icon.getHeight(this));
        }
        return new Dimension(this.x_offset + 50, this.y_offset + 50);
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void setOffsets(int n, int n2) {
        this.x_offset = n;
        this.y_offset = n2;
        this.repaint();
    }

    public Image loadIcon(String string) {
        Image image = null;
        MediaTracker mediaTracker = new MediaTracker(this);
        try {
            URL uRL = this.getClass().getResource(string);
            image = Toolkit.getDefaultToolkit().getImage(uRL);
            mediaTracker.addImage(image, 0);
            mediaTracker.waitForAll();
        }
        catch (Exception exception) {
            ExceptionTracer.message("-E- ImageCanvas: couldn't load the icon from " + string);
        }
        return image;
    }

    public void setImage(Image image) {
        if (image == null) {
            return;
        }
        this.icon = image;
        this.repaint();
    }

    public ImageCanvas(String string) {
        this.icon = this.loadIcon(string);
        this.repaint();
    }

    public ImageCanvas(Image image) {
        this.icon = image;
        this.repaint();
    }
}

