/*
 * Decompiled with CFR 0.152.
 */
package jfig.commands;

import java.awt.Point;
import jfig.canvas.FigCanvas;
import jfig.canvas.FigCanvasEvent;
import jfig.commands.Command;
import jfig.commands.FigBasicEditor;
import jfig.objects.FigAttribs;
import jfig.objects.FigObject;
import jfig.utils.MouseMapper;

public class UpdateCommand
extends Command {
    protected FigObject object;
    protected FigAttribs savedAttribs;
    protected FigAttribs newAttribs;
    protected Point P1;
    protected int n_points;

    public FigObject[] getModifiedObjects() {
        FigObject[] figObjectArray = new FigObject[]{this.object};
        return figObjectArray;
    }

    public void execute() {
        if (this.object != null) {
            if (this.savedAttribs == null) {
                this.savedAttribs = this.object.getAttributes().getClone();
                this.newAttribs = this.editor.getCurrentAttribs().getClone();
            }
            this.object.update(this.newAttribs.getClone());
            if (this.savedAttribs.currentLayer != this.newAttribs.currentLayer) {
                this.editor.deleteFromObjectList(this.object);
                this.editor.insertIntoObjectList(this.object);
            }
            this.editor.getUndoStack().push(this);
            this.objectCanvas.doFullRedraw();
        }
    }

    public void undo() {
        if (this.object != null && this.savedAttribs != null) {
            this.object.setAttributes(this.savedAttribs.getClone());
            if (this.savedAttribs.currentLayer != this.newAttribs.currentLayer) {
                this.editor.deleteFromObjectList(this.object);
                this.editor.insertIntoObjectList(this.object);
            }
            this.objectCanvas.doFullRedraw();
        } else {
            this.message("-E- Internal error in UpdateCommand.undo():  either the object or the saved attribs are null.");
        }
    }

    public void cancel() {
        try {
            this.editor.call("doCancelUpdate", null);
        }
        catch (Exception exception) {
            this.message("-E- in UpdateCommand.cancel: " + exception);
        }
    }

    public void mousePressed(FigCanvasEvent figCanvasEvent) {
        Point point = figCanvasEvent.getWorldCoordinatePoint();
        Point point2 = figCanvasEvent.getScreenCoordinatePoint();
        if (MouseMapper.isMiddleClick(figCanvasEvent)) {
            FigObject figObject = this.editor.findObjectAt(point);
            if (figObject == null) {
                this.statusMessage("No object found at that position! L: update object, M: update settings");
                return;
            }
            this.editor.setCurrentAttribs(figObject.getAttributes().getClone());
        } else {
            this.object = this.editor.findObjectAt(point);
            if (this.object == null) {
                this.statusMessage("No object found at that position! L: update object, M: update settings");
                return;
            }
            this.execute();
            this.ready = true;
            this.notifyEditor();
        }
    }

    public String getDescription() {
        return "update attributes";
    }

    public String toString() {
        return "jfig.commands.UpdateCommand[]";
    }

    public UpdateCommand(FigBasicEditor figBasicEditor, FigCanvas figCanvas) {
        super(figBasicEditor, figCanvas);
        this.statusMessage("L: update object, M: update settings (pick up attributes)");
        figBasicEditor.showAllObjectCorners();
        figCanvas.changeRubberbandMode(1);
        this.n_points = 0;
        this.ready = false;
    }
}

