/*
 * Decompiled with CFR 0.152.
 */
package jfig.commands;

import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Stack;
import jfig.commands.Command;

public class UndoStack {
    private Stack undoStack = new Stack();
    private Stack redoStack = new Stack();
    private Object undoMI;
    private Object redoMI;
    private static /* synthetic */ Class class$Ljava$lang$String;

    public boolean hasChanges() {
        return !this.undoStack.empty();
    }

    public void push(Command command) {
        this.undoStack.push(command);
        this.updateMenuItems();
    }

    public void undo() {
        if (this.undoStack.empty()) {
            return;
        }
        Command command = (Command)this.undoStack.pop();
        this.redoStack.push(command);
        command.undo();
        this.updateMenuItems();
    }

    public void redo() {
        if (this.redoStack.empty()) {
            return;
        }
        Command command = (Command)this.redoStack.pop();
        command.execute();
        this.updateMenuItems();
    }

    public void setMenuItems(Object object, Object object2) {
        this.undoMI = object;
        this.redoMI = object2;
        this.updateMenuItems();
    }

    private void updateMenuItems() {
        String string;
        if (this.undoMI != null) {
            if (this.undoStack.empty()) {
                string = "Undo";
                this.setEnabled(this.undoMI, false);
            } else {
                string = "Undo [" + ((Command)this.undoStack.peek()).getDescription() + "]";
                this.setEnabled(this.undoMI, true);
            }
            this.setLabel(this.undoMI, string);
        }
        if (this.redoMI != null) {
            if (this.redoStack.empty()) {
                string = "Redo";
                this.setEnabled(this.redoMI, false);
            } else {
                string = "Redo [" + ((Command)this.redoStack.peek()).getDescription() + "]";
                this.setEnabled(this.redoMI, true);
            }
            this.setLabel(this.redoMI, string);
        }
    }

    private void setLabel(Object object, String string) {
        try {
            Class[] classArray = new Class[]{class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = UndoStack.class$("java.lang.String"))};
            Method method = object.getClass().getMethod("setLabel", classArray);
            if (method == null) {
                return;
            }
            Object[] objectArray = new Object[]{string};
            method.invoke(object, objectArray);
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace();
        }
    }

    private void setEnabled(Object object, boolean bl) {
        try {
            Class[] classArray = new Class[]{Boolean.TYPE};
            Method method = object.getClass().getMethod("setEnabled", classArray);
            if (method == null) {
                return;
            }
            Object[] objectArray = new Object[]{new Boolean(bl)};
            method.invoke(object, objectArray);
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace();
        }
    }

    public String toString() {
        String string = "UndoStack contents:\n";
        Enumeration enumeration = this.undoStack.elements();
        while (enumeration.hasMoreElements()) {
            string = string + "  " + enumeration.nextElement().toString() + "\n";
        }
        string = string + "RedoStack contents:\n";
        enumeration = this.redoStack.elements();
        while (enumeration.hasMoreElements()) {
            string = string + "  " + enumeration.nextElement().toString() + "\n";
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

