/*
 * Decompiled with CFR 0.152.
 */
package jfig.commands;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import jfig.canvas.FigCanvas;
import jfig.canvas.FigCanvasEvent;
import jfig.commands.Command;
import jfig.commands.FigBasicEditor;
import jfig.commands.SelectLibraryObjectDialog;
import jfig.gui.SelectFromLibraryDialog;
import jfig.objects.FigAttribs;
import jfig.objects.FigBbox;
import jfig.objects.FigCompound;
import jfig.objects.FigGlobalAttributes;
import jfig.objects.FigObject;
import jfig.objects.FigObjectList;
import jfig.objects.FigParser;
import jfig.utils.MouseMapper;
import jfig.utils.SetupManager;

public class SelectLibraryObjectCommand
extends Command {
    static SelectLibraryObjectDialog selectDialog = null;
    static Frame frame = null;
    static boolean hasPreselectedObject = false;
    private static int defaultFigVersion;
    private static String pageUnits;
    private static String pageJustification;
    private static String pageOrientation;
    private static String paperSize;
    private static String singleOrMultipleSheets;
    private static double exportMagnification;
    private static int transparentColorIndex;
    private static int fig_orientation;
    private static int fig_justification;
    private static int fig_units;
    private static int fig_resolution;
    private static int fig_origin;
    FigCompound buffer;
    Point startPoint;
    Point endPoint;

    public FigObject[] getModifiedObjects() {
        FigObject[] figObjectArray = new FigObject[]{this.buffer};
        return figObjectArray;
    }

    public void cancel() {
        this.hideSelectDialog();
    }

    public void showSelectDialog() {
        if (selectDialog == null) {
            try {
                frame = this.findParentFrame();
            }
            catch (Exception exception) {
                frame = new Frame("Dummy Frame");
                frame.setSize(new Dimension(100, 100));
            }
            try {
                Class<?> clazz = null;
                clazz = SetupManager.getBoolean("jfig.UseSwing", false) ? Class.forName("jfig.gui.JSelectFromLibraryDialog") : Class.forName("jfig.gui.SelectFromLibraryDialog");
                Constructor<?> constructor = clazz.getConstructors()[0];
                Object[] objectArray = new Object[]{frame};
                selectDialog = (SelectLibraryObjectDialog)constructor.newInstance(objectArray);
            }
            catch (Exception exception) {
                this.message("-E- internal in OpenCompoundcommand.createDialog: " + exception);
                exception.printStackTrace();
                selectDialog = new SelectFromLibraryDialog(frame);
            }
        }
        selectDialog.getDialog().show();
    }

    private Frame findParentFrame() {
        Component component = this.editor.getObjectCanvas().getComponent();
        do {
            if ((component = component.getParent()) == null || !(component instanceof Frame)) continue;
            return (Frame)component;
        } while (component != null);
        return new Frame("dummy frame");
    }

    public void setSelectionListener() {
        SelectLibraryObjectCommand selectLibraryObjectCommand = this;
        if (selectLibraryObjectCommand == null) {
            throw null;
        }
        selectDialog.setSelectionListener(new ActionListener(selectLibraryObjectCommand){
            private final /* synthetic */ SelectLibraryObjectCommand this$0;

            public void actionPerformed(ActionEvent actionEvent) {
                this.this$0.selectObject();
            }
            {
                this.this$0 = selectLibraryObjectCommand;
                this.constructor$0(selectLibraryObjectCommand);
            }

            private final void constructor$0(SelectLibraryObjectCommand selectLibraryObjectCommand) {
            }
        });
    }

    public void hideSelectDialog() {
        if (selectDialog != null && selectDialog.getDialog().isShowing()) {
            selectDialog.getDialog().setVisible(false);
        }
    }

    public void execute() {
        if (this.buffer != null) {
            int n = this.endPoint.x - this.startPoint.x;
            int n2 = this.endPoint.y - this.startPoint.y;
            this.buffer.move(n, n2);
            this.buffer.update_bbox();
            this.buffer.deselect();
            this.editor.insertIntoObjectList(this.buffer);
            this.editor.getUndoStack().push(this);
            this.objectCanvas.doFullRedraw();
            this.statusMessage("Ready. Please select a command");
        } else {
            System.err.println("-E- SLOC.execute: buffer is null?!");
        }
    }

    public void mousePressed(FigCanvasEvent figCanvasEvent) {
        Point point = figCanvasEvent.getWorldCoordinatePoint();
        Point point2 = figCanvasEvent.getScreenCoordinatePoint();
        if (MouseMapper.isRightClick(figCanvasEvent)) {
            this.buffer = null;
            this.ready = true;
            this.cancel();
            hasPreselectedObject = false;
            this.objectCanvas.changeRubberbandMode(1);
            this.objectCanvas.doFullRedraw();
            return;
        }
        if (MouseMapper.isMiddleClick(figCanvasEvent)) {
            this.buffer = null;
            this.ready = false;
            this.objectCanvas.changeRubberbandMode(1);
            this.objectCanvas.doFullRedraw();
            hasPreselectedObject = false;
            this.showSelectDialog();
            return;
        }
        this.endPoint = new Point(point.x, point.y);
        this.execute();
        this.objectCanvas.changeRubberbandMode(1);
        this.ready = true;
        hasPreselectedObject = true;
        this.notifyEditor();
    }

    public void selectObject() {
        Object object;
        Object object2;
        Object object3;
        this.hideSelectDialog();
        this.buffer = new FigCompound();
        this.buffer.setTrafo(this.objectCanvas.getTrafo());
        int n = 0;
        try {
            object3 = selectDialog.getSelectedObjectFilename();
            object2 = new BufferedInputStream(new FileInputStream((String)object3));
            object = new FigObjectList();
            FigParser figParser = new FigParser();
            FigGlobalAttributes figGlobalAttributes = new FigGlobalAttributes();
            figGlobalAttributes.extractGlobalAttributes(this.editor.getCurrentAttribs());
            figParser.parse_fig_file((InputStream)object2, true, false, this.editor.getCurrentAttribs(), this.objectCanvas.getTrafo(), (FigObjectList)object);
            ((BufferedInputStream)object2).close();
            Enumeration enumeration = ((FigObjectList)object).elements();
            while (enumeration.hasMoreElements()) {
                this.buffer.fastAddMember((FigObject)enumeration.nextElement());
                ++n;
            }
            figGlobalAttributes.restoreGlobalAttributes(this.editor.getCurrentAttribs());
        }
        catch (IOException iOException) {
            System.err.println("-E- internal error: " + iOException);
            iOException.printStackTrace();
        }
        if (n > 0) {
            this.buffer.update_bbox();
            object3 = this.buffer.getBbox();
            object2 = new Point(((FigBbox)object3).getXl(), ((FigBbox)object3).getYt());
            object = this.objectCanvas.getTrafo().getAnchor();
            this.startPoint = new Point(((Point)object).x, ((Point)object).y);
            this.buffer.move(((Point)object).x - ((Point)object2).x, ((Point)object).y - ((Point)object2).y);
            this.statusMessage("L: paste object),  M: select new object,  R: cancel");
            this.objectCanvas.setRubberbandBasePoint(new Point(0, 0));
            this.objectCanvas.changeRubberbandMode(5, this.objectCanvas.getTrafo(), this.buffer.getBbox());
            this.ready = false;
        } else {
            System.out.println("-E- internal: empty library object?!");
        }
    }

    public void saveGlobalAttributes() {
        defaultFigVersion = FigAttribs.defaultFigVersion;
        pageUnits = FigAttribs.pageUnits;
        pageJustification = FigAttribs.pageJustification;
        pageOrientation = FigAttribs.pageOrientation;
        paperSize = FigAttribs.paperSize;
        singleOrMultipleSheets = FigAttribs.singleOrMultipleSheets;
        exportMagnification = FigAttribs.exportMagnification;
        transparentColorIndex = FigAttribs.transparentColorIndex;
        fig_orientation = FigAttribs.fig_orientation;
        fig_justification = FigAttribs.fig_justification;
        fig_units = FigAttribs.fig_units;
        fig_resolution = FigAttribs.fig_resolution;
        fig_origin = FigAttribs.fig_origin;
    }

    public void restoreGlobalAttributes() {
        FigAttribs.defaultFigVersion = defaultFigVersion;
        FigAttribs.pageUnits = pageUnits;
        FigAttribs.pageJustification = pageJustification;
        FigAttribs.pageOrientation = pageOrientation;
        FigAttribs.paperSize = paperSize;
        FigAttribs.singleOrMultipleSheets = singleOrMultipleSheets;
        FigAttribs.exportMagnification = exportMagnification;
        FigAttribs.transparentColorIndex = transparentColorIndex;
        FigAttribs.fig_orientation = fig_orientation;
        FigAttribs.fig_justification = fig_justification;
        FigAttribs.fig_units = fig_units;
        FigAttribs.fig_resolution = fig_resolution;
        FigAttribs.fig_origin = fig_origin;
    }

    public void undo() {
        if (this.buffer != null) {
            this.editor.deleteFromObjectList(this.buffer);
            int n = this.endPoint.x - this.startPoint.x;
            int n2 = this.endPoint.y - this.startPoint.y;
            this.buffer.move(-n, -n2);
            this.buffer.update_bbox();
        }
        this.statusMessage("Undo select library object ready.");
        this.objectCanvas.doFullRedraw();
    }

    public String getDescription() {
        return "select library object";
    }

    public String toString() {
        return "jfig.commands.SelectLibraryObjectCommand[]";
    }

    public SelectLibraryObjectCommand(FigBasicEditor figBasicEditor, FigCanvas figCanvas) {
        super(figBasicEditor, figCanvas);
        this.statusMessage("Select library object... please wait.");
        if (!hasPreselectedObject) {
            this.showSelectDialog();
        } else {
            this.selectObject();
        }
        this.setSelectionListener();
        this.ready = false;
    }
}

