/*
 * Decompiled with CFR 0.152.
 */
package jfig.commands;

import java.awt.Point;
import jfig.canvas.FigCanvas;
import jfig.canvas.FigCanvasEvent;
import jfig.commands.Command;
import jfig.commands.FigBasicEditor;
import jfig.objects.FigAttribs;
import jfig.objects.FigBbox;
import jfig.objects.FigCompound;
import jfig.objects.FigObject;
import jfig.objects.FigText;
import jfig.utils.MouseMapper;

public class ScaleObjectCommand
extends Command {
    protected int n_points;
    protected FigObject object;
    protected FigAttribs oldAttribs;
    protected Point P1;
    protected Point P2;
    protected Point origin;
    protected Point[] oldPoints;
    protected double factor_x;
    protected double factor_y;
    protected boolean restricted = false;

    public FigObject[] getModifiedObjects() {
        FigObject[] figObjectArray = new FigObject[]{this.object};
        return figObjectArray;
    }

    public void execute() {
        if (this.object != null) {
            this.oldPoints = this.object.getPoints();
            this.oldAttribs = this.object.getAttributes().getClone();
            try {
                if (this.restricted) {
                    this.factor_x = this.factor_y = 1.0 * (double)(this.P2.x - this.origin.x) / (double)(this.P1.x - this.origin.x);
                } else {
                    this.factor_x = 1.0 * (double)(this.P2.x - this.origin.x) / (double)(this.P1.x - this.origin.x);
                    this.factor_y = 1.0 * (double)(this.P2.y - this.origin.y) / (double)(this.P1.y - this.origin.y);
                }
            }
            catch (Exception exception) {
                this.factor_x = 1.0;
                this.factor_y = 1.0;
            }
            this.object.scale(this.origin, this.factor_x, this.factor_y);
            this.editor.getUndoStack().push(this);
            this.objectCanvas.doFullRedraw();
        }
    }

    public void undo() {
        if (this.object != null) {
            if (this.object instanceof FigCompound || this.object instanceof FigText) {
                this.object.scale(this.origin, 1.0 / this.factor_x, 1.0 / this.factor_y);
            } else {
                this.object.setAttributes(this.oldAttribs.getClone());
                this.object.setPoints(this.oldPoints);
            }
            this.objectCanvas.doFullRedraw();
        }
    }

    public Point[] getScaledPoints(Point[] pointArray, Point point, Point point2, Point point3) {
        return null;
    }

    public void mousePressed(FigCanvasEvent figCanvasEvent) {
        Point point = figCanvasEvent.getWorldCoordinatePoint();
        Point point2 = figCanvasEvent.getScreenCoordinatePoint();
        Point point3 = new Point(0, 0);
        if (this.n_points == 0) {
            this.object = this.editor.findObjectAt(point);
            if (this.object == null) {
                this.statusMessage("Please click on the object to scale!L: around center, M: proportional, R: opposite corner");
                return;
            }
            this.P1 = point;
            this.oldPoints = this.object.getPoints();
            if (MouseMapper.isRightClick(figCanvasEvent)) {
                this.origin = this.object.getBbox().getOppositeCorner(point);
                point3 = this.objectCanvas.getTrafo().wc_to_screen(this.origin, point3);
                this.objectCanvas.setRubberbandBasePoint(point3);
                this.objectCanvas.changeRubberbandMode(4);
                this.restricted = false;
            } else if (MouseMapper.isMiddleClick(figCanvasEvent)) {
                this.origin = this.object.getBbox().getCenterPoint();
                FigBbox figBbox = this.object.getBbox();
                double d = 1.0 * (double)(figBbox.getYb() - figBbox.getYt()) / (double)(figBbox.getXr() - figBbox.getXl());
                point3 = this.objectCanvas.getTrafo().wc_to_screen(this.origin, point3);
                this.objectCanvas.setRubberbandBasePoint(point3);
                this.objectCanvas.setRubberbandAspect(d);
                this.objectCanvas.changeRubberbandMode(14);
                this.restricted = true;
            } else {
                this.origin = this.object.getBbox().getCenterPoint();
                point3 = this.objectCanvas.getTrafo().wc_to_screen(this.origin, point3);
                this.objectCanvas.setRubberbandBasePoint(point3);
                this.objectCanvas.changeRubberbandMode(11);
                this.restricted = false;
            }
            this.n_points = 1;
        } else {
            this.P2 = new Point(point);
            this.objectCanvas.changeRubberbandMode(1);
            this.execute();
            this.ready = true;
            this.notifyEditor();
        }
    }

    public String getDescription() {
        return "scale object";
    }

    public String toString() {
        return "jfig.commands.ScaleObjectCommand[]";
    }

    public ScaleObjectCommand(FigBasicEditor figBasicEditor, FigCanvas figCanvas) {
        super(figBasicEditor, figCanvas);
        this.statusMessage("Click on the object to scale! L: around center, M: proportional, R: opposite corner");
        figBasicEditor.showAllObjectCorners();
        figCanvas.changeRubberbandMode(1);
        this.n_points = 0;
        this.ready = false;
    }
}

