/*
 * Decompiled with CFR 0.152.
 */
package jfig.commands;

import java.awt.Point;
import java.awt.event.ActionEvent;
import jfig.canvas.FigCanvas;
import jfig.canvas.FigCanvasEvent;
import jfig.commands.Command;
import jfig.commands.FigBasicEditor;
import jfig.objects.FigObject;
import jfig.utils.MouseMapper;

public class RotateObjectCommand
extends Command {
    public static final boolean CW = true;
    public static final boolean CCW = false;
    static boolean clockwise = true;
    FigObject object = null;
    FigObject rotatedCopy = null;
    Point anchor = null;
    double angle = 0.0;

    public static void setDirection(boolean bl) {
        clockwise = bl;
    }

    public FigObject[] getModifiedObjects() {
        FigObject[] figObjectArray = new FigObject[]{this.object, this.rotatedCopy};
        return figObjectArray;
    }

    public void execute() {
        if (this.rotatedCopy != null) {
            if (this.rotatedCopy.canRotate(this.angle)) {
                try {
                    this.rotatedCopy.rotate(this.anchor, this.angle);
                    this.editor.insertIntoObjectList(this.rotatedCopy);
                    this.editor.getUndoStack().push(this);
                    this.objectCanvas.doFullRedraw();
                }
                catch (Throwable throwable) {
                    this.message("-E- in RotateObjectCommand.execute copy and rotate: " + throwable);
                    throwable.printStackTrace();
                    this.rotatedCopy = null;
                }
            }
        } else if (this.object != null) {
            if (this.object.canRotate(this.angle)) {
                try {
                    this.object.rotate(this.anchor, this.angle);
                    this.editor.getUndoStack().push(this);
                    this.objectCanvas.doFullRedraw();
                }
                catch (Throwable throwable) {
                    this.message("-E- in RotateObjectCommand.execute: " + throwable);
                }
            } else {
                this.statusMessage("-W- Cannot rotate that object (or illegal angle)!");
            }
        }
    }

    public void undo() {
        if (this.rotatedCopy != null) {
            try {
                this.rotatedCopy.rotate(this.anchor, -this.angle);
                this.editor.deleteFromObjectList(this.rotatedCopy);
                this.objectCanvas.doFullRedraw();
            }
            catch (Throwable throwable) {
                this.message("-E- in RotateObjectCommand.undo rotate and copy: " + throwable);
            }
        } else if (this.object != null) {
            try {
                this.object.rotate(this.anchor, -this.angle);
                this.objectCanvas.doFullRedraw();
            }
            catch (Throwable throwable) {
                this.message("-E- in RotateObjectCommand.undo: " + throwable);
            }
        }
    }

    public void mousePressed(FigCanvasEvent figCanvasEvent) {
        Point point = figCanvasEvent.getWorldCoordinatePoint();
        Point point2 = figCanvasEvent.getScreenCoordinatePoint();
        if (MouseMapper.isRightClick(figCanvasEvent)) {
            this.anchor = new Point(point.x, point.y);
        } else {
            if (MouseMapper.isMiddleClick(figCanvasEvent)) {
                if (this.anchor == null) {
                    this.anchor = new Point(point.x, point.y);
                }
                this.object = this.editor.findObjectAt(point);
                if (this.object != null) {
                    this.rotatedCopy = this.object.copy();
                    this.angle = this.editor.getCurrentAttribs().fig_angle;
                    if (!clockwise) {
                        this.angle = -this.angle;
                    }
                    this.execute();
                    this.ready = true;
                    this.notifyEditor();
                } else {
                    this.statusMessage("no object to copy and rotate at that position!");
                }
                return;
            }
            if (this.anchor == null) {
                this.anchor = new Point(point.x, point.y);
            }
            this.object = this.editor.findObjectAt(point);
            if (this.object != null) {
                this.angle = this.editor.getCurrentAttribs().fig_angle;
                if (!clockwise) {
                    this.angle = -this.angle;
                }
                this.execute();
                this.ready = true;
                this.notifyEditor();
            }
        }
    }

    public boolean isReady() {
        return this.ready;
    }

    public void notifyEditor() {
        if (this.editor == null) {
            return;
        }
        ActionEvent actionEvent = new ActionEvent(this, 1001, "Command is ready");
        this.editor.actionPerformed(actionEvent);
    }

    public String getDescription() {
        return "rotate object";
    }

    public String toString() {
        return "jfig.commands.RotateObjectCommand";
    }

    public RotateObjectCommand(FigBasicEditor figBasicEditor, FigCanvas figCanvas) {
        super(figBasicEditor, figCanvas);
        this.statusMessage("Click on the object to rotate! L: rotate M: copy+rotate R: set anchor");
        figBasicEditor.showAllObjectCorners();
        figCanvas.changeRubberbandMode(1);
        this.anchor = null;
        this.ready = false;
    }
}

