/*
 * Decompiled with CFR 0.152.
 */
package jfig.commands;

import java.awt.Point;
import jfig.canvas.FigCanvas;
import jfig.canvas.FigCanvasEvent;
import jfig.commands.Command;
import jfig.commands.FigBasicEditor;
import jfig.objects.FigBaseobject;
import jfig.objects.FigEllipse;
import jfig.objects.FigObject;
import jfig.objects.FigRectangle;
import jfig.objects.FigTrigger;

public class MovePointCommand
extends Command {
    protected int n_points;
    protected FigObject object;
    protected Point P1;
    protected Point P2;
    protected Point[] origPoints;

    public FigObject[] getModifiedObjects() {
        FigObject[] figObjectArray = new FigObject[]{this.object};
        return figObjectArray;
    }

    public void execute() {
        if (this.object != null) {
            this.origPoints = FigBaseobject.clonePoints(this.object.getPoints());
            this.object.movePoint(this.P1, this.P2);
            this.editor.getUndoStack().push(this);
            this.objectCanvas.doFullRedraw();
        }
    }

    public void undo() {
        if (this.object != null) {
            this.object.setPoints(this.origPoints);
            this.objectCanvas.doFullRedraw();
        }
    }

    public void mousePressed(FigCanvasEvent figCanvasEvent) {
        Point point = figCanvasEvent.getWorldCoordinatePoint();
        Point point2 = figCanvasEvent.getScreenCoordinatePoint();
        if (this.n_points == 0) {
            this.object = this.editor.findObjectAt(point);
            if (this.object == null) {
                this.statusMessage("Please click directly on the point to move!");
                return;
            }
            if (!this.object.supportsPointOps()) {
                this.statusMessage("Cannot move points on that object, sorry!");
                return;
            }
            Point point3 = this.object.getNearestPoint(point);
            Point[] pointArray = this.object.getMovePointNeighbors(point3);
            this.P1 = new Point(point3.x, point3.y);
            if (this.object instanceof FigRectangle || this.object instanceof FigEllipse || this.object instanceof FigTrigger) {
                point2 = this.objectCanvas.getTrafo().wc_to_screen(pointArray[0], point2);
                this.objectCanvas.setRubberbandBasePoint(point2);
                this.objectCanvas.changeRubberbandMode(4);
            } else if (pointArray[0] == null) {
                point2 = this.objectCanvas.getTrafo().wc_to_screen(pointArray[1], point2);
                this.objectCanvas.setRubberbandBasePoint(point2);
                this.objectCanvas.changeRubberbandMode(2);
            } else if (pointArray[1] == null) {
                point2 = this.objectCanvas.getTrafo().wc_to_screen(pointArray[0], point2);
                this.objectCanvas.setRubberbandBasePoint(point2);
                this.objectCanvas.changeRubberbandMode(2);
            } else {
                point2 = this.objectCanvas.getTrafo().wc_to_screen(pointArray[0], point2);
                this.objectCanvas.setRubberbandBasePoint(point2);
                point2 = this.objectCanvas.getTrafo().wc_to_screen(pointArray[1], point2);
                this.objectCanvas.setRubberbandBasePoint2(point2);
                this.objectCanvas.changeRubberbandMode(3);
            }
            this.n_points = 1;
        } else {
            this.P2 = new Point(point);
            this.objectCanvas.changeRubberbandMode(1);
            this.execute();
            this.ready = true;
            this.notifyEditor();
        }
    }

    public String getDescription() {
        return "move point";
    }

    public String toString() {
        return "jfig.commands.MovePointCommand[]";
    }

    public MovePointCommand(FigBasicEditor figBasicEditor, FigCanvas figCanvas) {
        super(figBasicEditor, figCanvas);
        this.statusMessage("Click on the object's point to move!");
        figBasicEditor.showAllObjectCorners();
        figCanvas.changeRubberbandMode(1);
        this.n_points = 0;
        this.ready = false;
    }
}

