/*
 * Decompiled with CFR 0.152.
 */
package jfig.commands;

import java.awt.Point;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Vector;
import jfig.canvas.FigCanvas;
import jfig.canvas.FigCanvasEvent;
import jfig.commands.Command;
import jfig.commands.FigBasicEditor;
import jfig.objects.FigBbox;
import jfig.objects.FigCompound;
import jfig.objects.FigObject;
import jfig.objects.FigPolyline;
import jfig.objects.FigRectangle;
import jfig.objects.FigText;
import jfig.utils.MouseMapper;

public class MoveObjectCommand
extends Command {
    public static final int SMART_LINKS_OFF = 0;
    public static final int SMART_LINKS_MOVE = 1;
    public static final int SMART_LINKS_SLIDE = 2;
    public static final int SMART_LINKS_MOVEALL = 3;
    protected int n_points;
    protected FigObject object;
    protected Point startPoint;
    protected Point endPoint;
    protected int dx;
    protected int dy;
    protected boolean restricted;
    protected int smartLinksMode = 0;

    public FigObject[] getModifiedObjects() {
        FigObject[] figObjectArray = new FigObject[]{this.object};
        return figObjectArray;
    }

    public void execute() {
        if (this.object != null) {
            this.dx = this.endPoint.x - this.startPoint.x;
            this.dy = this.endPoint.y - this.startPoint.y;
            if (this.restricted) {
                if (Math.abs(this.dx) > Math.abs(this.dy)) {
                    this.dy = 0;
                } else {
                    this.dx = 0;
                }
            }
            this.checkSmartLinksMove(this.object, this.dx, this.dy);
            this.object.move(this.dx, this.dy);
            this.object.deselect();
            this.editor.getUndoStack().push(this);
            this.objectCanvas.doFullRedraw();
        }
    }

    public void checkSmartLinksMove(FigObject figObject, int n, int n2) {
        Object object;
        Vector vector = this.getSmartMoveAnchorCandidates(figObject);
        if (vector.isEmpty()) {
            return;
        }
        if (this.smartLinksMode == 0) {
            return;
        }
        if (this.smartLinksMode == 2) {
            System.out.println("-W- smart links SLIDE mode not supported (yet)!");
            return;
        }
        Object object2 = this.editor.getObjects();
        while (object2.hasMoreElements()) {
            object = (FigObject)object2.nextElement();
            if (!(object instanceof FigPolyline)) continue;
            boolean bl = false;
            Point[] pointArray = object.getPoints();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements() && !bl) {
                FigBbox figBbox = (FigBbox)enumeration.nextElement();
                bl = this.checkMovePoint(figBbox, pointArray[pointArray.length - 1], n, n2);
                bl |= this.checkMovePoint(figBbox, pointArray[0], n, n2);
            }
            if (!bl) continue;
            object.setPoints(pointArray);
        }
        if (figObject instanceof FigRectangle) {
            object2 = figObject.getBbox();
            object = this.editor.getObjects();
            while (object.hasMoreElements()) {
                FigObject figObject2 = (FigObject)object.nextElement();
                if (!(figObject2 instanceof FigText) || !figObject2.getBbox().inside((FigBbox)object2)) continue;
                figObject2.move(n, n2);
            }
        }
    }

    public Vector getSmartMoveAnchorCandidates(FigObject figObject) {
        Vector vector = new Vector();
        MoveObjectCommand.buildSmartMoveAnchorCandidates(figObject, vector);
        return vector;
    }

    private static void buildSmartMoveAnchorCandidates(FigObject figObject, Vector vector) {
        if (figObject instanceof FigRectangle) {
            vector.addElement(figObject.getBbox());
        } else if (figObject instanceof FigCompound) {
            Enumeration enumeration = ((FigCompound)figObject).getMembers().elements();
            while (enumeration.hasMoreElements()) {
                FigObject figObject2 = (FigObject)enumeration.nextElement();
                MoveObjectCommand.buildSmartMoveAnchorCandidates(figObject2, vector);
            }
        }
    }

    public boolean checkMovePoint(FigBbox figBbox, Point point, int n, int n2) {
        int n3 = figBbox.getXl();
        int n4 = figBbox.getXr();
        int n5 = figBbox.getYt();
        int n6 = figBbox.getYb();
        if (point.x == n3 && point.y >= n5 && point.y <= n6 || point.x == n4 && point.y >= n5 && point.y <= n6 || point.y == n5 && point.x >= n3 && point.x <= n4 || point.y == n6 && point.x >= n3 && point.x <= n4) {
            point.x += n;
            point.y += n2;
            return true;
        }
        return false;
    }

    public void undo() {
        if (this.object != null) {
            this.checkSmartLinksMove(this.object, -this.dx, -this.dy);
            this.object.move(-this.dx, -this.dy);
            this.objectCanvas.doFullRedraw();
        }
    }

    public void mousePressed(FigCanvasEvent figCanvasEvent) {
        Point point = figCanvasEvent.getWorldCoordinatePoint();
        Point point2 = figCanvasEvent.getScreenCoordinatePoint();
        if (this.n_points == 0) {
            if (MouseMapper.isRightClick(figCanvasEvent)) {
                return;
            }
            this.object = this.editor.findObjectAt(point);
            if (this.object == null) {
                this.statusMessage("No object found at that position! L: move object,   M: horiz/vert move");
                return;
            }
            this.statusMessage("L: put object,   R: cancel");
            ++this.n_points;
            this.startPoint = new Point(point);
            this.object.select();
            if (MouseMapper.isMiddleClick(figCanvasEvent)) {
                this.setRubberbanding(this.object, point2);
                this.objectCanvas.changeRubberbandMode(13);
                this.restricted = true;
            } else {
                this.setRubberbanding(this.object, point2);
                this.restricted = false;
            }
        } else if (MouseMapper.isRightClick(figCanvasEvent)) {
            this.n_points = 0;
            if (this.object != null) {
                this.object.showPoints();
            }
            this.object = null;
            this.objectCanvas.changeRubberbandMode(1);
            this.objectCanvas.doFullRedraw();
            this.statusMessage("L: move object,   M: horiz/vert move");
        } else if (!MouseMapper.isMiddleClick(figCanvasEvent)) {
            if (MouseMapper.isShiftDown(figCanvasEvent) && point.equals(this.startPoint)) {
                this.message("-I- trying to find the next stacked object...");
                if (this.object != null) {
                    this.object.deselect();
                }
                this.object = this.editor.findNextObjectAt(point, this.object);
                if (this.object == null) {
                    return;
                }
                this.object.select();
                this.objectCanvas.doFullRedraw();
                this.setRubberbanding(this.object, point2);
            } else {
                this.endPoint = new Point(point);
                this.objectCanvas.changeRubberbandMode(1);
                this.smartLinksMode = this.getSmartLinksMode(this.editor);
                this.execute();
                this.ready = true;
                this.notifyEditor();
            }
        }
    }

    private int getSmartLinksMode(FigBasicEditor figBasicEditor) {
        int n = 0;
        try {
            Object[] objectArray = new Object[]{};
            Class[] classArray = new Class[]{};
            Method method = figBasicEditor.getClass().getMethod("getSmartLinksMode", classArray);
            Object object = method.invoke((Object)figBasicEditor, objectArray);
            n = (Integer)object;
        }
        catch (Exception exception) {
            this.message("-E- MoveObjectCommand.getSmartLinksMode: " + exception);
        }
        return n;
    }

    private void setRubberbanding(FigObject figObject, Point point) {
        this.objectCanvas.setRubberbandBasePoint(point);
        this.objectCanvas.changeRubberbandMode(5, this.objectCanvas.getTrafo(), figObject.getBbox());
    }

    public String getDescription() {
        return "move object";
    }

    public String toString() {
        return "jfig.commands.MoveObjectCommand[]";
    }

    public MoveObjectCommand(FigBasicEditor figBasicEditor, FigCanvas figCanvas) {
        super(figBasicEditor, figCanvas);
        this.statusMessage("L: move object,   M: horiz/vert move");
        figBasicEditor.showAllObjectCorners();
        figCanvas.changeRubberbandMode(1);
        this.n_points = 0;
        this.ready = false;
    }
}

