/*
 * Decompiled with CFR 0.152.
 */
package jfig.commands;

import java.awt.Point;
import jfig.canvas.FigCanvas;
import jfig.canvas.FigCanvasEvent;
import jfig.commands.Command;
import jfig.commands.FigBasicEditor;
import jfig.objects.FigBaseobject;
import jfig.objects.FigObject;

public class InsertPointCommand
extends Command {
    protected int n_points;
    protected FigObject object;
    protected Point oldPos;
    protected Point newPos;
    protected Point baseVertex;
    protected Point[] origPoints;

    public FigObject[] getModifiedObjects() {
        FigObject[] figObjectArray = new FigObject[]{this.object};
        return figObjectArray;
    }

    public void execute() {
        if (this.object != null) {
            this.origPoints = FigBaseobject.clonePoints(this.object.getPoints());
            this.object.insertPoint(this.newPos, this.baseVertex);
            this.editor.getUndoStack().push(this);
            this.objectCanvas.doFullRedraw();
        }
    }

    public void undo() {
        if (this.object != null) {
            this.object.setPoints(this.origPoints);
            this.objectCanvas.doFullRedraw();
        }
    }

    public void mousePressed(FigCanvasEvent figCanvasEvent) {
        Point point = figCanvasEvent.getWorldCoordinatePoint();
        Point point2 = figCanvasEvent.getScreenCoordinatePoint();
        if (this.n_points == 0) {
            this.object = this.editor.findObjectAt(point);
            if (this.object == null) {
                this.statusMessage("Please click directly on the object  where to insert the point");
                return;
            }
            if (!this.object.supportsPointOps()) {
                this.statusMessage("Cannot insert points on that object!");
                return;
            }
            this.oldPos = new Point(point);
            Point[] pointArray = this.object.getNeighborPoints(this.oldPos);
            point2 = this.objectCanvas.getTrafo().wc_to_screen(pointArray[0], point2);
            this.objectCanvas.setRubberbandBasePoint(point2);
            point2 = this.objectCanvas.getTrafo().wc_to_screen(pointArray[1], point2);
            this.objectCanvas.setRubberbandBasePoint2(point2);
            this.objectCanvas.changeRubberbandMode(3);
            this.baseVertex = new Point(pointArray[0]);
            this.n_points = 1;
        } else {
            this.newPos = new Point(point);
            this.objectCanvas.changeRubberbandMode(1);
            this.execute();
            this.ready = true;
            this.notifyEditor();
        }
    }

    public String getDescription() {
        return "insert point";
    }

    public String toString() {
        return "jfig.commands.InsertPointCommand[]";
    }

    public InsertPointCommand(FigBasicEditor figBasicEditor, FigCanvas figCanvas) {
        super(figBasicEditor, figCanvas);
        this.statusMessage("Click on the polyline where to insert a point!");
        figBasicEditor.showAllObjectCorners();
        figCanvas.changeRubberbandMode(1);
        this.oldPos = null;
        this.newPos = null;
        this.baseVertex = null;
        this.n_points = 0;
        this.ready = false;
    }
}

