/*
 * Decompiled with CFR 0.152.
 */
package jfig.commands;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import jfig.canvas.FigCanvas;
import jfig.canvas.FigCanvasEvent;
import jfig.commands.Command;
import jfig.commands.FigBasicEditor;
import jfig.gui.ModularEditor;
import jfig.objects.FigObject;
import jfig.utils.AntiDeadlock;

public class EditCommentCommand
extends Command {
    protected static EditCommentDialog editCommentDialog = null;
    protected Frame frame;
    protected FigObject object;
    protected Point P1;
    protected int n_points;
    protected String newComment = null;
    protected String oldComment = null;

    public FigObject[] getModifiedObjects() {
        FigObject[] figObjectArray = new FigObject[]{this.object};
        return figObjectArray;
    }

    public void execute() {
        if (this.object != null && this.newComment != null) {
            this.object.setComment(this.newComment);
            this.editor.addTmpObject(null);
            this.editor.getUndoStack().push(this);
        }
    }

    public void undo() {
        if (this.object != null && this.oldComment != null) {
            this.object.setComment(this.oldComment);
        }
    }

    public void mousePressed(FigCanvasEvent figCanvasEvent) {
        Point point = figCanvasEvent.getWorldCoordinatePoint();
        Point point2 = figCanvasEvent.getScreenCoordinatePoint();
        this.object = this.editor.findObjectAt(point);
        if (this.object == null) {
            this.statusMessage("No object at that position. Please click directly on the object to edit (its comment)");
            return;
        }
        this.createShowEditCommentDialog(this.object);
    }

    private void createShowEditCommentDialog(FigObject figObject) {
        if (editCommentDialog == null) {
            EditCommentCommand editCommentCommand = this;
            if (editCommentCommand == null) {
                throw null;
            }
            editCommentDialog = editCommentCommand.new EditCommentDialog(this.frame);
        }
        this.oldComment = this.newComment = figObject.getComment();
        editCommentDialog.setCommand(this);
        editCommentDialog.show();
        AntiDeadlock.sleep(100L);
    }

    public String getDescription() {
        return "edit object comment";
    }

    public String toString() {
        return "jfig.commands.EditCommentCommand[]";
    }

    public EditCommentCommand(FigBasicEditor figBasicEditor, FigCanvas figCanvas) {
        super(figBasicEditor, figCanvas);
        try {
            this.frame = ((ModularEditor)figBasicEditor).getFrame();
        }
        catch (Throwable throwable) {
            this.frame = new Frame("Dummy Frame");
            this.frame.setSize(new Dimension(100, 100));
        }
        this.statusMessage("Click on the object to edit (comment):");
        figBasicEditor.showAllObjectCorners();
        figCanvas.changeRubberbandMode(1);
        this.n_points = 0;
        this.ready = false;
    }

    class EditCommentDialog
    extends JDialog
    implements ActionListener,
    WindowListener {
        private EditCommentCommand command;
        private JTextArea textArea = new JTextArea(5, 40);
        private JButton okButton;
        private JButton cancelButton;
        private JPanel buttonPanel;
        private JScrollPane scroller = new JScrollPane(this.textArea);

        public void setCommand(EditCommentCommand editCommentCommand) {
            this.command = editCommentCommand;
            this.textArea.setText(editCommentCommand.oldComment);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.cancelButton) {
                this.setVisible(false);
            } else if (actionEvent.getSource() == this.okButton) {
                if (this.command != null) {
                    String string;
                    this.command.newComment = string = this.textArea.getText();
                    this.command.execute();
                    this.command.ready = true;
                }
                this.setVisible(false);
            } else {
                System.out.println("-E- ECDialog: unknown event source " + actionEvent);
            }
        }

        public void windowOpened(WindowEvent windowEvent) {
        }

        public void windowClosing(WindowEvent windowEvent) {
            this.setVisible(false);
        }

        public void windowClosed(WindowEvent windowEvent) {
        }

        public void windowIconified(WindowEvent windowEvent) {
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        public void windowActivated(WindowEvent windowEvent) {
        }

        public void windowDeactivated(WindowEvent windowEvent) {
        }

        public EditCommentDialog(Frame frame) {
            super(EditCommentCommand.this.frame, "Edit object comment", false);
            this.okButton = new JButton("OK");
            this.cancelButton = new JButton("Cancel");
            this.buttonPanel = new JPanel(new FlowLayout(2));
            this.buttonPanel.add(this.cancelButton);
            this.buttonPanel.add(this.okButton);
            this.getContentPane().add("Center", this.scroller);
            this.getContentPane().add("South", this.buttonPanel);
            this.pack();
            this.okButton.addActionListener(this);
            this.cancelButton.addActionListener(this);
        }
    }
}

