/*
 * Decompiled with CFR 0.152.
 */
package jfig.commands;

import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import jfig.canvas.FigCanvas;
import jfig.canvas.FigCanvasEvent;
import jfig.commands.Command;
import jfig.commands.FigBasicEditor;
import jfig.objects.FigBbox;
import jfig.objects.FigCompound;
import jfig.objects.FigObject;
import jfig.objects.FigWriter;
import jfig.utils.MouseMapper;

public class CutToClipboardCommand
extends Command {
    protected FigCompound compound;
    protected Point P1;
    protected Point P2;
    protected boolean hasUnfinishedRegion;

    public FigObject[] getModifiedObjects() {
        FigObject[] figObjectArray = new FigObject[]{this.compound};
        return figObjectArray;
    }

    public void execute() {
        FigObject figObject;
        if (this.compound == null) {
            return;
        }
        boolean bl = false;
        Object object = this.compound.getMembers().elements();
        while (object.hasMoreElements()) {
            bl = true;
            figObject = (FigObject)object.nextElement();
            figObject.deselect();
        }
        if (!bl) {
            return;
        }
        object = this.compound.getMembers().elements();
        while (object.hasMoreElements()) {
            figObject = (FigObject)object.nextElement();
            this.editor.deleteFromObjectList(figObject);
        }
        this.statusMessage("Writing figure to clipboard buffer...");
        object = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)object);
        FigWriter figWriter = new FigWriter();
        figWriter.write_fig31_file(dataOutputStream, true, this.compound.getMembers());
        StringSelection stringSelection = new StringSelection(((ByteArrayOutputStream)object).toString());
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, stringSelection);
        this.compound = null;
        this.statusMessage("cut to clipboard ready. Please select a command.");
        this.objectCanvas.doFullRedraw();
    }

    public void undo() {
        this.statusMessage("Use 'paste' to undo a 'cut to clipboard' command!");
    }

    public void mousePressed(FigCanvasEvent figCanvasEvent) {
        Point point = figCanvasEvent.getWorldCoordinatePoint();
        Point point2 = figCanvasEvent.getScreenCoordinatePoint();
        if (this.compound == null) {
            this.compound = new FigCompound();
            this.compound.setTrafo(this.objectCanvas.getTrafo());
        }
        if (MouseMapper.isRightClick(figCanvasEvent)) {
            if (this.hasUnfinishedRegion) {
                this.P2 = new Point(point);
                this.handleRegion(this.P1, this.P2);
                this.hasUnfinishedRegion = false;
            }
            this.execute();
            this.ready = true;
            this.notifyEditor();
        } else if (this.hasUnfinishedRegion) {
            this.P2 = new Point(point);
            this.handleRegion(this.P1, this.P2);
            this.hasUnfinishedRegion = false;
        } else if (MouseMapper.isMiddleClick(figCanvasEvent)) {
            this.P1 = new Point(point);
            this.statusMessage("Click on the region's opposite corner ");
            this.objectCanvas.setRubberbandBasePoint(point2);
            this.objectCanvas.changeRubberbandMode(4);
            this.objectCanvas.doSimpleRedraw();
            this.hasUnfinishedRegion = true;
        } else {
            FigObject figObject = this.editor.findObjectAt(point);
            if (figObject == null) {
                return;
            }
            if (this.compound.isMember(figObject)) {
                this.compound.deleteMember(figObject);
                figObject.showPoints();
            } else {
                this.compound.addMember(figObject);
                figObject.select();
            }
            this.objectCanvas.doFullRedraw();
        }
    }

    private void handleRegion(Point point, Point point2) {
        this.objectCanvas.changeRubberbandMode(1);
        FigBbox figBbox = new FigBbox(point, point2);
        Enumeration enumeration = this.editor.getObjects();
        while (enumeration.hasMoreElements()) {
            FigObject figObject = (FigObject)enumeration.nextElement();
            if (!figObject.getBbox().inside(figBbox)) continue;
            if (this.compound.isMember(figObject)) {
                this.compound.deleteMember(figObject);
                figObject.showPoints();
                continue;
            }
            this.compound.addMember(figObject);
            figObject.select();
        }
        this.objectCanvas.doFullRedraw();
    }

    public String getDescription() {
        return "cut to clipboard";
    }

    public String toString() {
        return "jfig.commands.CutToClipboardCommand[]";
    }

    public CutToClipboardCommand(FigBasicEditor figBasicEditor, FigCanvas figCanvas) {
        super(figBasicEditor, figCanvas);
        this.statusMessage("Cut to clipboard: L: select object, M: select region, R: finish ");
        figBasicEditor.showAllObjectCorners();
        figCanvas.changeRubberbandMode(1);
        this.compound = null;
        this.hasUnfinishedRegion = false;
        this.ready = false;
    }
}

