/*
 * Decompiled with CFR 0.152.
 */
package jfig.commands;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import jfig.canvas.FigCanvas;
import jfig.canvas.FigCanvasEvent;
import jfig.canvas.FigTrafo2D;
import jfig.commands.Command;
import jfig.commands.FigBasicEditor;
import jfig.gui.EditTriggerDialog;
import jfig.gui.ModularEditor;
import jfig.objects.FigAttribs;
import jfig.objects.FigObject;
import jfig.objects.FigTrigger;

public class CreateTriggerCommand
extends Command {
    static Frame frame;
    static EditTriggerDialog editTriggerDialog;
    static String lastBasename;
    static String lastFilename;
    protected int n_points;
    protected FigTrigger trigger;
    protected FigAttribs attribs;
    protected Point P1;
    protected Point P2;

    public FigObject[] getModifiedObjects() {
        FigObject[] figObjectArray = new FigObject[]{this.trigger};
        return figObjectArray;
    }

    public void execute() {
        FigTrafo2D figTrafo2D = this.objectCanvas.getTrafo();
        this.trigger = new FigTrigger(this.P1.x, this.P1.y, this.P2.x, this.P2.y, this.attribs, figTrafo2D, lastBasename, lastFilename);
        if (this.trigger != null) {
            if (editTriggerDialog == null) {
                try {
                    frame = ((ModularEditor)this.editor).getFrame();
                }
                catch (Exception exception) {
                    frame = new Frame("Dummy Frame");
                    frame.setSize(new Dimension(100, 100));
                }
                editTriggerDialog = new EditTriggerDialog(this.trigger, this.editor, frame);
            }
            editTriggerDialog.setTriggerObject(this.trigger);
            editTriggerDialog.show();
            lastBasename = this.trigger.getBasename();
            lastFilename = this.trigger.getFilename();
            this.trigger.setVisible(true);
            this.editor.insertIntoObjectList(this.trigger);
            this.editor.getUndoStack().push(this);
            this.objectCanvas.doFullRedraw();
        }
    }

    public void undo() {
        if (this.trigger != null) {
            this.editor.deleteFromObjectList(this.trigger);
            this.objectCanvas.doFullRedraw();
        }
    }

    public void mousePressed(FigCanvasEvent figCanvasEvent) {
        Point point = figCanvasEvent.getWorldCoordinatePoint();
        Point point2 = figCanvasEvent.getScreenCoordinatePoint();
        if (this.n_points == 0) {
            this.P1 = new Point(point);
            this.objectCanvas.setRubberbandBasePoint(point2);
            this.objectCanvas.changeRubberbandMode(4);
            this.objectCanvas.doSimpleRedraw();
            this.statusMessage("Click on the opposite trigger corner");
            ++this.n_points;
        } else {
            this.P2 = new Point(point);
            this.objectCanvas.changeRubberbandMode(1);
            this.attribs = this.editor.getCurrentAttribs().getClone();
            this.execute();
            this.ready = true;
            this.notifyEditor();
        }
    }

    public String getDescription() {
        return "create trigger";
    }

    public String toString() {
        return "jfig.commands.CreateTriggerCommand[]";
    }

    public CreateTriggerCommand(FigBasicEditor figBasicEditor, FigCanvas figCanvas) {
        super(figBasicEditor, figCanvas);
        this.statusMessage("Click on the first trigger (active field) corner!");
        figBasicEditor.hideAllObjectCorners();
        figCanvas.changeRubberbandMode(1);
        this.n_points = 0;
        this.ready = false;
    }

    static {
        lastBasename = "http://tech-www/applets/jfig/";
        lastFilename = "index.fig";
    }
}

