/*
 * Decompiled with CFR 0.152.
 */
package jfig.commands;

import java.awt.Point;
import java.lang.reflect.Method;
import jfig.canvas.FigCanvas;
import jfig.canvas.FigCanvasEvent;
import jfig.canvas.FigTrafo2D;
import jfig.commands.Command;
import jfig.commands.FigBasicEditor;
import jfig.objects.FigAttribs;
import jfig.objects.FigObject;
import jfig.objects.FigPolyline;
import jfig.utils.GeometryManager;
import jfig.utils.MouseMapper;

public class CreatePolygonCommand
extends Command {
    protected int n_points;
    protected FigPolyline polygon;
    protected GeometryManager geometryManager;
    protected int geometryMode;

    public FigObject[] getModifiedObjects() {
        FigObject[] figObjectArray = new FigObject[]{this.polygon};
        return figObjectArray;
    }

    public void execute() {
        if (this.polygon != null) {
            this.editor.insertIntoObjectList(this.polygon);
            this.editor.deleteTmpObject(this.polygon);
            this.editor.getUndoStack().push(this);
            this.objectCanvas.doFullRedraw();
        }
    }

    public void undo() {
        if (this.polygon != null) {
            this.editor.deleteFromObjectList(this.polygon);
            this.objectCanvas.doFullRedraw();
        }
    }

    public void cancel() {
        if (this.polygon != null) {
            this.editor.deleteTmpObject(this.polygon);
        }
        this.objectCanvas.doFullRedraw();
    }

    public void mousePressed(FigCanvasEvent figCanvasEvent) {
        Point point = figCanvasEvent.getWorldCoordinatePoint();
        Point point2 = figCanvasEvent.getScreenCoordinatePoint();
        if (this.n_points == 0) {
            FigAttribs figAttribs = this.editor.getCurrentAttribs().getClone();
            FigTrafo2D figTrafo2D = this.objectCanvas.getTrafo();
            this.polygon = new FigPolyline(point.x, point.y, true, figAttribs, figTrafo2D);
            this.editor.addTmpObject(this.polygon);
            this.geometryMode = this.getGeometryMode();
            if (this.geometryMode == 0) {
                this.objectCanvas.setRubberbandBasePoint(point2);
                this.objectCanvas.changeRubberbandMode(2);
            } else {
                this.geometryManager = new GeometryManager();
                this.geometryManager.setMode(this.geometryMode);
                this.objectCanvas.setRubberbandBasePoint(point2);
                this.objectCanvas.changeRubberbandMode(15, this.geometryManager);
            }
            this.objectCanvas.doSimpleRedraw();
            this.statusMessage("L: next point, M: final point, R: cancel");
            ++this.n_points;
        } else if (MouseMapper.isMiddleClick(figCanvasEvent) || MouseMapper.isShiftDown(figCanvasEvent)) {
            if (this.geometryMode == 0) {
                this.polygon.appendPoint(point);
            } else {
                Point point3 = this.getGeometryManagedPoint(point);
                this.polygon.appendPoint(point3);
            }
            this.objectCanvas.changeRubberbandMode(1);
            this.execute();
            this.ready = true;
            this.notifyEditor();
        } else if (MouseMapper.isRightClick(figCanvasEvent)) {
            this.n_points = 0;
            if (this.polygon != null) {
                this.editor.deleteTmpObject(this.polygon);
            }
            this.polygon = null;
            this.objectCanvas.changeRubberbandMode(1);
            this.objectCanvas.doFullRedraw();
            this.statusMessage("L: first polygon point");
        } else {
            if (this.geometryMode == 0) {
                this.polygon.appendPoint(point);
                this.objectCanvas.setRubberbandBasePoint(point2);
            } else {
                Point point4 = this.getGeometryManagedPoint(point);
                this.polygon.appendPoint(point4);
                this.objectCanvas.setRubberbandBasePoint(this.objectCanvas.getTrafo().getScreenCoords(point4));
            }
            this.objectCanvas.doSimpleRedraw();
            this.statusMessage("L: next point, M: final point, R: cancel");
            ++this.n_points;
        }
    }

    public int getGeometryMode() {
        int n = 0;
        try {
            Object[] objectArray = new Object[]{};
            Class[] classArray = new Class[]{};
            Method method = this.editor.getClass().getMethod("getGeometryMode", classArray);
            Object object = method.invoke((Object)this.editor, objectArray);
            n = (Integer)object;
        }
        catch (Exception exception) {
            System.err.println("-E- CreatePolylineCommand.getGeometryMode: " + exception);
        }
        return n;
    }

    public Point getGeometryManagedPoint(Point point) {
        Point[] pointArray = this.polygon.getPoints();
        Point point2 = pointArray[pointArray.length - 1];
        return this.geometryManager.getNearestAllowedPoint(point2, point);
    }

    public String getDescription() {
        return "create polygon";
    }

    public String toString() {
        return "jfig.commands.CreatePolygonCommand[]";
    }

    public CreatePolygonCommand(FigBasicEditor figBasicEditor, FigCanvas figCanvas) {
        super(figBasicEditor, figCanvas);
        this.statusMessage("L: first polygon point");
        figBasicEditor.hideAllObjectCorners();
        figCanvas.changeRubberbandMode(1);
        this.n_points = 0;
        this.ready = false;
    }
}

