/*
 * Decompiled with CFR 0.152.
 */
package jfig.commands;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import jfig.canvas.FigCanvas;
import jfig.canvas.FigCanvasEvent;
import jfig.canvas.FigTrafo2D;
import jfig.commands.Command;
import jfig.commands.FigBasicEditor;
import jfig.objects.FigAttribs;
import jfig.objects.FigObject;
import jfig.objects.FigPolyline;

public class CreateFreehandCommand
extends Command
implements MouseListener,
MouseMotionListener {
    protected int n_points;
    protected FigPolyline polyline;

    public FigObject[] getModifiedObjects() {
        FigObject[] figObjectArray = new FigObject[]{this.polyline};
        return figObjectArray;
    }

    public void execute() {
        if (this.polyline != null) {
            this.editor.insertIntoObjectList(this.polyline);
            this.editor.deleteTmpObject(this.polyline);
            this.editor.getUndoStack().push(this);
            this.objectCanvas.doFullRedraw();
        }
    }

    public void undo() {
        if (this.polyline != null) {
            this.editor.deleteFromObjectList(this.polyline);
            this.objectCanvas.doFullRedraw();
        }
    }

    public void mousePressed(FigCanvasEvent figCanvasEvent) {
        Point point = figCanvasEvent.getWorldCoordinatePoint();
        Point point2 = figCanvasEvent.getScreenCoordinatePoint();
        FigAttribs figAttribs = this.editor.getCurrentAttribs().getClone();
        FigTrafo2D figTrafo2D = this.objectCanvas.getTrafo();
        this.polyline = new FigPolyline(point.x, point.y, false, figAttribs, figTrafo2D);
        this.editor.addTmpObject(this.polyline);
        this.objectCanvas.setRubberbandBasePoint(point2);
        this.objectCanvas.changeRubberbandMode(1);
        this.objectCanvas.doSimpleRedraw();
        this.statusMessage("L: draw line, release mouse: finish line");
        ++this.n_points;
        this.objectCanvas.getComponent().addMouseListener(this);
        this.objectCanvas.getComponent().addMouseMotionListener(this);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        Point point = this.objectCanvas.getTrafo().getWorldCoords(mouseEvent.getX(), mouseEvent.getY());
        this.polyline.appendPoint(point);
        this.objectCanvas.paint(this.polyline);
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.objectCanvas.getComponent().removeMouseMotionListener(this);
        this.objectCanvas.getComponent().removeMouseListener(this);
        this.objectCanvas.changeRubberbandMode(1);
        this.execute();
        this.ready = true;
        this.notifyEditor();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public String getDescription() {
        return "create freehand line";
    }

    public String toString() {
        return "jfig.commands.CreateFreehandCommand[]";
    }

    public CreateFreehandCommand(FigBasicEditor figBasicEditor, FigCanvas figCanvas) {
        super(figBasicEditor, figCanvas);
        this.statusMessage("L: first point, drag mouse to draw, release mouse: finish line");
        figBasicEditor.hideAllObjectCorners();
        figCanvas.changeRubberbandMode(1);
        this.n_points = 0;
        this.ready = false;
    }
}

