/*
 * Decompiled with CFR 0.152.
 */
package jfig.commands;

import java.awt.Point;
import jfig.canvas.FigCanvas;
import jfig.canvas.FigCanvasEvent;
import jfig.canvas.FigTrafo2D;
import jfig.commands.Command;
import jfig.commands.FigBasicEditor;
import jfig.objects.FigAttribs;
import jfig.objects.FigEllipse;
import jfig.objects.FigObject;
import jfig.utils.MouseMapper;

public class CreateEllipseCommand
extends Command {
    protected int n_points;
    protected FigObject ellipse;
    protected FigAttribs attribs;
    protected Point P1;
    protected Point P2;

    public FigObject[] getModifiedObjects() {
        FigObject[] figObjectArray = new FigObject[]{this.ellipse};
        return figObjectArray;
    }

    public void execute() {
        FigTrafo2D figTrafo2D = this.objectCanvas.getTrafo();
        this.ellipse = new FigEllipse(this.P1, this.P2, this.attribs, figTrafo2D);
        if (this.ellipse != null) {
            this.editor.insertIntoObjectList(this.ellipse);
            this.editor.getUndoStack().push(this);
            this.objectCanvas.doFullRedraw();
        }
    }

    public void undo() {
        if (this.ellipse != null) {
            this.editor.deleteFromObjectList(this.ellipse);
            this.objectCanvas.doFullRedraw();
        }
    }

    public void mousePressed(FigCanvasEvent figCanvasEvent) {
        Point point = figCanvasEvent.getWorldCoordinatePoint();
        Point point2 = figCanvasEvent.getScreenCoordinatePoint();
        if (this.n_points == 0) {
            this.P1 = new Point(point);
            this.objectCanvas.setRubberbandBasePoint(point2);
            this.objectCanvas.changeRubberbandMode(7);
            this.objectCanvas.doSimpleRedraw();
            this.statusMessage("L: set ellipse radii, R: cancel");
            ++this.n_points;
        } else if (!MouseMapper.isMiddleClick(figCanvasEvent)) {
            if (MouseMapper.isRightClick(figCanvasEvent)) {
                this.n_points = 0;
                if (this.ellipse != null) {
                    this.editor.deleteTmpObject(this.ellipse);
                }
                this.ellipse = null;
                this.objectCanvas.changeRubberbandMode(1);
                this.objectCanvas.doFullRedraw();
                this.statusMessage("L: ellipse center");
            } else {
                this.P2 = new Point(point);
                this.objectCanvas.changeRubberbandMode(1);
                this.attribs = this.editor.getCurrentAttribs().getClone();
                this.execute();
                this.ready = true;
                this.notifyEditor();
            }
        }
    }

    public String getDescription() {
        return "create ellipse";
    }

    public String toString() {
        return "jfig.commands.CreateEllipseCommand[]";
    }

    public CreateEllipseCommand(FigBasicEditor figBasicEditor, FigCanvas figCanvas) {
        super(figBasicEditor, figCanvas);
        this.statusMessage("L: ellipse center");
        figBasicEditor.hideAllObjectCorners();
        figCanvas.changeRubberbandMode(1);
        this.n_points = 0;
        this.ready = false;
    }
}

