/*
 * Decompiled with CFR 0.152.
 */
package jfig.commands;

import java.awt.Point;
import java.util.Enumeration;
import jfig.canvas.FigCanvas;
import jfig.canvas.FigCanvasEvent;
import jfig.commands.Command;
import jfig.commands.FigBasicEditor;
import jfig.objects.FigBbox;
import jfig.objects.FigCompound;
import jfig.objects.FigObject;
import jfig.utils.MouseMapper;

public class CreateCompoundCommand
extends Command {
    protected FigCompound compound;
    protected Point P1;
    protected Point P2;
    protected boolean hasUnfinishedRegion;

    public FigObject[] getModifiedObjects() {
        FigObject[] figObjectArray = new FigObject[]{this.compound};
        return figObjectArray;
    }

    public void execute() {
        if (this.compound == null) {
            return;
        }
        boolean bl = false;
        Enumeration enumeration = this.compound.getMembers().elements();
        while (enumeration.hasMoreElements()) {
            bl = true;
            FigObject figObject = (FigObject)enumeration.nextElement();
            figObject.deselect();
            this.editor.deleteFromObjectList(figObject);
        }
        if (bl) {
            this.editor.insertIntoObjectList(this.compound);
        }
        this.editor.getUndoStack().push(this);
        this.objectCanvas.doFullRedraw();
    }

    public void undo() {
        if (this.compound == null) {
            return;
        }
        Enumeration enumeration = this.compound.getMembers().elements();
        while (enumeration.hasMoreElements()) {
            FigObject figObject = (FigObject)enumeration.nextElement();
            this.editor.insertIntoObjectList(figObject);
        }
        this.editor.deleteFromObjectList(this.compound);
        this.objectCanvas.doFullRedraw();
    }

    public void mousePressed(FigCanvasEvent figCanvasEvent) {
        Point point = figCanvasEvent.getWorldCoordinatePoint();
        Point point2 = figCanvasEvent.getScreenCoordinatePoint();
        if (this.compound == null) {
            this.compound = new FigCompound();
            this.compound.setTrafo(this.objectCanvas.getTrafo());
        }
        if (MouseMapper.isRightClick(figCanvasEvent)) {
            if (this.hasUnfinishedRegion) {
                this.P2 = new Point(point);
                this.handleRegion(this.P1, this.P2);
                this.hasUnfinishedRegion = false;
            }
            this.execute();
            this.ready = true;
            this.notifyEditor();
        } else if (this.hasUnfinishedRegion) {
            this.P2 = new Point(point);
            this.handleRegion(this.P1, this.P2);
            this.hasUnfinishedRegion = false;
        } else if (MouseMapper.isMiddleClick(figCanvasEvent)) {
            this.P1 = new Point(point);
            this.statusMessage("L: opposite corner");
            this.objectCanvas.setRubberbandBasePoint(point2);
            this.objectCanvas.changeRubberbandMode(4);
            this.objectCanvas.doSimpleRedraw();
            this.hasUnfinishedRegion = true;
        } else {
            FigObject figObject = this.editor.findObjectAt(point);
            if (figObject == null) {
                return;
            }
            if (this.compound.isMember(figObject)) {
                this.compound.deleteMember(figObject);
                figObject.showPoints();
            } else {
                this.compound.addMember(figObject);
                figObject.select();
            }
            this.statusMessage("L: tag object, M: tag region, R: finish compound");
            this.objectCanvas.doFullRedraw();
        }
    }

    private void handleRegion(Point point, Point point2) {
        this.objectCanvas.changeRubberbandMode(1);
        FigBbox figBbox = new FigBbox(point, point2);
        Enumeration enumeration = this.editor.getObjects();
        while (enumeration.hasMoreElements()) {
            FigObject figObject = (FigObject)enumeration.nextElement();
            if (!figObject.getBbox().inside(figBbox)) continue;
            if (this.compound.isMember(figObject)) {
                this.compound.deleteMember(figObject);
                figObject.showPoints();
                continue;
            }
            this.compound.addMember(figObject);
            figObject.select();
        }
        this.statusMessage("L: tag object, M: tag region, R: finish compound");
        this.objectCanvas.doFullRedraw();
    }

    public String getDescription() {
        return "create compound";
    }

    public String toString() {
        return "jfig.commands.CreateCompoundCommand[]";
    }

    public CreateCompoundCommand(FigBasicEditor figBasicEditor, FigCanvas figCanvas) {
        super(figBasicEditor, figCanvas);
        this.statusMessage("L: tag object, M: tag region, R: finish compound");
        figBasicEditor.showAllObjectCorners();
        figCanvas.changeRubberbandMode(1);
        this.compound = null;
        this.hasUnfinishedRegion = false;
        this.ready = false;
    }
}

