/*
 * Decompiled with CFR 0.152.
 */
package jfig.commands;

import java.awt.Point;
import jfig.canvas.FigCanvas;
import jfig.canvas.FigCanvasEvent;
import jfig.canvas.FigTrafo2D;
import jfig.commands.Command;
import jfig.commands.FigBasicEditor;
import jfig.objects.FigAttribs;
import jfig.objects.FigEllipse;
import jfig.objects.FigObject;
import jfig.utils.MouseMapper;

public class CreateCircleCommand
extends Command {
    protected int n_points;
    protected FigObject circle;
    protected FigAttribs attribs;
    protected Point P1;
    protected Point P2;

    public FigObject[] getModifiedObjects() {
        FigObject[] figObjectArray = new FigObject[]{this.circle};
        return figObjectArray;
    }

    public void execute() {
        FigTrafo2D figTrafo2D = this.objectCanvas.getTrafo();
        int n = Math.max(Math.abs(this.P2.x - this.P1.x), Math.abs(this.P2.y - this.P1.y));
        Point point = new Point(this.P1.x + n, this.P1.y + n);
        this.circle = new FigEllipse(this.P1, point, this.attribs, figTrafo2D);
        if (this.circle != null) {
            this.editor.insertIntoObjectList(this.circle);
            this.editor.getUndoStack().push(this);
            this.objectCanvas.doFullRedraw();
        }
    }

    public void undo() {
        if (this.circle != null) {
            this.editor.deleteFromObjectList(this.circle);
            this.objectCanvas.doFullRedraw();
        }
    }

    public void mousePressed(FigCanvasEvent figCanvasEvent) {
        Point point = figCanvasEvent.getWorldCoordinatePoint();
        Point point2 = figCanvasEvent.getScreenCoordinatePoint();
        if (this.n_points == 0) {
            this.P1 = new Point(point);
            this.objectCanvas.setRubberbandBasePoint(point2);
            this.objectCanvas.changeRubberbandMode(6);
            this.objectCanvas.doSimpleRedraw();
            this.statusMessage("L: set radius, R: cancel");
            ++this.n_points;
        } else if (!MouseMapper.isMiddleClick(figCanvasEvent)) {
            if (MouseMapper.isRightClick(figCanvasEvent)) {
                this.n_points = 0;
                if (this.circle != null) {
                    this.editor.deleteTmpObject(this.circle);
                }
                this.circle = null;
                this.objectCanvas.changeRubberbandMode(1);
                this.objectCanvas.doFullRedraw();
                this.statusMessage("L: circle center");
            } else {
                this.P2 = new Point(point);
                this.objectCanvas.changeRubberbandMode(1);
                this.attribs = this.editor.getCurrentAttribs().getClone();
                this.execute();
                this.ready = true;
                this.notifyEditor();
            }
        }
    }

    public String getDescription() {
        return "create circle";
    }

    public String toString() {
        return "jfig.commands.CreateCircleCommand[]";
    }

    public CreateCircleCommand(FigBasicEditor figBasicEditor, FigCanvas figCanvas) {
        super(figBasicEditor, figCanvas);
        this.statusMessage("L: circle center");
        figBasicEditor.hideAllObjectCorners();
        figCanvas.changeRubberbandMode(1);
        this.n_points = 0;
        this.ready = false;
    }
}

